/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.cache;

import com.ecc.emp.core.Context;
import com.ecc.emp.data.DataElement;
import com.ecc.emp.data.DuplicatedDataNameException;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.InvalidArgumentException;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.data.ObjectNotFoundException;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.db.CacheDBFactory;
import com.yucheng.cmis.cache.db.CacheDBInterface;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.exception.CmisDaoException;
import com.yucheng.cmis.pub.CMISDomain;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheClient {
    private static final String LOGTYPE = "CacheDB";
    public static final String DICT_ATTR_ENNAME = "enname";
    public static final String DICT_ATTR_CNNAME = "cnname";
    public static final String KEY_SEPARATOR = ":";

    public static Object getConnection() {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        Object connection = cdb.getConnection();
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u8fde\u63a5", "", System.currentTimeMillis() - startTime);
        return connection;
    }

    public static Set<String> getKeys(String keyPattern) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        Set<String> keys = cdb.getKeys(keyPattern);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6key\u96c6\u5408", keyPattern, System.currentTimeMillis() - startTime);
        return keys;
    }

    public static boolean exist(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        boolean exist = cdb.exist(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u5224\u65adkey\u662f\u5426\u5b58\u5728", key, System.currentTimeMillis() - startTime);
        return exist;
    }

    public static void setSingleValue(String key, String value) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleValue(key, value);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2a\u503c", key, System.currentTimeMillis() - startTime);
    }

    public static void setMultiValue(Map<String, String> cacheMap) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setMultiValue(cacheMap);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u591a\u4e2a\u503c", cacheMap.keySet().toString(), System.currentTimeMillis() - startTime);
    }

    public static void setSingleDomain(String key, CMISDomain domain) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleDomain(key, domain);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2aDomain", key, System.currentTimeMillis() - startTime);
    }

    public static void setSingleStrMap(String key, Map<String, String> map) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleStrMap(key, map);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2aMap", key, System.currentTimeMillis() - startTime);
    }

    public static void setSingleMap(String key, Map<String, Object> map) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleMap(key, map);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2aMap", key, System.currentTimeMillis() - startTime);
    }

    public static <T extends CMISDomain> void setMultiDomain(Map<String, T> cacheMap) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setMultiDomain(cacheMap);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u591a\u4e2aDomain", cacheMap.keySet().toString(), System.currentTimeMillis() - startTime);
    }

    public static void setSingleList(String key, List<String> list) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleList(key, list);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2aList", key, System.currentTimeMillis() - startTime);
    }

    public static void setMultiList(Map<String, List<String>> cacheMap) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setMultiList(cacheMap);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u591a\u4e2aList", cacheMap.keySet().toString(), System.currentTimeMillis() - startTime);
    }

    public static <T extends CMISDomain> void setSingleDomainList(String key, List<T> list) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleDomainList(key, list);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2aDomain\u7684List", key, System.currentTimeMillis() - startTime);
    }

    public static <T extends CMISDomain> void setMultiDomainList(Map<String, List<T>> cacheMap) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setMultiDomainList(cacheMap);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u591a\u4e2aDomain\u7684List", cacheMap.keySet().toString(), System.currentTimeMillis() - startTime);
    }

    public static void addSingleList(String key, List<String> list) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.addSingleList(key, list);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u5355\u4e2aList\u7684Add", key, System.currentTimeMillis() - startTime);
    }

    public static <T extends CMISDomain> void addSingleDomainList(String key, List<T> list) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.addSingleDomainList(key, list);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u5355\u4e2aDomain\u7684List\u7684Add", key, System.currentTimeMillis() - startTime);
    }

    public static String getSingleValue(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        String singleValue = cdb.getSingleValue(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2a\u503c", key, System.currentTimeMillis() - startTime);
        return singleValue;
    }

    public static <T extends CMISDomain> T getSingleDomain(String key, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        T singleDomain = cdb.getSingleDomain(key, clazz);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aDomain", key, System.currentTimeMillis() - startTime);
        return singleDomain;
    }

    public static <T extends CMISDomain> List<T> getSingleDomains(String keyPattern, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        List<T> domains = cdb.getSingleDomains(keyPattern, clazz);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aDomain\u7684\u96c6\u5408", keyPattern, System.currentTimeMillis() - startTime);
        return domains;
    }

    public static Map<String, String> getSingleStrMap(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        Map<String, String> singleStrMap = cdb.getSingleStrMap(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aMap", key, System.currentTimeMillis() - startTime);
        return singleStrMap;
    }

    public static Map<String, Object> getSingleMap(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        Map<String, Object> singleMap = cdb.getSingleMap(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aMap", key, System.currentTimeMillis() - startTime);
        return singleMap;
    }

    public static List<String> getSingleList(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        List<String> singleList = cdb.getSingleList(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aList", key, System.currentTimeMillis() - startTime);
        return singleList;
    }

    public static <T extends CMISDomain> List<T> getSingleDomainList(String key, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        List<T> singleDomainList = cdb.getSingleDomainList(key, clazz);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aDoamin", key, System.currentTimeMillis() - startTime);
        return singleDomainList;
    }

    public static void deleteByKey(String keyPattern) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.deleteByKey(keyPattern);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u901a\u8fc7Key\u5339\u914d\u5220\u9664", keyPattern, System.currentTimeMillis() - startTime);
    }

    public static void setSingleListMap(String key, List<Map<String, String>> list) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleListMap(key, list);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2aMap\u7684List", key, System.currentTimeMillis() - startTime);
    }

    public static List<Map<String, String>> getSingleListMap(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        List<Map<String, String>> singleListMap = cdb.getSingleListMap(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u4e2aMap\u7684List", key, System.currentTimeMillis() - startTime);
        return singleListMap;
    }

    public static <T> void setSingleSerObject(String key, T object) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleSerObject(key, object);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2a\u53ef\u5e8f\u5217\u5316\u5bf9\u8c61", key, System.currentTimeMillis() - startTime);
    }

    public static void setSingleObjectByJson(String key, Object jsonObj) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setSingleObjectByJson(key, jsonObj);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2a\u53efJSON\u5bf9\u8c61", key, System.currentTimeMillis() - startTime);
    }

    public static <T> T getSingleObjectByJson(String key, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        T object = cdb.getSingleObjectByJson(key, clazz);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2a\u53efJSON\u5bf9\u8c61", key, System.currentTimeMillis() - startTime);
        return object;
    }

    public static <T extends Serializable> T getSingleSerObject(String key) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        Serializable singleSerObject = (Serializable)cdb.getSingleSerObject(key);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u5355\u4e2a\u53ef\u5e8f\u5217\u5316\u5bf9\u8c61", key, System.currentTimeMillis() - startTime);
        return (T)singleSerObject;
    }

    public static void setMultiValueByFlatMap(Map map, String type, String separator) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
        cdb.setMultiValueByFlatMap(map, type, separator);
        CacheClient.cacheClientLog(EMPLog.DEBUG, "Set\u6253\u5e73\u7684Map\u5bf9\u8c61", map.toString(), System.currentTimeMillis() - startTime);
    }

    public static IndexedCollection getDictByType(Context context, String type) throws Exception {
        long startTime = System.currentTimeMillis();
        String useCacheDb = CMISDaoPropertyManager.getInstance().getPropertyValue("cachedb.dict.enabled");
        if (useCacheDb != null && "1".equals(useCacheDb.trim())) {
            CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
            IndexedCollection iColl = new IndexedCollection();
            iColl.setName(type);
            List<String> singleList = cdb.getSingleList("dictColl:" + type);
            for (String dictJsonStr : singleList) {
                try {
                    JSONObject jsonObj = JSONObject.fromObject((Object)dictJsonStr);
                    String enName = jsonObj.getString(DICT_ATTR_ENNAME);
                    String cnName = jsonObj.getString(DICT_ATTR_CNNAME);
                    KeyedCollection kColl = new KeyedCollection();
                    kColl.setName(enName);
                    kColl.addDataField(DICT_ATTR_ENNAME, (Object)enName);
                    kColl.addDataField(DICT_ATTR_CNNAME, (Object)cnName);
                    iColl.addDataElement((DataElement)kColl);
                }
                catch (DuplicatedDataNameException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
            }
            CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5355\u7c7b\u578b\u5b57\u5178\u6570\u636e", type, System.currentTimeMillis() - startTime);
            if (iColl.size() == 0) {
                throw new ObjectNotFoundException(String.valueOf(type) + " \u7684\u5b57\u5178\u9879\u6ca1\u6709\u627e\u5230(cacheDB)");
            }
            return iColl;
        }
        IndexedCollection iColl = (IndexedCollection)context.getDataElement("dictColl." + type);
        return iColl;
    }

    @Deprecated
    public static KeyedCollection getAllDicts(Context context) throws Exception {
        long startTime = System.currentTimeMillis();
        String useCacheDb = CMISDaoPropertyManager.getInstance().getPropertyValue("cachedb.dict.enabled");
        if (useCacheDb != null && "1".equals(useCacheDb.trim())) {
            KeyedCollection dictColl = new KeyedCollection();
            dictColl.setName("dictColl");
            CacheDBInterface cdb = CacheDBFactory.getCacheDBClass();
            Set<String> keys = cdb.getKeys("dictColl:*");
            for (String key : keys) {
                try {
                    String type = key.replaceFirst("dictColl:", "");
                    IndexedCollection iColl = CacheClient.getDictByType(context, type);
                    dictColl.addDataElement((DataElement)iColl);
                }
                catch (DuplicatedDataNameException e) {
                    e.printStackTrace();
                }
            }
            CacheClient.cacheClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u5168\u90e8\u5b57\u5178\u6570\u636e", "dictColl:*", System.currentTimeMillis() - startTime);
            return dictColl;
        }
        KeyedCollection dictColl = (KeyedCollection)context.getDataElement("dictColl");
        return dictColl;
    }

    private static void cacheClientLog(int level, String method, String key, long useTime) {
        EMPLog.log((String)LOGTYPE, (int)level, (int)0, (String)("[" + method + "]:\u8017\u65f6" + useTime + "ms - " + key));
    }
}

