/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.restriction;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.dao.config.SqlConfig;
import com.yucheng.cmis.dao.config.SqlConfigLoader;
import com.yucheng.cmis.dao.restriction.CRTemplateInfo;
import com.yucheng.cmis.pub.util.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CRTemplateInfoLoad {
    private static final String DEFAULT_TEMPLATE_ID = "*";
    private static final String permissionFileName = "datapermission.xml";
    private static List<CRTemplateInfo> templateInfoCfg = new ArrayList<CRTemplateInfo>();
    private static HashMap<String, String> rangeMap = new HashMap();
    private static List<CRTemplateInfo> defaultTemplate = new ArrayList<CRTemplateInfo>();
    private static HashMap<String, String> arbitrateRules = new HashMap();
    public static final String DEFAULT_ARBITRATE_RULE_FIRST_PRIOR = "FIRST";
    public static final String DEFAULT_ARBITRATE_RULE_LAST_PRIOR = "LAST";
    public static String DEFAULT_ARBITRATE_RULE = "FIRST";

    public static void loadCfg(String filenm) {
        templateInfoCfg = new ArrayList<CRTemplateInfo>();
        rangeMap = new HashMap();
        defaultTemplate = new ArrayList<CRTemplateInfo>();
        arbitrateRules = new HashMap();
        try {
            File cfgFile = new File(filenm);
            if (!cfgFile.exists()) {
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"---------------------------------------------");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"-");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"-");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"-");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"-");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"-");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)"-");
                EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)("\u52a0\u8f7d\u8bb0\u5f55\u7ea7\u6743\u9650\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6:" + filenm + "\u4e0d\u5b58\u5728, \u8bf7\u68c0\u67e5cmis-dao.properties\u6587\u4ef6datapermission.file.path\u914d\u7f6e\u9879"));
                return;
            }
            DocumentBuilder doBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = doBuilder.parse(cfgFile);
            NodeList modelList = doc.getElementsByTagName("MODEL");
            int n = 0;
            while (n < modelList.getLength()) {
                Element modelElem = (Element)modelList.item(n);
                if (modelElem != null) {
                    String modelId = modelElem.getAttribute("modelId");
                    String BCHField = modelElem.getAttribute("BCHField");
                    String USRField = modelElem.getAttribute("USRField");
                    String arbitrate = modelElem.getAttribute("arbitrateRule");
                    if (arbitrate != null && !arbitrate.trim().equals("")) {
                        arbitrateRules.put(modelId, arbitrate);
                    }
                    System.err.println(String.valueOf(modelId) + " " + BCHField + " " + USRField + " " + arbitrate);
                    NodeList rangeList = modelElem.getElementsByTagName("range");
                    int i = 0;
                    while (i < rangeList.getLength()) {
                        Element rangeElem = (Element)rangeList.item(i);
                        if (rangeElem != null) {
                            String duty = rangeElem.getAttribute("duty");
                            String role = rangeElem.getAttribute("role");
                            String organ = rangeElem.getAttribute("organ");
                            String user = rangeElem.getAttribute("user");
                            String rtype = rangeElem.getAttribute("relationType");
                            String menu = rangeElem.getAttribute("menu");
                            System.err.println("   " + duty);
                            NodeList operList = rangeElem.getChildNodes();
                            String _tmp = "";
                            int o = 0;
                            while (o < operList.getLength()) {
                                String opName = operList.item(o).getNodeName();
                                String classNm = operList.item(o).getTextContent();
                                if (opName != null && !opName.startsWith("#")) {
                                    System.err.println("       " + opName + "  " + classNm);
                                    if (_tmp.indexOf(String.valueOf(opName) + ",") >= 0) {
                                        System.err.println(String.valueOf(opName) + "\u5728\u540c\u4e00\u7ea7\u6709\u91cd\u590d");
                                    } else {
                                        _tmp = String.valueOf(_tmp) + opName + ",";
                                        CRTemplateInfo tinfo = new CRTemplateInfo();
                                        tinfo.setModuleId(modelId);
                                        tinfo.setOpType(opName.toUpperCase());
                                        tinfo.setTemplateImplClass(classNm);
                                        tinfo.setBCHField(BCHField);
                                        tinfo.setUSRField(USRField);
                                        tinfo.setForDuty(duty);
                                        tinfo.setForRole(role);
                                        tinfo.setForOrgan(organ);
                                        tinfo.setForMenu(menu);
                                        tinfo.setForUser(user);
                                        tinfo.setRelationType(rtype);
                                        templateInfoCfg.add(tinfo);
                                        if (modelId.trim().equals(DEFAULT_TEMPLATE_ID)) {
                                            defaultTemplate.add(tinfo);
                                        }
                                    }
                                }
                                ++o;
                            }
                        }
                        ++i;
                    }
                }
                ++n;
            }
            if (defaultTemplate != null) {
                defaultTemplate.size();
            }
            NodeList mapList = doc.getElementsByTagName("map");
            int n2 = 0;
            while (n2 < mapList.getLength()) {
                Element mapElem = (Element)mapList.item(n2);
                if (mapElem != null) {
                    String id = mapElem.getAttribute("id");
                    String session = mapElem.getAttribute("session");
                    System.err.println(String.valueOf(id) + " " + session);
                    rangeMap.put(id, session);
                }
                ++n2;
            }
            NodeList groupList = doc.getElementsByTagName("CONDI_GROUP");
            int n3 = 0;
            while (n3 < groupList.getLength()) {
                Element groupElem = (Element)groupList.item(n3);
                if (groupElem != null) {
                    String defaultCondi = groupElem.getAttribute("defaultCondition");
                    HashMap<String, String> optCondition = new HashMap<String, String>();
                    optCondition.put("defaultCondition", defaultCondi);
                    if (defaultCondi == null || defaultCondi.trim().equals("")) {
                        defaultCondi = "";
                    }
                    NodeList condiList = groupElem.getChildNodes();
                    SqlConfigLoader.loadOptConditionNode(condiList, optCondition);
                    SqlConfig.addCondition2PubGroup(optCondition);
                }
                ++n3;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addCfg(String model_id, String role, String classNm) {
        CRTemplateInfo tinfo = new CRTemplateInfo();
        tinfo.setModuleId(model_id);
        tinfo.setOpType("QUERY");
        tinfo.setTemplateImplClass(classNm);
        tinfo.setForRole(role);
        templateInfoCfg.add(tinfo);
    }

    public static void updateCfg(String model_id, String role, String classNm) {
        CRTemplateInfo queryValue = new CRTemplateInfo();
        for (CRTemplateInfo t : templateInfoCfg) {
            if (!t.getModuleId().equals(model_id) || !t.getTemplateImplClass().equals(classNm) || !"QUERY".equals(t.getOpType())) continue;
            queryValue = t;
        }
        if (queryValue.getModuleId() != null && queryValue.getModuleId() != "") {
            templateInfoCfg.remove(queryValue);
            queryValue.setForRole(role);
            templateInfoCfg.add(queryValue);
        }
    }

    public static void deleteCfg(String model_id, String classNm) {
        CRTemplateInfo newValue = new CRTemplateInfo();
        for (CRTemplateInfo t : templateInfoCfg) {
            if (!t.getModuleId().equals(model_id) || !t.getTemplateImplClass().equals(classNm) || !"QUERY".equals(t.getOpType())) continue;
            newValue = t;
        }
        templateInfoCfg.remove(newValue);
    }

    public static List<CRTemplateInfo> getTemplateInfoCfg() {
        return templateInfoCfg;
    }

    public static List<CRTemplateInfo> getTemplateInfoCfgByModuleId(String moduleId) {
        List<CRTemplateInfo> template = new ArrayList<CRTemplateInfo>();
        for (CRTemplateInfo t : templateInfoCfg) {
            if (!t.getModuleId().equals(moduleId)) continue;
            template.add(t);
        }
        if (template.size() <= 0) {
            template = CRTemplateInfoLoad.getDefaultTemplate();
        }
        return template;
    }

    public static List<CRTemplateInfo> getTemplateInfoCfgByModuleIdNoDefault(String moduleId) {
        ArrayList<CRTemplateInfo> template = new ArrayList<CRTemplateInfo>();
        for (CRTemplateInfo t : templateInfoCfg) {
            if (!t.getModuleId().equals(moduleId)) continue;
            template.add(t);
        }
        return template;
    }

    public static List<CRTemplateInfo> getDefaultTemplate() {
        return defaultTemplate;
    }

    public static String getArbitrateRule(String moduleId) {
        String rule = arbitrateRules.get(moduleId);
        if (rule == null || rule.trim().equals("")) {
            rule = DEFAULT_ARBITRATE_RULE;
        } else if (!CRTemplateInfoLoad.isExtArbitrateRule(rule)) {
            rule = rule.toUpperCase();
        }
        return rule;
    }

    public static boolean isExtArbitrateRule(String arule) {
        return arule != null && arule.startsWith("com.");
    }

    public static void loadPermissionConfig() {
        String fileNm = null;
        try {
            String FileRootPath = CMISDaoPropertyManager.getInstance().getPropertyValue("datapermission.file.path");
            String pathString = "";
            pathString = ResourceUtils.getFile((String)FileRootPath).getAbsolutePath();
            fileNm = String.valueOf(pathString) + "/" + permissionFileName;
            CRTemplateInfoLoad.loadCfg(fileNm);
        }
        catch (Exception e) {
            EMPLog.log((String)"CMIS-DAO", (int)EMPLog.ERROR, (int)0, (String)("\u52a0\u8f7d\u8bb0\u5f55\u7ea7\u6743\u9650\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6:" + fileNm + ", \u8bf7\u68c0\u67e5cmis-dao.properties\u6587\u4ef6datapermission.file.path\u914d\u7f6e\u9879"));
        }
    }

    public static void main(String[] args) {
        CRTemplateInfoLoad.loadCfg("E:/studio2/permissions/datapermission2.xml");
        List<CRTemplateInfo> cfgList = CRTemplateInfoLoad.getTemplateInfoCfg();
        for (CRTemplateInfo cfg : cfgList) {
            String mo = cfg.getModuleId();
            String op = cfg.getOpType();
            System.err.println(String.valueOf(mo) + ";" + op + ";" + cfg.getTemplateImplClass() + ";" + cfg.getUSRField() + ";" + cfg.getBCHField() + ";" + cfg.getForDuty() + ";" + cfg.getForMenu() + ";" + cfg.getForRole() + ";" + cfg.getForOrgan() + ";");
        }
    }
}

