/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao;

import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.dao.builder.SqlBuilderFactory;
import com.yucheng.cmis.dao.config.SqlConfigContext;
import com.yucheng.cmis.dao.util.PageInfo;
import com.yucheng.cmis.pub.CMISDomain;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlClient {
    public static final String LOGTYPE = "SQL";
    private static int MAX_RECORD = 5000;
    private static final String SQL_TYPE_INSERT = "$insert";
    private static final String SQL_TYPE_UPDATE = "$update";
    private static final String SQL_TYPE_DELETE = "$delete";

    public static Object queryAuto(CMISDomain domain, Connection conn) throws SQLException {
        long star = System.currentTimeMillis();
        String exportSql = "";
        ArrayList<Object> fieldValueList = new ArrayList<Object>();
        Statement ps = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            sql.append(SqlClient.getSelectSql(domain, fieldValueList));
            ps = conn.prepareStatement(sql.toString());
            int parameterIndex = 1;
            if (fieldValueList != null && fieldValueList.size() > 0) {
                int n = 0;
                while (n < fieldValueList.size()) {
                    ps.setObject(parameterIndex++, fieldValueList.get(n));
                    ++n;
                }
            }
            rs = ps.executeQuery();
            Collection data = SqlClient.handleQueryResult(rs, domain.getClass().getName(), false, true);
            exportSql = SqlClient.resetExportSqlLog(sql.toString(), fieldValueList);
            SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, System.currentTimeMillis() - star);
            if (data != null && data.size() >= 0 && data.iterator().hasNext()) {
                Object e = data.iterator().next();
                return e;
            }
        }
        catch (SQLException e) {
            SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, -1L);
            throw new SQLException(e.getMessage());
        }
        catch (Exception e) {
            SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, -1L);
            throw new SQLException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return null;
    }

    public static Object queryFirst(String sqlId, Object parameter, Connection conn) throws SQLException {
        Collection coData = SqlClient.queryList(sqlId, parameter, 0, 0, conn);
        if (coData != null && coData.size() >= 0 && coData.iterator().hasNext()) {
            return coData.iterator().next();
        }
        return null;
    }

    public static Object queryFirst(String sqlId, Object parameter, boolean limitRecordCount, Connection conn) throws SQLException {
        return SqlClient.queryList(sqlId, parameter, null, null, 0, 0, limitRecordCount, conn);
    }

    public static Collection queryList(String sqlId, Object parameter, PageInfo pageInfo, Connection conn) throws SQLException {
        pageInfo.recordSize = SqlClient.queryCount(sqlId, parameter, conn);
        if (pageInfo.recordSize > 0) {
            return SqlClient.queryList(sqlId, parameter, null, null, pageInfo.pageIdx, pageInfo.pageSize, conn);
        }
        return new ArrayList();
    }

    public static Collection queryList(String sqlId, CMISDomain cmisDomain, String[] conditionId, String[] pubConditionId, PageInfo pageInfo, Connection conn) throws SQLException {
        pageInfo.recordSize = SqlClient.queryCount(sqlId, cmisDomain, conditionId, pubConditionId, conn);
        if (pageInfo.recordSize > 0) {
            return SqlClient.queryList(sqlId, cmisDomain, conditionId, pubConditionId, pageInfo.pageIdx, pageInfo.pageSize, conn);
        }
        return new ArrayList();
    }

    public static Collection queryList(String sqlId, Object parameter, Connection conn) throws SQLException {
        return SqlClient.queryList(sqlId, parameter, 0, 0, conn);
    }

    private static IndexedCollection queryList4IColl(String sqlId, Object parameter, Connection conn) throws SQLException {
        Collection col = SqlClient.queryList(sqlId, parameter, 0, 0, conn);
        IndexedCollection iCol = new IndexedCollection();
        iCol.addAll(col);
        return iCol;
    }

    private static IndexedCollection queryList4IColl(String sqlId, Object parameter, int pageNumber, int pageSize, Connection conn) throws SQLException {
        Collection col = SqlClient.queryList(sqlId, parameter, pageNumber, pageSize, conn);
        IndexedCollection iCol = new IndexedCollection();
        iCol.addAll(col);
        return iCol;
    }

    private static IndexedCollection queryList4IColl(String sqlId, Object parameter, String[] conditionId, int pageNumber, int pageSize, Connection conn) throws SQLException {
        Collection col = SqlClient.queryList(sqlId, parameter, pageNumber, pageSize, conn);
        IndexedCollection iCol = new IndexedCollection();
        iCol.addAll(col);
        return iCol;
    }

    private static String queryList2File(String sqlId, Object parameter, String[] conditionId, int start, int end, Connection conn) throws SQLException {
        return "";
    }

    private static Map associatePageInfo(int pageNumber, int pageSize) {
        HashMap<String, Integer> pageInfo = null;
        if (pageNumber > 0 && pageSize > 0) {
            pageInfo = new HashMap<String, Integer>();
            pageInfo.put("pageNumber", pageNumber);
            pageInfo.put("pageSize", pageSize);
            int startRow = (pageNumber - 1) * pageSize + 1;
            pageInfo.put("startRow", startRow);
            int endRow = pageNumber * pageSize;
            pageInfo.put("endRow", endRow);
        }
        return pageInfo;
    }

    private static Collection handleQueryResult(String sqlId, ResultSet rs, boolean limitRecordCount) throws SQLException {
        String resClassname = SqlConfigContext.getResultClass(sqlId);
        boolean isOnlyFirst = SqlConfigContext.getOnlyReturnFirst(sqlId);
        ArrayList<Object> colResult = null;
        String[] colNameList = null;
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rmeta = rs.getMetaData();
        int colCount = rmeta.getColumnCount();
        colNameList = new String[colCount];
        int c = 1;
        while (c <= colCount) {
            colNameList[c - 1] = rmeta.getColumnName(c).toLowerCase();
            ++c;
        }
        colResult = new ArrayList<Object>();
        int count = 0;
        while (rs.next()) {
            KeyedCollection _TmpData = new HashMap(colCount, 1.0f);
            int c2 = 1;
            while (c2 <= colCount) {
                _TmpData.put(colNameList[c2 - 1], rs.getObject(c2));
                ++c2;
            }
            KeyedCollection oo = null;
            if (SqlClient.isBasicDataType(resClassname)) {
                colResult.add(rs.getObject(1));
                break;
            }
            if (resClassname.equals("com.ecc.emp.data.KeyedCollection")) {
                KeyedCollection kCol = new KeyedCollection();
                kCol.putAll(_TmpData);
                oo = kCol;
            } else if (resClassname.equals("java.util.HashMap") || resClassname.equals("java.util.Map")) {
                oo = _TmpData;
            } else {
                try {
                    Class<?> cls = Class.forName(resClassname);
                    CMISDomain domain = (CMISDomain)cls.newInstance();
                    domain.putData((Map)_TmpData);
                    oo = domain;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new SQLException(e.getMessage());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new SQLException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new SQLException(e.getMessage());
                }
            }
            if (SqlClient.isExceedMaxRecord(++count, sqlId, limitRecordCount)) break;
            colResult.add(oo);
            if (isOnlyFirst) break;
        }
        return colResult;
    }

    private static Collection handleQueryResult(ResultSet rs, String resultClassName, boolean isOnlyFirst, boolean limitRecordCount) throws SQLException {
        ArrayList<Object> colResult = null;
        String[] colNameList = null;
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rmeta = rs.getMetaData();
        int colCount = rmeta.getColumnCount();
        colNameList = new String[colCount];
        int c = 1;
        while (c <= colCount) {
            colNameList[c - 1] = rmeta.getColumnName(c).toLowerCase();
            ++c;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(resultClassName);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            throw new SQLException(e1.getMessage());
        }
        colResult = new ArrayList<Object>();
        int count = 0;
        while (rs.next()) {
            KeyedCollection _TmpData = new HashMap(colCount, 1.0f);
            int c2 = 1;
            while (c2 <= colCount) {
                _TmpData.put(colNameList[c2 - 1], rs.getObject(c2));
                ++c2;
            }
            KeyedCollection oo = null;
            if (SqlClient.isBasicDataType(resultClassName)) {
                colResult.add(rs.getObject(1));
                break;
            }
            if (resultClassName.equals("com.ecc.emp.data.KeyedCollection")) {
                KeyedCollection kCol = new KeyedCollection();
                kCol.putAll(_TmpData);
                oo = kCol;
            } else if (resultClassName.equals("java.util.HashMap") || resultClassName.equals("java.util.Map")) {
                oo = _TmpData;
            } else {
                try {
                    CMISDomain domain = (CMISDomain)cls.newInstance();
                    domain.putData((Map)_TmpData);
                    oo = domain;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new SQLException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new SQLException(e.getMessage());
                }
            }
            if (SqlClient.isExceedMaxRecord(++count, null, limitRecordCount)) break;
            colResult.add(oo);
            if (isOnlyFirst) break;
        }
        return colResult;
    }

    private static boolean isExceedMaxRecord(int count, String sqlId, boolean limitRecordCount) throws SQLException {
        block6: {
            if (!limitRecordCount) {
                return false;
            }
            try {
                String maxCount = CMISDaoPropertyManager.getInstance().getPropertyValue("limit.max.record.count");
                if (maxCount != null && !maxCount.trim().equals("0")) {
                    MAX_RECORD = Integer.parseInt(maxCount);
                }
                if (MAX_RECORD >= 0) break block6;
                return false;
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        if (count > MAX_RECORD) {
            EMPLog.log((String)LOGTYPE, (int)EMPLog.INFO, (int)0, (String)("\u5f53\u524dSQL" + (sqlId == null ? sqlId : "") + "\u67e5\u8be2\u7ed3\u679c\u96c6\u8d85\u8fc7" + MAX_RECORD + "\u6761\uff0c\u4e3a\u9632\u6b62OOM\u53ea\u8fd4\u56de" + MAX_RECORD + "\u6761\u8bb0\u5f55"));
            return true;
        }
        return false;
    }

    public static Object querySingle(String sqlId, Object parameter, Connection conn) throws SQLException {
        ArrayList result = (ArrayList)SqlClient.queryList(sqlId, parameter, 0, 0, conn);
        Object resObj = null;
        if (result != null && result.size() > 0) {
            resObj = result.get(0);
        }
        if (resObj == null) {
            return null;
        }
        return resObj;
    }

    public static int queryCount(String sqlId, Object parameter, Connection conn) throws SQLException {
        return SqlClient.queryCount(sqlId, parameter, null, null, conn);
    }

    public static int queryCount(String sqlId, Object parameter, String[] conditionId, String[] pubConditionId, Connection conn) throws SQLException {
        int iTotal = 0;
        long star = System.currentTimeMillis();
        String sqlOrigin = SqlConfigContext.getSqlFromConfig(sqlId, parameter, conditionId, pubConditionId);
        List paramValue = SqlConfigContext.getParamList(sqlId, parameter, conditionId, pubConditionId);
        sqlOrigin = SqlBuilderFactory.getBuilder().generateCountSql(sqlOrigin);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(sqlOrigin);
                int paramIdx = 1;
                if (paramValue != null && paramValue.size() > 0) {
                    int n = 0;
                    while (n < paramValue.size()) {
                        ps.setObject(paramIdx++, paramValue.get(n));
                        ++n;
                    }
                }
                if ((rs = ps.executeQuery()).next()) {
                    iTotal = rs.getInt(1);
                }
                String exportSql = SqlClient.resetExportSqlLog(sqlOrigin, paramValue);
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, exportSql, System.currentTimeMillis() - star);
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return iTotal;
    }

    public static Collection queryList(String sqlId, Object parameter, int pageNumber, int pageSize, Connection conn) throws SQLException {
        return SqlClient.queryList(sqlId, parameter, null, null, pageNumber, pageSize, conn);
    }

    public static Collection queryList(String sqlId, Object parameter, String[] conditionId, String[] pubConditionId, int pageNumber, int pageSize, Connection conn) throws SQLException {
        return SqlClient.queryList(sqlId, parameter, conditionId, pubConditionId, pageNumber, pageSize, true, conn);
    }

    private static Collection queryList(String sqlId, Object parameter, String[] conditionId, String[] pubConditionId, int pageNumber, int pageSize, boolean limitRecordCount, Connection conn) throws SQLException {
        long star = System.currentTimeMillis();
        String exportSql = "";
        String sqlOrigin = SqlConfigContext.getSqlFromConfig(sqlId, parameter, conditionId, pubConditionId);
        List paramValue = SqlConfigContext.getParamList(sqlId, parameter, conditionId, pubConditionId);
        if (pageNumber > 0 && pageSize > 0) {
            sqlOrigin = SqlBuilderFactory.getBuilder().generatePaginateSql(sqlOrigin, pageNumber, pageSize);
        }
        Collection colResult = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                ps = conn.prepareStatement(sqlOrigin);
                int paramIdx = 1;
                if (paramValue != null && paramValue.size() > 0) {
                    int n = 0;
                    while (n < paramValue.size()) {
                        ps.setObject(paramIdx++, paramValue.get(n));
                        ++n;
                    }
                }
                rs = ps.executeQuery();
                String resultClassName = SqlConfigContext.getResultClass(sqlId);
                boolean isOnlyFirst = SqlConfigContext.getOnlyReturnFirst(sqlId);
                colResult = SqlClient.handleQueryResult(rs, resultClassName, isOnlyFirst, limitRecordCount);
                exportSql = SqlClient.resetExportSqlLog(sqlOrigin, paramValue);
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, exportSql, System.currentTimeMillis() - star);
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, exportSql, -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, exportSql, -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return colResult;
    }

    public static int insert(String sqlId, Map value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, null, value, conn);
    }

    public static int insert(String sqlId, KeyedCollection value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, null, value, conn);
    }

    public static int insert(String sqlId, CMISDomain value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, null, value, conn);
    }

    private static int insert(String sqlId, Object parameter, Object value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, value, conn);
    }

    private static int insert(String sqlId, Object parameter, Object value, String[] conditionId, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, value, conn);
    }

    public static int insertAuto(CMISDomain value, Connection conn) throws SQLException {
        return SqlClient.executeAuto(value, SQL_TYPE_INSERT, conn);
    }

    public static int update(String sqlId, String parameter, Object value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, value, conn);
    }

    public static int update(String sqlId, Map parameter, Object value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, value, conn);
    }

    public static int update(String sqlId, KeyedCollection parameter, Object value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, value, conn);
    }

    public static int update(String sqlId, CMISDomain parameter, Object value, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, value, conn);
    }

    public static int updateAuto(CMISDomain value, Connection conn) throws SQLException {
        return SqlClient.executeAuto(value, SQL_TYPE_UPDATE, conn);
    }

    public static int delete(String sqlId, String parameter, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, null, conn);
    }

    public static int delete(String sqlId, Map parameter, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, null, conn);
    }

    public static int delete(String sqlId, KeyedCollection parameter, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, null, conn);
    }

    public static int delete(String sqlId, CMISDomain parameter, Connection conn) throws SQLException {
        return SqlClient.execute(sqlId, parameter, null, conn);
    }

    public static int deleteAuto(CMISDomain parameter, Connection conn) throws SQLException {
        return SqlClient.executeAuto(parameter, SQL_TYPE_DELETE, conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getSelectSql(Object value, List fieldValueList) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String tableName = null;
        String[] primaryKey = null;
        String paramStr = "";
        if (value instanceof CMISDomain) {
            CMISDomain domain = (CMISDomain)value;
            tableName = domain.getTableName();
            Map data = domain.getDataMap();
            primaryKey = domain.getPrimaryKey();
            if (primaryKey == null || primaryKey.length <= 0) throw new SQLException("\u67e5\u8be2\u4e3b\u952e\u57df\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u83b7\u53d6\u6267\u884c\u81ea\u52a8\u67e5\u8be2\u8bed\u53e5!");
            int i = 0;
            while (i < primaryKey.length) {
                Object fieldValue = data.get(primaryKey[i]);
                if (fieldValue == null) {
                    throw new SQLException("\u67e5\u8be2\u4e3b\u952e\u57df\u672a\u8bbe\u7f6e\u503c\uff0c\u65e0\u6cd5\u83b7\u53d6\u6267\u884c\u81ea\u52a8\u67e5\u8be2\u8bed\u53e5!");
                }
                fieldValueList.add(fieldValue);
                paramStr = String.valueOf(paramStr) + " AND " + primaryKey[i] + "=?";
                ++i;
            }
            if (paramStr.length() > 5) {
                paramStr = paramStr.substring(4);
            }
        } else {
            boolean cfr_ignored_0 = value instanceof KeyedCollection;
        }
        sql.append("SELECT * FROM ").append(tableName).append(" WHERE ").append(paramStr);
        return sql.toString();
    }

    private static String getInsertSql(Object value, List fieldValueList) {
        StringBuffer sql = new StringBuffer();
        String tableName = null;
        Object primaryKey = null;
        String fieldStr = "";
        String paramStr = "";
        if (value instanceof CMISDomain) {
            CMISDomain domain = (CMISDomain)value;
            tableName = domain.getTableName();
            Map data = domain.getDataMap();
            for (String fieldName : data.keySet()) {
                Object fieldValue = data.get(fieldName);
                if (fieldValue == null) continue;
                fieldValueList.add(fieldValue);
                fieldStr = String.valueOf(fieldStr) + fieldName + ",";
                paramStr = String.valueOf(paramStr) + "?,";
            }
        } else {
            boolean cfr_ignored_0 = value instanceof KeyedCollection;
        }
        fieldStr = fieldStr.substring(0, fieldStr.length() - 1);
        paramStr = paramStr.substring(0, paramStr.length() - 1);
        sql.append("INSERT INTO ").append(tableName).append(" (").append(fieldStr).append(") VALUES (").append(paramStr).append(")");
        return sql.toString();
    }

    private static String getInsertSql(Object value, List fieldValueList, String seqName) {
        StringBuffer sql = new StringBuffer();
        String tableName = null;
        String[] primaryKey = null;
        String primaryKeyName = null;
        String fieldStr = "";
        String paramStr = "";
        if (value instanceof CMISDomain) {
            CMISDomain domain = (CMISDomain)value;
            tableName = domain.getTableName();
            Map data = domain.getDataMap();
            primaryKey = domain.getPrimaryKey();
            if (primaryKey.length > 0) {
                primaryKeyName = primaryKey[0].toString();
            }
            for (String fieldName : data.keySet()) {
                Object fieldValue = data.get(fieldName);
                if (fieldValue == null) continue;
                fieldValueList.add(fieldValue);
                fieldStr = String.valueOf(fieldStr) + fieldName + ",";
                paramStr = String.valueOf(paramStr) + "?,";
            }
        } else {
            boolean cfr_ignored_0 = value instanceof KeyedCollection;
        }
        fieldStr = fieldStr.substring(0, fieldStr.length() - 1);
        paramStr = paramStr.substring(0, paramStr.length() - 1);
        sql.append("INSERT INTO ").append(tableName).append(" (").append(String.valueOf(primaryKeyName) + ",").append(fieldStr).append(") VALUES (").append(String.valueOf(seqName) + ".nextval,").append(paramStr).append(")");
        return sql.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getUpdateSql(Object value, List fieldValueList) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String tableName = null;
        String[] primaryKey = null;
        String fieldStr = "";
        String paramStr = "";
        if (value instanceof CMISDomain) {
            CMISDomain domain = (CMISDomain)value;
            tableName = domain.getTableName();
            primaryKey = domain.getPrimaryKey();
            Map data = domain.getDataMap();
            for (String fieldName : data.keySet()) {
                Object fieldValue = data.get(fieldName);
                if (SqlClient.isPrimaryKey(primaryKey, fieldName)) continue;
                fieldValueList.add(fieldValue);
                fieldStr = String.valueOf(fieldStr) + fieldName + " = ? , ";
            }
            if (primaryKey == null || primaryKey.length <= 0) throw new SQLException("\u672a\u8bbe\u7f6e\u4e3b\u952e\uff0c\u65e0\u6cd5\u6267\u884c\u81ea\u52a8\u66f4\u65b0\u64cd\u4f5c!!");
            int primaryValueCount = 0;
            int i = 0;
            while (i < primaryKey.length) {
                Object fieldValue = data.get(primaryKey[i]);
                if (fieldValue != null) {
                    ++primaryValueCount;
                    fieldValueList.add(fieldValue);
                    paramStr = String.valueOf(paramStr) + " AND " + primaryKey[i] + " = ?";
                }
                ++i;
            }
            if (primaryValueCount == 0) {
                throw new SQLException("\u4e3b\u952e\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u81ea\u52a8\u66f4\u65b0\u64cd\u4f5c!!");
            }
        } else {
            boolean cfr_ignored_0 = value instanceof KeyedCollection;
        }
        fieldStr = fieldStr.substring(0, fieldStr.length() - 2);
        sql.append(" UPDATE ").append(tableName).append(" SET ").append(fieldStr).append(" WHERE 1 > 0 ").append(paramStr).append("");
        return sql.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDeleteSql(Object value, List fieldValueList) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String tableName = null;
        String[] primaryKey = null;
        String paramStr = "";
        if (value instanceof CMISDomain) {
            CMISDomain domain = (CMISDomain)value;
            tableName = domain.getTableName();
            Map data = domain.getDataMap();
            primaryKey = domain.getPrimaryKey();
            if (primaryKey == null || primaryKey.length <= 0) throw new SQLException("\u66f4\u65b0\u6761\u4ef6\u57df\u5b58\u5728\u7a7a\u503c\uff0c\u65e0\u6cd5\u6267\u884c\u81ea\u52a8\u66f4\u65b0\u64cd\u4f5c!!");
            int i = 0;
            while (i < primaryKey.length) {
                Object fieldValue = data.get(primaryKey[i]);
                if (fieldValue == null) {
                    throw new SQLException("\u66f4\u65b0\u6761\u4ef6\u57df\u5b58\u5728\u7a7a\u503c\uff0c\u65e0\u6cd5\u6267\u884c\u81ea\u52a8\u66f4\u65b0\u64cd\u4f5c!!");
                }
                fieldValueList.add(fieldValue);
                paramStr = String.valueOf(paramStr) + " AND " + primaryKey[i] + " = ?";
                ++i;
            }
        } else {
            boolean cfr_ignored_0 = value instanceof KeyedCollection;
        }
        sql.append("DELETE FROM ").append(tableName).append(" WHERE 1 > 0 ").append(paramStr);
        return sql.toString();
    }

    private static int executeAuto(Object value, String sqlType, Connection conn) throws SQLException {
        long star = System.currentTimeMillis();
        int ret = -1;
        ArrayList<Object> fieldValueList = new ArrayList<Object>();
        String exportSql = "";
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        try {
            try {
                if (SQL_TYPE_INSERT.equals(sqlType.trim())) {
                    sql.append(SqlClient.getInsertSql(value, fieldValueList));
                } else if (SQL_TYPE_UPDATE.equals(sqlType.trim())) {
                    sql.append(SqlClient.getUpdateSql(value, fieldValueList));
                } else if (SQL_TYPE_DELETE.equals(sqlType.trim())) {
                    sql.append(SqlClient.getDeleteSql(value, fieldValueList));
                }
                ps = conn.prepareStatement(sql.toString());
                ParameterMetaData pmd = ps.getParameterMetaData();
                if (fieldValueList != null && fieldValueList.size() > 0) {
                    int paramIdx = 1;
                    String dataBaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
                    int n = 0;
                    while (n < fieldValueList.size()) {
                        if ("Oracle".equalsIgnoreCase(dataBaseType)) {
                            ps.setObject(paramIdx, fieldValueList.get(n) == null ? "" : fieldValueList.get(n));
                        } else {
                            String typeName = pmd.getParameterTypeName(paramIdx);
                            if (typeName.startsWith("VARCHAR")) {
                                ps.setObject(paramIdx, fieldValueList.get(n) == null ? "" : fieldValueList.get(n));
                            } else {
                                ps.setObject(paramIdx, "".equals(fieldValueList.get(n)) ? null : fieldValueList.get(n));
                            }
                        }
                        ++paramIdx;
                        ++n;
                    }
                }
                ret = ps.executeUpdate();
                exportSql = SqlClient.resetExportSqlLog(sql.toString(), fieldValueList);
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, System.currentTimeMillis() - star);
            }
            catch (SQLException e) {
                e.printStackTrace();
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Throwable e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return ret;
    }

    private static int execute(String sqlId, Object parameter, Object value, Connection conn) throws SQLException {
        int ret = -1;
        long star = System.currentTimeMillis();
        String sqlOrigin = null;
        List paramValue = null;
        String exportSql = "";
        try {
            sqlOrigin = SqlConfigContext.getSqlFromConfig(sqlId, parameter, null, value);
            paramValue = SqlConfigContext.getParamList(sqlId, parameter, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sqlOrigin);
                ParameterMetaData pmd = ps.getParameterMetaData();
                int paramIdx = 1;
                if (paramValue != null && paramValue.size() > 0) {
                    String dataBaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
                    int n = 0;
                    while (n < paramValue.size()) {
                        if ("Oracle".equalsIgnoreCase(dataBaseType)) {
                            ps.setObject(paramIdx, paramValue.get(n) == null ? "" : paramValue.get(n));
                        } else {
                            String typeName = pmd.getParameterTypeName(paramIdx);
                            if (typeName.startsWith("VARCHAR")) {
                                ps.setObject(paramIdx, paramValue.get(n) == null ? "" : paramValue.get(n));
                            } else {
                                ps.setObject(paramIdx, "".equals(paramValue.get(n)) ? null : paramValue.get(n));
                            }
                        }
                        ++paramIdx;
                        ++n;
                    }
                }
                ret = ps.executeUpdate();
                exportSql = SqlClient.resetExportSqlLog(sqlOrigin, paramValue);
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, System.currentTimeMillis() - star);
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, exportSql, -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return ret;
    }

    private static boolean isBasicDataType(String Classname) {
        return Classname.equals("java.lang.Double") || Classname.equals("java.lang.Integer") || Classname.equals("java.lang.Float") || Classname.equals("java.lang.String") || Classname.equals("java.math.BigDecimal");
    }

    private static boolean isPrimaryKey(String[] keys, String toCheck) {
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (key != null && key.equals(toCheck)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void executeBatch(String sqlId, Object[] value, Connection conn) throws SQLException {
        SqlClient.executeBatch(sqlId, null, value, conn);
    }

    public static void executeDomainBatch(String sqlType, Object[] parameter, Connection conn) throws SQLException {
        int ret = -1;
        String sqlOrigin = "";
        ArrayList fieldValueList = new ArrayList();
        if (SQL_TYPE_INSERT.equals(sqlType.trim())) {
            sqlOrigin = SqlClient.getInsertSql(parameter[0], fieldValueList);
        } else if (SQL_TYPE_UPDATE.equals(sqlType.trim())) {
            sqlOrigin = SqlClient.getUpdateSql(parameter[0], fieldValueList);
        } else if (SQL_TYPE_DELETE.equals(sqlType.trim())) {
            sqlOrigin = SqlClient.getDeleteSql(parameter[0], fieldValueList);
        }
        Statement ps = null;
        try {
            try {
                String dataBaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
                ps = conn.prepareStatement(sqlOrigin);
                ParameterMetaData pmd = ps.getParameterMetaData();
                conn.setAutoCommit(false);
                long startTime = System.currentTimeMillis();
                int length = 0;
                if (parameter != null) {
                    length = parameter.length;
                }
                int i = 0;
                while (i < length) {
                    fieldValueList = new ArrayList();
                    if (SQL_TYPE_INSERT.equals(sqlType.trim())) {
                        SqlClient.getInsertSql(parameter[i], fieldValueList);
                    } else if (SQL_TYPE_UPDATE.equals(sqlType.trim())) {
                        SqlClient.getUpdateSql(parameter[i], fieldValueList);
                    } else if (SQL_TYPE_DELETE.equals(sqlType.trim())) {
                        SqlClient.getDeleteSql(parameter[i], fieldValueList);
                    }
                    int parameterIndex = 1;
                    if (fieldValueList != null && fieldValueList.size() > 0) {
                        int n = 0;
                        while (n < fieldValueList.size()) {
                            if ("Oracle".equalsIgnoreCase(dataBaseType)) {
                                ps.setObject(parameterIndex, fieldValueList.get(n) == null ? "" : fieldValueList.get(n));
                            } else {
                                String typeName = pmd.getParameterTypeName(parameterIndex);
                                if (typeName.startsWith("VARCHAR")) {
                                    ps.setObject(parameterIndex, fieldValueList.get(n) == null ? "" : fieldValueList.get(n));
                                } else {
                                    ps.setObject(parameterIndex, "".equals(fieldValueList.get(n)) ? null : fieldValueList.get(n));
                                }
                            }
                            ++parameterIndex;
                            ++n;
                        }
                    }
                    ps.addBatch();
                    if (i % 1000 == 0) {
                        ps.executeBatch();
                    }
                    ++i;
                }
                ps.executeBatch();
                long endTime = System.currentTimeMillis();
                EMPLog.log((String)LOGTYPE, (int)EMPLog.DEBUG, (int)0, (String)("\u6279\u91cf\u64cd\u4f5c,\u8017\u65f6:" + (endTime - startTime) + ",\u6267\u884cSQL:" + sqlOrigin));
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static void executeBatch(String sqlId, Object[] parameter, Object[] value, Connection conn) throws SQLException {
        int ret = -1;
        String sqlOrigin = null;
        List paramValue = null;
        try {
            Object oParam = null;
            if (parameter != null && parameter.length > 0) {
                oParam = parameter[0];
            }
            Object oValue = null;
            if (value != null && value.length > 0) {
                oValue = value[0];
            }
            sqlOrigin = SqlConfigContext.getSqlFromConfig(sqlId, oParam, null, oValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sqlOrigin);
                ParameterMetaData pmd = ps.getParameterMetaData();
                conn.setAutoCommit(false);
                long startTime = System.currentTimeMillis();
                int length = 0;
                if (value != null) {
                    length = value.length;
                }
                if (parameter != null) {
                    length = parameter.length;
                }
                String dataBaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
                int i = 0;
                while (i < length) {
                    Object oParam1 = null;
                    if (parameter != null && parameter.length > 0) {
                        oParam1 = parameter[i];
                    }
                    Object oValue1 = null;
                    if (value != null && value.length > 0) {
                        oValue1 = value[i];
                    }
                    paramValue = SqlConfigContext.getParamList(sqlId, oParam1, oValue1);
                    int paramIdx = 1;
                    if (paramValue != null && paramValue.size() > 0) {
                        int n = 0;
                        while (n < paramValue.size()) {
                            if ("Oracle".equalsIgnoreCase(dataBaseType)) {
                                ps.setObject(paramIdx, paramValue.get(n) == null ? "" : paramValue.get(n));
                            } else {
                                String typeName = pmd.getParameterTypeName(paramIdx);
                                if (typeName.startsWith("VARCHAR")) {
                                    ps.setObject(paramIdx, paramValue.get(n) == null ? "" : paramValue.get(n));
                                } else {
                                    ps.setObject(paramIdx, "".equals(paramValue.get(n)) ? null : paramValue.get(n));
                                }
                            }
                            ++paramIdx;
                            ++n;
                        }
                    }
                    ps.addBatch();
                    if (i % 1000 == 0) {
                        ps.executeBatch();
                    }
                    ++i;
                }
                ps.executeBatch();
                long endTime = System.currentTimeMillis();
                EMPLog.log((String)LOGTYPE, (int)EMPLog.DEBUG, (int)0, (String)("sqlId:" + sqlId + " \u6279\u91cf\u64cd\u4f5c,\u8017\u65f6:" + (endTime - startTime) + ",\u6267\u884cSQL:" + sqlOrigin));
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog(sqlId, EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static void sqlClientLog(String sqlId, int level, String sql, long useTime) {
        if (useTime < 0L && sql != null) {
            EMPLog.log((String)LOGTYPE, (int)level, (int)0, (String)("sqlId:" + sqlId + "\u6267\u884cSQL:" + sql));
        } else if (sql != null) {
            EMPLog.log((String)LOGTYPE, (int)level, (int)0, (String)("\u8017\u65f6:" + useTime + "ms sqlId:" + sqlId + " \u6267\u884cSQL:" + sql));
        }
    }

    public static void executeDomainInsertBatch(Object[] parameter, String seqName, Connection conn) throws SQLException {
        int ret = -1;
        String sqlOrigin = "";
        ArrayList fieldValueList = new ArrayList();
        sqlOrigin = SqlClient.getInsertSql(parameter[0], fieldValueList, seqName);
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sqlOrigin);
                ParameterMetaData pmd = ps.getParameterMetaData();
                conn.setAutoCommit(false);
                long startTime = System.currentTimeMillis();
                int length = 0;
                if (parameter != null) {
                    length = parameter.length;
                }
                String dataBaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
                int i = 0;
                while (i < length) {
                    fieldValueList = new ArrayList();
                    SqlClient.getInsertSql(parameter[i], fieldValueList, seqName);
                    int parameterIndex = 1;
                    if (fieldValueList != null && fieldValueList.size() > 0) {
                        int n = 0;
                        while (n < fieldValueList.size()) {
                            if ("Oracle".equalsIgnoreCase(dataBaseType)) {
                                ps.setObject(parameterIndex, fieldValueList.get(n) == null ? "" : fieldValueList.get(n));
                            } else {
                                String typeName = pmd.getParameterTypeName(parameterIndex);
                                if (typeName.startsWith("VARCHAR")) {
                                    ps.setObject(parameterIndex, fieldValueList.get(n) == null ? "" : fieldValueList.get(n));
                                } else {
                                    ps.setObject(parameterIndex, "".equals(fieldValueList.get(n)) ? null : fieldValueList.get(n));
                                }
                            }
                            ++parameterIndex;
                            ++n;
                        }
                    }
                    ps.addBatch();
                    if (i % 1000 == 0) {
                        ps.executeBatch();
                    }
                    ++i;
                }
                ps.executeBatch();
                long endTime = System.currentTimeMillis();
                EMPLog.log((String)LOGTYPE, (int)EMPLog.DEBUG, (int)0, (String)("\u81ea\u52a8\u62fc\u63a5SQL \u6279\u91cf\u64cd\u4f5c,\u8017\u65f6:" + (endTime - startTime) + ",\u6267\u884cSQL:" + sqlOrigin));
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin.toString(), -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static void executeDdl(String sqlId, Connection conn) throws SQLException {
        long star = System.currentTimeMillis();
        String sqlOrigin = null;
        Object paramValue = null;
        try {
            sqlOrigin = SqlConfigContext.getSqlFromConfig(sqlId, null, null, null);
        }
        catch (Exception e) {
            throw new SQLException(String.valueOf(sqlId) + "\u7684SQL\u914d\u7f6e\u6709\u8bef!", e);
        }
        sqlOrigin = sqlOrigin.trim().toLowerCase();
        if (sqlOrigin.startsWith("select") || sqlOrigin.startsWith("update") || sqlOrigin.startsWith("delete") || sqlOrigin.startsWith("insert")) {
            throw new SQLException("executeDdl\u65b9\u6cd5\u53ea\u5141\u8bb8\u6267\u884cDDL\u76f8\u5173\u7684SQL\uff0cDML\u53caDQL\u7c7b\u7684SQL\u4e0d\u5141\u8bb8\u6267\u884c");
        }
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sqlOrigin);
                ps.execute();
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin, System.currentTimeMillis() - star);
            }
            catch (SQLException e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin, -1L);
                throw new SQLException(e.getMessage());
            }
            catch (Exception e) {
                SqlClient.sqlClientLog("\u81ea\u52a8\u62fc\u63a5SQL", EMPLog.DEBUG, sqlOrigin, -1L);
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static String resetExportSqlLog(String sql, List<Object> paramValue) {
        StringBuffer expLog = new StringBuffer();
        if (paramValue == null || paramValue.size() == 0) {
            return sql;
        }
        String[] split = sql.split("\\?");
        int i = 0;
        while (i < split.length) {
            expLog.append(split[i]);
            if (i < paramValue.size()) {
                Object value = paramValue.get(i);
                if (value instanceof String || value instanceof Character) {
                    expLog.append("'" + value + "'");
                } else {
                    expLog.append(value);
                }
            } else {
                expLog.append("?");
            }
            ++i;
        }
        return expLog.toString();
    }

    public static void main(String[] args) {
        String sql = "select *from s_user where id=? and name=?  and  value=? or dd = '11' and ss = ?";
        ArrayList<Object> paramValue = new ArrayList<Object>();
        paramValue.add("aa$a");
        paramValue.add(123);
        paramValue.add("c?cc");
        System.out.println(SqlClient.resetExportSqlLog(sql, paramValue));
    }

    class SqlExecutor {
        SqlExecutor() {
        }
    }
}

