/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.cache.db.impl;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.db.CacheDBInterface;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.dao.test.SUser;
import com.yucheng.cmis.exception.CmisDaoException;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.annotation.CMISDomainAnnotation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;
import redis.clients.util.SafeEncoder;

public class RedisDBCacheImpl
implements CacheDBInterface {
    private JedisPool jedisPool;
    private CMISDaoPropertyManager propManager;
    private String host;
    private int port;
    private String passwd;

    public RedisDBCacheImpl() {
        try {
            this.propManager = CMISDaoPropertyManager.getInstance();
        }
        catch (Exception e) {
            EMPLog.log((String)"CacheDB", (int)EMPLog.ERROR, (int)0, (String)"CacheConfig.getInstance()\u62a5\u9519:", (Throwable)e);
        }
        this.host = this.propManager.getPropertyValue("cachedb.redis.host");
        String portStr = this.propManager.getPropertyValue("cachedb.redis.port");
        this.port = Integer.valueOf(portStr);
        this.passwd = this.propManager.getPropertyValue("cachedb.redis.password");
    }

    private synchronized JedisPool getPool() {
        if (this.jedisPool == null) {
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)this.getConfig(), this.host, this.port, 100000);
        }
        return this.jedisPool;
    }

    private Jedis getJedis() {
        Jedis resource = this.getPool().getResource();
        if (this.passwd != null && !"".equals(this.passwd.trim())) {
            resource.auth(this.passwd);
        }
        return resource;
    }

    private JedisPoolConfig getConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        String maxTotal = this.propManager.getPropertyValue("cachedb.redis.maxTotal");
        config.setMaxTotal(maxTotal == null ? 500 : Integer.valueOf(maxTotal));
        String maxWaitMillis = this.propManager.getPropertyValue("cachedb.redis.maxWaitMillis");
        config.setMaxWaitMillis((long)(maxTotal == null ? 100000 : Integer.valueOf(maxWaitMillis)));
        String maxIdle = this.propManager.getPropertyValue("cachedb.redis.maxIdle");
        config.setMaxIdle(maxTotal == null ? 5 : Integer.valueOf(maxIdle));
        String timeBetweenEvictionRunsMillis = this.propManager.getPropertyValue("cachedb.redis.timeBetweenEvictionRunsMillis");
        config.setTimeBetweenEvictionRunsMillis((long)(maxTotal == null ? 60000 : Integer.valueOf(timeBetweenEvictionRunsMillis)));
        config.setTestWhileIdle(true);
        config.setTestOnBorrow(false);
        config.setTestOnReturn(false);
        return config;
    }

    @Override
    public Object getConnection() {
        return this.getJedis();
    }

    @Override
    public Set<String> getKeys(String keyPattern) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            Set keys = cli.keys(keyPattern);
            cli.close();
            return keys;
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public boolean exist(String key) throws CmisDaoException {
        Boolean exists = false;
        try {
            Jedis cli = this.getJedis();
            exists = cli.exists(key);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return exists;
    }

    @Override
    public void setSingleValue(String key, String value) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            cli.set(key, value);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setMultiValue(Map<String, String> cacheMap) throws CmisDaoException {
        if (cacheMap == null) {
            throw new CmisDaoException("\u53c2\u6570\u4e3anull");
        }
        Set<Map.Entry<String, String>> entrySet = cacheMap.entrySet();
        try {
            Jedis cli = this.getJedis();
            Transaction multi = cli.multi();
            for (Map.Entry<String, String> entry : entrySet) {
                multi.set(entry.getKey(), entry.getValue());
            }
            multi.exec();
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setSingleDomain(String key, CMISDomain domain) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            cli.set(key, this.domainToJson(domain));
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setSingleStrMap(String key, Map<String, String> map) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            cli.set(key, this.mapToJson(map));
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setSingleMap(String key, Map<String, Object> map) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            cli.set(key, this.mapToJson(map));
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public <T extends CMISDomain> void setMultiDomain(Map<String, T> cacheMap) throws CmisDaoException {
        if (cacheMap == null) {
            throw new CmisDaoException("\u53c2\u6570\u4e3anull");
        }
        Set<Map.Entry<String, T>> entrySet = cacheMap.entrySet();
        try {
            Jedis cli = this.getJedis();
            Transaction multi = cli.multi();
            for (Map.Entry<String, T> entry : entrySet) {
                multi.set(entry.getKey(), this.domainToJson((CMISDomain)entry.getValue()));
            }
            multi.exec();
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setSingleList(String key, List<String> list) throws CmisDaoException {
        try {
            if (list != null && list.size() > 0) {
                Jedis cli = this.getJedis();
                String[] listArray = list.toArray(new String[list.size()]);
                cli.del(key);
                cli.rpush(key, listArray);
                cli.close();
            }
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setMultiList(Map<String, List<String>> cacheMap) throws CmisDaoException {
        if (cacheMap == null) {
            throw new CmisDaoException("\u53c2\u6570\u4e3anull");
        }
        try {
            Set<Map.Entry<String, List<String>>> entrySet = cacheMap.entrySet();
            Jedis cli = this.getJedis();
            Transaction multi = cli.multi();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                String key = entry.getKey();
                List<String> list = entry.getValue();
                String[] listArray = list.toArray(new String[list.size()]);
                multi.del(key);
                multi.rpush(key, listArray);
            }
            multi.exec();
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public <T extends CMISDomain> void setSingleDomainList(String key, List<T> list) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            String[] domainArry = new String[list.size()];
            int index = 0;
            for (CMISDomain itemDomain : list) {
                domainArry[index] = this.domainToJson(itemDomain);
                ++index;
            }
            cli.del(key);
            cli.rpush(key, domainArry);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public <T extends CMISDomain> void setMultiDomainList(Map<String, List<T>> cacheMap) throws CmisDaoException {
        if (cacheMap == null) {
            throw new CmisDaoException("\u53c2\u6570\u4e3anull");
        }
        try {
            Set<Map.Entry<String, List<T>>> entrySet = cacheMap.entrySet();
            Jedis cli = this.getJedis();
            Transaction multi = cli.multi();
            for (Map.Entry<String, List<T>> entry : entrySet) {
                String key = entry.getKey();
                List<T> list = entry.getValue();
                String[] domainArry = new String[list.size()];
                int index = 0;
                for (CMISDomain itemDomain : list) {
                    domainArry[index] = this.domainToJson(itemDomain);
                    ++index;
                }
                multi.del(key);
                multi.rpush(key, domainArry);
            }
            multi.exec();
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setSingleListMap(String key, List<Map<String, String>> list) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            String[] domainArry = new String[list.size()];
            int index = 0;
            for (Map<String, String> item : list) {
                domainArry[index] = this.mapToJson(item);
                ++index;
            }
            cli.del(key);
            cli.rpush(key, domainArry);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public <T> void setSingleSerObject(String key, T object) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            byte[] bytes = this.objectToBytes(object);
            cli.set(SafeEncoder.encode((String)key), bytes);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void setMultiValueByFlatMap(Map map, String type, String separator) throws CmisDaoException {
        HashMap<String, String> flatMap = new HashMap<String, String>();
        this.flatAllMap(map, type, separator, flatMap);
        this.setMultiValue(flatMap);
    }

    @Override
    public void setSingleObjectByJson(String key, Object jsonObj) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            JSONObject fromObject = JSONObject.fromObject((Object)jsonObj);
            cli.set(key, fromObject.toString());
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public <T> T getSingleObjectByJson(String key, Class<T> clazz) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            String value = cli.get(key);
            Object bean = null;
            if (value != null) {
                JSONObject fromObject = JSONObject.fromObject((Object)value);
                bean = JSONObject.toBean((JSONObject)fromObject, clazz);
            }
            cli.close();
            return (T)bean;
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    private void flatAllMap(Map parentMap, String parentKey, String separator, Map<String, String> flatMap) {
        Set keySet = parentMap.keySet();
        for (Object key : keySet) {
            String newKey = String.valueOf(parentKey) + separator + key;
            Object value = parentMap.get(key);
            if (value instanceof Map) {
                this.flatAllMap((Map)value, newKey, separator, flatMap);
                continue;
            }
            flatMap.put(newKey, value.toString());
        }
    }

    @Override
    public void addSingleList(String key, List<String> list) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            String[] listArray = list.toArray(new String[list.size()]);
            cli.rpush(key, listArray);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public <T extends CMISDomain> void addSingleDomainList(String key, List<T> list) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            String[] domainArry = new String[list.size()];
            int index = 0;
            for (CMISDomain itemDomain : list) {
                domainArry[index] = this.domainToJson(itemDomain);
                ++index;
            }
            cli.rpush(key, domainArry);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public String getSingleValue(String key) throws CmisDaoException {
        String value = null;
        try {
            Jedis cli = this.getJedis();
            value = cli.get(key);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return value;
    }

    @Override
    public <T extends CMISDomain> T getSingleDomain(String key, Class<T> clazz) throws CmisDaoException {
        T domain = null;
        try {
            Jedis cli = this.getJedis();
            String value = cli.get(key);
            if (value != null) {
                domain = this.jsonToDomain(value, clazz);
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return domain;
    }

    @Override
    public <T extends CMISDomain> List<T> getSingleDomains(String keyPattern, Class<T> clazz) throws CmisDaoException {
        ArrayList<CMISDomain> list = new ArrayList<CMISDomain>();
        Object domain = null;
        try {
            domain = (CMISDomain)clazz.newInstance();
            Jedis cli = this.getJedis();
            Set keys = cli.keys(keyPattern);
            if (keys.size() > 0) {
                String[] keyArray = keys.toArray(new String[0]);
                List values = cli.mget(keyArray);
                for (String value : values) {
                    domain = this.jsonToDomain(value, clazz);
                    list.add((CMISDomain)domain);
                }
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return list;
    }

    @Override
    public Map<String, String> getSingleStrMap(String key) throws CmisDaoException {
        HashMap<String, String> map = new HashMap();
        try {
            Jedis cli = this.getJedis();
            String value = cli.get(key);
            if (value != null) {
                map = this.jsonToMap(value);
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return map;
    }

    @Override
    public Map<String, Object> getSingleMap(String key) throws CmisDaoException {
        HashMap<String, Object> map = new HashMap();
        try {
            Jedis cli = this.getJedis();
            String value = cli.get(key);
            if (value != null) {
                map = this.jsonToMap(value);
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return map;
    }

    @Override
    public List<String> getSingleList(String key) throws CmisDaoException {
        ArrayList<String> list = new ArrayList();
        try {
            Jedis cli = this.getJedis();
            list = cli.lrange(key, 0L, -1L);
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return list;
    }

    @Override
    public <T extends CMISDomain> List<T> getSingleDomainList(String key, Class<T> clazz) throws CmisDaoException {
        ArrayList<T> list = new ArrayList<T>();
        try {
            Jedis cli = this.getJedis();
            List lrange = cli.lrange(key, 0L, -1L);
            for (String value : lrange) {
                list.add(this.jsonToDomain(value, clazz));
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return list;
    }

    @Override
    public List<Map<String, String>> getSingleListMap(String key) throws CmisDaoException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            Jedis cli = this.getJedis();
            List lrange = cli.lrange(key, 0L, -1L);
            for (String value : lrange) {
                list.add(this.jsonToMap(value));
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
        return list;
    }

    @Override
    public <T> T getSingleSerObject(String key) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            byte[] bytes = cli.get(SafeEncoder.encode((String)key));
            cli.close();
            Object obj = null;
            if (bytes != null) {
                obj = this.objectFromBytes(bytes);
            }
            return (T)obj;
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    @Override
    public void deleteByKey(String keyPattern) throws CmisDaoException {
        try {
            Jedis cli = this.getJedis();
            Set keySet = cli.keys(keyPattern);
            if (keySet.size() > 0) {
                String[] keyArray = keySet.toArray(new String[keySet.size()]);
                cli.del(keyArray);
            }
            cli.close();
        }
        catch (Exception e) {
            throw new CmisDaoException(e);
        }
    }

    private <T extends CMISDomain> T jsonToDomain(String str, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        CMISDomain domain = (CMISDomain)clazz.newInstance();
        JSONObject jsonObj = JSONObject.fromObject((Object)str);
        Map map = (Map)JSONObject.toBean((JSONObject)jsonObj, HashMap.class);
        this.convertMapType(map, clazz);
        domain.getDataMap().putAll(map);
        return (T)domain;
    }

    private <T extends CMISDomain> void convertMapType(Map map, Class<T> clazz) {
        Set keySet = map.keySet();
        String key = null;
        for (Object object : keySet) {
            String parameterType;
            CMISDomainAnnotation annotation;
            key = object.toString();
            Object value = map.get(object);
            if (value == null) continue;
            String setMethodName = this.key2SetMethodName(key);
            Method[] methods = clazz.getMethods();
            Method setMethod = null;
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(setMethodName)) {
                    setMethod = method;
                    break;
                }
                ++n2;
            }
            if (setMethod == null || (annotation = setMethod.getAnnotation(CMISDomainAnnotation.class)) == null || (parameterType = annotation.parameterType()) == null) continue;
            if ("1".equals(parameterType)) {
                map.put(key, value.toString());
                continue;
            }
            if ("2".equals(parameterType)) {
                map.put(key, Integer.valueOf(value.toString()));
                continue;
            }
            if ("3".equals(parameterType)) {
                map.put(key, Float.valueOf(value.toString()));
                continue;
            }
            if ("4".equals(parameterType)) {
                map.put(key, Double.valueOf(value.toString()));
                continue;
            }
            if ("5".equals(parameterType)) {
                map.put(key, new BigDecimal(value.toString()));
                continue;
            }
            if ("6".equals(parameterType)) {
                map.put(key, Boolean.valueOf(value.toString()));
                continue;
            }
            if (!"7".equals(parameterType)) continue;
            map.put(key, new Date(Long.valueOf(value.toString())));
        }
    }

    private String key2SetMethodName(String column) {
        StringBuffer methodName = new StringBuffer();
        String[] split = column.split("_");
        int i = 0;
        while (i < split.length) {
            String str = split[i].toLowerCase();
            if (i == 0) {
                methodName.append("set" + str.substring(0, 1).toUpperCase() + str.substring(1));
            } else {
                methodName.append(String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1));
            }
            ++i;
        }
        return methodName.toString();
    }

    private String domainToJson(CMISDomain domain) {
        Map dataMap = domain.getDataMap();
        HashMap map = new HashMap();
        Set keySet = dataMap.keySet();
        for (Object key : keySet) {
            Object value = dataMap.get(key);
            if (value == null) continue;
            if (value instanceof Date) {
                map.put(key, ((Date)value).getTime());
                continue;
            }
            map.put(key, (Long)value);
        }
        return JSONObject.fromObject(map).toString();
    }

    private String mapToJson(Map map) {
        return JSONObject.fromObject((Object)map).toString();
    }

    private Map jsonToMap(String str) throws InstantiationException, IllegalAccessException {
        JSONObject jsonObj = JSONObject.fromObject((Object)str);
        Map map = (Map)JSONObject.toBean((JSONObject)jsonObj, HashMap.class);
        return map;
    }

    public byte[] objectToBytes(Object value) {
        if (value == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bytesOut);
            oos.writeObject(value);
            oos.flush();
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Object objectFromBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ois = new ObjectInputStream(bis);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) throws InstantiationException, IllegalAccessException {
        RedisDBCacheImpl redisDBCache = new RedisDBCacheImpl();
        SUser sUser = new SUser();
        sUser.setStr("string");
        sUser.setInteger(1);
        sUser.setFloat(Float.valueOf(23.0f));
        sUser.setDouble(24.0);
        sUser.setBigDecimal(new BigDecimal(1234.56).setScale(2, 4));
        sUser.setBoolean(true);
        sUser.setDate(new Date());
        Map dataMap = sUser.getDataMap();
        Set keySet = dataMap.keySet();
        for (Object object : keySet) {
            Object value = dataMap.get(object);
            System.out.println(object + " = " + value.getClass() + " = " + value);
        }
        String jsonStr = redisDBCache.domainToJson(sUser);
        System.out.println(jsonStr);
        SUser domain = redisDBCache.jsonToDomain(jsonStr, SUser.class);
        Map map = domain.getDataMap();
        Set keySet1 = map.keySet();
        for (Object object : keySet1) {
            Object value = map.get(object);
            System.out.println(object + " = " + value.getClass() + " = " + value);
        }
    }
}

