/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.cache;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.cache.taskqueue.domain.QueueQueryDomain;
import com.yucheng.cmis.cache.taskqueue.domain.TaskPoolDomain;
import com.yucheng.cmis.cache.taskqueue.domain.UserQueueDomain;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.cache.util.TaskQueueUtil;
import com.yucheng.cmis.exception.CmisDaoException;
import com.yucheng.cmis.pub.CMISDomain;
import com.yucheng.cmis.pub.annotation.CMISDomainAnnotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;

public class TaskQueueClient {
    private static final String LOGTYPE = "TaskQueue";
    private static final String PRIOTITY_KEY = "priority";
    private static final String PRIOTITY_HKEY_START = "priority";
    private static final String HASH_KEY_FIELD_SPPARATOR = "@";
    public static final String SORT_DESC = "DESC";
    public static final String SORT_ASC = "ASC";
    public static final String QUERY_TYPE_MORE_THAN = ">";
    public static final String QUERY_TYPE_LESS_THAN = "<";
    public static final String QUERY_TYPE_EQUALS = "=";
    public static final String QUERY_TYPE_CONTAIN = "IN";
    public static final int TEMP_DB_INDEX = 5;

    public static int getUserTaskQueueListCount(String usrCde, String taskType) {
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        Long hlen = cli.hlen(hashKey = String.valueOf(usrCde) + ":" + taskType);
        if (hlen == null) {
            hlen = 0L;
        }
        cli.close();
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217\u603b\u6570\u91cf", "", System.currentTimeMillis() - startTime);
        return hlen.intValue();
    }

    public static <T extends CMISDomain> List<T> getUserTaskQueueListByPage(String usrCde, String taskType, Class<T> clazz, int pageNumber, int pageSize) throws CmisDaoException {
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        Set hkeys = cli.hkeys(hashKey = String.valueOf(usrCde) + ":" + taskType);
        List<String> pageKeyList = TaskQueueClient.getPageKeyList(hkeys, pageNumber, pageSize);
        if (pageKeyList == null || pageKeyList.size() == 0) {
            cli.close();
            TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217(\u5206\u9875)", "", System.currentTimeMillis() - startTime);
            return new ArrayList();
        }
        String[] pageKeyArray = pageKeyList.toArray(new String[0]);
        List hvals = cli.hmget(hashKey, pageKeyArray);
        ArrayList<T> domainList = new ArrayList<T>();
        try {
            try {
                for (String val : hvals) {
                    T domain = TaskQueueClient.jsonToDomain(val, clazz);
                    domainList.add(domain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217(\u5206\u9875)", "", System.currentTimeMillis() - startTime);
        return domainList;
    }

    public static <T extends CMISDomain> List<T> getUserTaskQueueListByLimit(String usrCde, String taskType, Class<T> clazz, int start, int rows) throws CmisDaoException {
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        Set hkeys = cli.hkeys(hashKey = String.valueOf(usrCde) + ":" + taskType);
        List<String> pageKeyList = TaskQueueClient.getPageKeyListByLimit(hkeys, start, rows);
        if (pageKeyList == null || pageKeyList.size() == 0) {
            cli.close();
            TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217(\u5206\u9875limit)", "", System.currentTimeMillis() - startTime);
            return new ArrayList();
        }
        String[] pageKeyArray = pageKeyList.toArray(new String[0]);
        List hvals = cli.hmget(hashKey, pageKeyArray);
        ArrayList<T> domainList = new ArrayList<T>();
        try {
            try {
                for (String val : hvals) {
                    T domain = TaskQueueClient.jsonToDomain(val, clazz);
                    domainList.add(domain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217(\u5206\u9875limit)", "", System.currentTimeMillis() - startTime);
        return domainList;
    }

    public static <T extends CMISDomain> List<T> getUserTaskQueueList(String usrCde, String taskType, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        String hashKey = String.valueOf(usrCde) + ":" + taskType;
        List hvals = cli.hvals(hashKey);
        ArrayList<T> domainList = new ArrayList<T>();
        try {
            try {
                for (String val : hvals) {
                    T domain = TaskQueueClient.jsonToDomain(val, clazz);
                    domainList.add(domain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217", "", System.currentTimeMillis() - startTime);
        return domainList;
    }

    public static <T extends CMISDomain> List<T> getUserTaskQueueListOrderBy(String usrCde, String taskType, String orderField, String sortType, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        List<T> domainList = TaskQueueClient.getUserTaskQueueList(usrCde, taskType, clazz);
        if (sortType == null) {
            sortType = SORT_ASC;
        }
        List<T> sortedList = TaskQueueUtil.sort(domainList, orderField, sortType);
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217+\u6392\u5e8f", "", System.currentTimeMillis() - startTime);
        return sortedList;
    }

    public static <T extends CMISDomain> List<T> getUserTaskQueueListBy(String usrCde, String taskType, List<QueueQueryDomain> queryList, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        List<T> domainList = TaskQueueClient.getUserTaskQueueList(usrCde, taskType, clazz);
        List<T> filterdList = TaskQueueUtil.filter(domainList, queryList);
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217+\u8fc7\u6ee4", "", System.currentTimeMillis() - startTime);
        return filterdList;
    }

    public static <T extends CMISDomain> void addUserTask(String usrCde, String taskType, String taskKey, T domain) throws CmisDaoException {
        TaskQueueClient.addUserTask(usrCde, taskType, taskKey, domain, QueuePriority.NORMAL);
    }

    public static <T extends CMISDomain> void addUserTask(String usrCde, String taskType, String taskKey, T domain, QueuePriority priorityEnum) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        String hashKey = String.valueOf(usrCde) + ":" + taskType;
        String priorityHashKey = "priority:" + usrCde + ":" + taskType;
        String fieldKey = taskKey;
        UserQueueDomain uDomain = CMISDaoPropertyManager.getInstance().getUserQueue(taskType);
        if (uDomain == null || uDomain.getStatus() == null || uDomain.getStatus().equals("1")) {
            cli.close();
            throw new CmisDaoException("\u7528\u6237\u961f\u5217\uff1a" + taskType + "\u7684\u72b6\u6001\u4e3a\u4e0d\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4efb\u52a1!");
        }
        Long hlen = cli.hlen(hashKey);
        if (hlen != null && hlen.intValue() >= uDomain.getQueueDeep()) {
            cli.close();
            throw new CmisDaoException("\u7528\u6237:" + usrCde + "\u7684\u4efb\u52a1\u961f\u5217:" + taskType + "\u7684\u6df1\u5ea6\u5df2\u8d85\u8fc7\u6307\u5b9a\u6570\u503c\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4efb\u52a1!");
        }
        Boolean hexists = cli.hexists(hashKey, fieldKey);
        if (hexists != null && hexists.booleanValue()) {
            cli.close();
            throw new CmisDaoException("\u7528\u6237:" + usrCde + "\u7684\u4efb\u52a1\u961f\u5217:" + taskType + "\u5df2\u5b58\u5728\u8be5\u4efb\u52a1\uff0c\u4efb\u52a1key:" + hashKey + HASH_KEY_FIELD_SPPARATOR + fieldKey);
        }
        String jsonStr = TaskQueueClient.domainToJson(domain);
        Transaction multi = cli.multi();
        multi.hset(hashKey, fieldKey, jsonStr);
        multi.hset(priorityHashKey, fieldKey, String.valueOf(priorityEnum.getValue()));
        multi.exec();
        cli.close();
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u6dfb\u52a0\u7528\u6237\u961f\u5217", String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + fieldKey, System.currentTimeMillis() - startTime);
    }

    public static int deleteUserTask(String usrCde, String taskType, String taskKey) throws CmisDaoException {
        int delCount = 0;
        Jedis cli = (Jedis)CacheClient.getConnection();
        String hashKey = String.valueOf(usrCde) + ":" + taskType;
        String priorityHashKey = "priority:" + usrCde + ":" + taskType;
        String fieldKey = taskKey;
        Transaction multi = cli.multi();
        Response hdelRes = multi.hdel(hashKey, new String[]{fieldKey});
        multi.hdel(priorityHashKey, new String[]{fieldKey});
        multi.exec();
        delCount = hdelRes.get() == null ? 0 : ((Long)hdelRes.get()).intValue();
        cli.close();
        return delCount;
    }

    public static int getTaskPoolListCount(String taskPoolType) throws CmisDaoException {
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        Long hlen = cli.hlen(hashKey = taskPoolType);
        if (hlen == null) {
            hlen = 0L;
        }
        cli.close();
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u4efb\u52a1\u6c60\u603b\u6570\u91cf", "", System.currentTimeMillis() - startTime);
        return hlen.intValue();
    }

    public static <T extends CMISDomain> List<T> getTaskPoolListByPage(String taskPoolType, Class<T> clazz, int pageNumber, int pageSize) throws CmisDaoException {
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        Set hkeys = cli.hkeys(hashKey = taskPoolType);
        List<String> pageKeyList = TaskQueueClient.getPageKeyList(hkeys, pageNumber, pageSize);
        if (pageKeyList == null || pageKeyList.size() == 0) {
            cli.close();
            TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u4efb\u52a1\u6c60(\u5206\u9875)", "", System.currentTimeMillis() - startTime);
            return new ArrayList();
        }
        String[] pageKeyArray = pageKeyList.toArray(new String[0]);
        List hvals = cli.hmget(hashKey, pageKeyArray);
        ArrayList<T> domainList = new ArrayList<T>();
        try {
            try {
                for (String val : hvals) {
                    T domain = TaskQueueClient.jsonToDomain(val, clazz);
                    domainList.add(domain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217(\u5206\u9875)", "", System.currentTimeMillis() - startTime);
        return domainList;
    }

    public static <T extends CMISDomain> List<T> getTaskPoolListByLimit(String taskPoolType, Class<T> clazz, int start, int rows) throws CmisDaoException {
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        Set hkeys = cli.hkeys(hashKey = taskPoolType);
        List<String> pageKeyList = TaskQueueClient.getPageKeyListByLimit(hkeys, start, rows);
        if (pageKeyList == null || pageKeyList.size() == 0) {
            cli.close();
            TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u4efb\u52a1\u6c60(\u5206\u9875limit)", "", System.currentTimeMillis() - startTime);
            return new ArrayList();
        }
        String[] pageKeyArray = pageKeyList.toArray(new String[0]);
        List hvals = cli.hmget(hashKey, pageKeyArray);
        ArrayList<T> domainList = new ArrayList<T>();
        try {
            try {
                for (String val : hvals) {
                    T domain = TaskQueueClient.jsonToDomain(val, clazz);
                    domainList.add(domain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u7528\u6237\u961f\u5217(\u5206\u9875limit)", "", System.currentTimeMillis() - startTime);
        return domainList;
    }

    public static <T extends CMISDomain> List<T> getTaskPoolList(String taskPoolType, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        String hashKey = taskPoolType;
        List hvals = cli.hvals(hashKey);
        ArrayList<T> domainList = new ArrayList<T>();
        try {
            try {
                for (String val : hvals) {
                    T domain = TaskQueueClient.jsonToDomain(val, clazz);
                    domainList.add(domain);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u4efb\u52a1\u6c60", "", System.currentTimeMillis() - startTime);
        return domainList;
    }

    public static <T extends CMISDomain> List<T> getTaskPoolListOrderBy(String taskPoolType, String orderField, String sortType, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        List<T> domainList = TaskQueueClient.getTaskPoolList(taskPoolType, clazz);
        if (sortType == null) {
            sortType = SORT_ASC;
        }
        List<T> sortedList = TaskQueueUtil.sort(domainList, orderField, sortType);
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u83b7\u53d6\u4efb\u52a1\u6c60+\u6392\u5e8f", "", System.currentTimeMillis() - startTime);
        return sortedList;
    }

    public static <T extends CMISDomain> T getTaskFromTaskPool(String taskPoolType, Class<T> clazz) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        try {
            T domain = TaskQueueClient.getTaskFromTaskPoolChirld(taskPoolType, clazz, cli);
            TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u76f2\u9886", taskPoolType, System.currentTimeMillis() - startTime);
            T t = domain;
            return t;
        }
        catch (CmisDaoException e) {
            throw e;
        }
        finally {
            cli.close();
        }
    }

    private static <T extends CMISDomain> T getTaskFromTaskPoolChirld(String taskPoolType, Class<T> clazz, Jedis cli) throws CmisDaoException {
        String hashKey = taskPoolType;
        String priorityHashKey = "priority:" + taskPoolType;
        cli.select(0);
        Long llen = cli.hlen(hashKey);
        if (llen == null || llen.intValue() == 0) {
            throw new CmisDaoException(String.valueOf(hashKey) + " \u7684\u4efb\u52a1\u961f\u5217\u4e0d\u5b58\u5728!");
        }
        Map priorityMap = cli.hgetAll(priorityHashKey);
        Set priorityEntrySet = priorityMap.entrySet();
        Integer highestPriority = null;
        String highestPriorityFieldKey = null;
        cli.select(5);
        for (Map.Entry priorityEntry : priorityEntrySet) {
            Boolean exists;
            String fieldKey = (String)priorityEntry.getKey();
            String tempKey = String.valueOf(taskPoolType) + HASH_KEY_FIELD_SPPARATOR + fieldKey;
            Integer thisPriority = Integer.valueOf((String)priorityEntry.getValue());
            if (highestPriority == null) {
                exists = cli.exists(tempKey);
                if (exists.booleanValue()) continue;
                highestPriority = thisPriority;
                highestPriorityFieldKey = (String)priorityEntry.getKey();
                continue;
            }
            if (thisPriority >= highestPriority || (exists = cli.exists(tempKey)).booleanValue()) continue;
            highestPriority = thisPriority;
            highestPriorityFieldKey = (String)priorityEntry.getKey();
        }
        if (highestPriority == null) {
            throw new CmisDaoException(String.valueOf(taskPoolType) + " \u7684\u4efb\u52a1\u961f\u5217\u4e0d\u5b58\u5728!");
        }
        cli.select(5);
        String tempKey = String.valueOf(taskPoolType) + HASH_KEY_FIELD_SPPARATOR + highestPriorityFieldKey;
        Long setnx = cli.setnx(tempKey, "G");
        if (setnx == null || setnx == 0L) {
            return TaskQueueClient.getTaskFromTaskPoolChirld(taskPoolType, clazz, cli);
        }
        T domain = null;
        cli.select(0);
        String val = cli.hget(hashKey, highestPriorityFieldKey);
        if (val == null) {
            cli.select(5);
            cli.del(tempKey);
            return TaskQueueClient.getTaskFromTaskPoolChirld(taskPoolType, clazz, cli);
        }
        try {
            domain = TaskQueueClient.jsonToDomain(val, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return domain;
    }

    public static <T extends CMISDomain> T getTaskFromTaskPool(String taskPoolType, String taskKey, Class<T> clazz) throws CmisDaoException {
        String fieldKey;
        String hashKey;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        String val = cli.hget(hashKey = taskPoolType, fieldKey = taskKey);
        if (val == null) {
            cli.close();
            throw new CmisDaoException(String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + taskKey + " \u7684\u4efb\u52a1\u961f\u5217\u4e0d\u5b58\u5728!");
        }
        String tempKey = String.valueOf(taskPoolType) + HASH_KEY_FIELD_SPPARATOR + taskKey;
        cli.select(5);
        Long setnx = cli.setnx(tempKey, "G");
        if (setnx == null || setnx == 0L) {
            cli.close();
            throw new CmisDaoException(String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + taskKey + " \u7684\u4efb\u52a1\u961f\u5217\u5df2\u7ecf\u88ab\u53d6\u8d70!");
        }
        T domain = null;
        try {
            try {
                domain = TaskQueueClient.jsonToDomain(val, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            cli.close();
        }
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u660e\u9886", String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + taskKey, System.currentTimeMillis() - startTime);
        return domain;
    }

    public static <T extends CMISDomain> void addTaskPool(String taskPoolType, String taskKey, boolean useProperties, T domain) throws CmisDaoException {
        TaskQueueClient.addTaskPool(taskPoolType, taskKey, useProperties, domain, QueuePriority.NORMAL);
    }

    public static <T extends CMISDomain> void addTaskPool(String taskPoolType, String taskKey, boolean useProperties, T domain, QueuePriority priorityEnum) throws CmisDaoException {
        Boolean hexists;
        long startTime = System.currentTimeMillis();
        Jedis cli = (Jedis)CacheClient.getConnection();
        String hashKey = taskPoolType;
        String priorityHashKey = "priority:" + taskPoolType;
        String fieldKey = taskKey;
        if (useProperties) {
            TaskPoolDomain tDomain = CMISDaoPropertyManager.getInstance().getTaskPool(taskPoolType);
            if (tDomain == null || tDomain.getStatus() == null || tDomain.getStatus().equals("1")) {
                cli.close();
                throw new CmisDaoException("\u4efb\u52a1\u6c60\uff1a" + taskPoolType + "\u7684\u72b6\u6001\u4e3a\u4e0d\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4efb\u52a1!");
            }
            Long hlen = cli.hlen(hashKey);
            if (hlen != null && hlen.intValue() >= tDomain.getPoolDeep()) {
                cli.close();
                throw new CmisDaoException("\u4efb\u52a1\u6c60\uff1a" + taskPoolType + "\u7684\u6df1\u5ea6\u5df2\u8d85\u8fc7\u6307\u5b9a\u6570\u503c" + tDomain.getPoolDeep() + "\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u4efb\u52a1!");
            }
        }
        if ((hexists = cli.hexists(hashKey, fieldKey)) != null && hexists.booleanValue()) {
            cli.close();
            throw new CmisDaoException(String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + fieldKey + " \u5df2\u7ecf\u5b58\u5728\uff01");
        }
        String jsonValue = TaskQueueClient.domainToJson(domain);
        Transaction multi = cli.multi();
        multi.hset(hashKey, fieldKey, jsonValue);
        multi.hset(priorityHashKey, fieldKey, String.valueOf(priorityEnum.getValue()));
        multi.exec();
        cli.close();
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u6dfb\u52a0\u4efb\u52a1\u6c60", String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + fieldKey, System.currentTimeMillis() - startTime);
    }

    public static int deleteTaskPool(String taskPoolType, String taskKey) throws CmisDaoException {
        long startTime = System.currentTimeMillis();
        int delCount = 0;
        Jedis cli = (Jedis)CacheClient.getConnection();
        String hashKey = taskPoolType;
        String priorityHashKey = "priority:" + taskPoolType;
        String fieldKey = taskKey;
        Transaction multi = cli.multi();
        Response hdelRes = multi.hdel(hashKey, new String[]{fieldKey});
        multi.hdel(priorityHashKey, new String[]{fieldKey});
        multi.exec();
        String tempKey = String.valueOf(taskPoolType) + HASH_KEY_FIELD_SPPARATOR + taskKey;
        cli.select(5);
        cli.del(tempKey);
        delCount = hdelRes.get() == null ? 0 : ((Long)hdelRes.get()).intValue();
        cli.close();
        TaskQueueClient.taskQueueClientLog(EMPLog.DEBUG, "\u5220\u9664\u4efb\u52a1\u6c60\u4efb\u52a1", String.valueOf(hashKey) + HASH_KEY_FIELD_SPPARATOR + fieldKey, System.currentTimeMillis() - startTime);
        return delCount;
    }

    public static void modifyTaskPoolPriority(String taskPoolType, String taskKey, QueuePriority priorityEnum) throws CmisDaoException {
        String priorityHashKey = "priority:" + taskPoolType;
        String fieldKey = taskKey;
        Jedis cli = (Jedis)CacheClient.getConnection();
        String tempKey = String.valueOf(taskPoolType) + HASH_KEY_FIELD_SPPARATOR + taskKey;
        cli.select(5);
        Long setnx = cli.setnx(tempKey, "P");
        if (setnx == null || setnx.intValue() == 0) {
            throw new CmisDaoException(String.valueOf(taskPoolType) + HASH_KEY_FIELD_SPPARATOR + taskKey + "\u7684\u4efb\u52a1\u961f\u5217\u5df2\u7ecf\u88ab\u53d6\u8d70\u6216\u8005\u88ab\u5176\u4ed6\u4eba\u4fee\u6539\uff01");
        }
        cli.select(0);
        cli.hset(priorityHashKey, fieldKey, String.valueOf(priorityEnum.getValue()));
        cli.select(5);
        cli.del(tempKey);
        cli.close();
    }

    public static void modifyTaskPoolPriority(String taskPoolType, QueuePriority priorityEnum, String ... taskKeys) throws CmisDaoException {
        if (taskKeys != null) {
            String[] stringArray = taskKeys;
            int n = taskKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String taskKey = stringArray[n2];
                TaskQueueClient.modifyTaskPoolPriority(taskPoolType, taskKey, priorityEnum);
                ++n2;
            }
        }
    }

    private static <T extends CMISDomain> T jsonToDomain(String str, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        CMISDomain domain = (CMISDomain)clazz.newInstance();
        JSONObject jsonObj = JSONObject.fromObject((Object)str);
        Map map = (Map)JSONObject.toBean((JSONObject)jsonObj, HashMap.class);
        TaskQueueClient.convertMapType(map, clazz);
        domain.getDataMap().putAll(map);
        return (T)domain;
    }

    private static <T extends CMISDomain> void convertMapType(Map map, Class<T> clazz) {
        Set keySet = map.keySet();
        String key = null;
        for (Object object : keySet) {
            String parameterType;
            CMISDomainAnnotation annotation;
            key = object.toString();
            Object value = map.get(object);
            if (value == null) continue;
            String setMethodName = TaskQueueClient.key2SetMethodName(key);
            Method[] methods = clazz.getMethods();
            Method setMethod = null;
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(setMethodName)) {
                    setMethod = method;
                    break;
                }
                ++n2;
            }
            if (setMethod == null || (annotation = setMethod.getAnnotation(CMISDomainAnnotation.class)) == null || (parameterType = annotation.parameterType()) == null) continue;
            if ("1".equals(parameterType)) {
                map.put(key, value.toString());
                continue;
            }
            if ("2".equals(parameterType)) {
                map.put(key, Integer.valueOf(value.toString()));
                continue;
            }
            if ("3".equals(parameterType)) {
                map.put(key, Float.valueOf(value.toString()));
                continue;
            }
            if ("4".equals(parameterType)) {
                map.put(key, Double.valueOf(value.toString()));
                continue;
            }
            if ("5".equals(parameterType)) {
                map.put(key, new BigDecimal(value.toString()));
                continue;
            }
            if ("6".equals(parameterType)) {
                map.put(key, Boolean.valueOf(value.toString()));
                continue;
            }
            if (!"7".equals(parameterType)) continue;
            map.put(key, new Date(Long.valueOf(value.toString())));
        }
    }

    private static String key2SetMethodName(String column) {
        StringBuffer methodName = new StringBuffer();
        String[] split = column.split("_");
        int i = 0;
        while (i < split.length) {
            String str = split[i].toLowerCase();
            if (i == 0) {
                methodName.append("set" + str.substring(0, 1).toUpperCase() + str.substring(1));
            } else {
                methodName.append(String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1));
            }
            ++i;
        }
        return methodName.toString();
    }

    private static String domainToJson(CMISDomain domain) {
        Map dataMap = domain.getDataMap();
        HashMap map = new HashMap();
        Set keySet = dataMap.keySet();
        for (Object key : keySet) {
            Object value = dataMap.get(key);
            if (value == null) continue;
            if (value instanceof Date) {
                map.put(key, ((Date)value).getTime());
                continue;
            }
            map.put(key, (Long)value);
        }
        return JSONObject.fromObject(map).toString();
    }

    private static List<String> getPageKeyList(Set<String> hkeys, int pageNumber, int pageSize) {
        if (pageNumber < 0) {
            pageNumber = 0;
        }
        if (pageSize < 0) {
            pageSize = 0;
        }
        int startIndex = (pageNumber - 1) * pageSize;
        int endIndex = pageNumber * pageSize;
        ArrayList<String> list = new ArrayList<String>(hkeys);
        Collections.sort(list);
        if (startIndex > list.size()) {
            return new ArrayList<String>();
        }
        if (endIndex > list.size()) {
            endIndex = list.size();
        }
        List<String> subList = list.subList(startIndex, endIndex);
        return subList;
    }

    private static List<String> getPageKeyListByLimit(Set<String> hkeys, int start, int rows) {
        if (start < 0) {
            start = 0;
        }
        if (rows < 0) {
            rows = 0;
        }
        int startIndex = start;
        int endIndex = start + rows;
        ArrayList<String> list = new ArrayList<String>(hkeys);
        Collections.sort(list);
        if (startIndex > list.size()) {
            return new ArrayList<String>();
        }
        if (endIndex > list.size()) {
            endIndex = list.size();
        }
        List<String> subList = list.subList(startIndex, endIndex);
        return subList;
    }

    private static void taskQueueClientLog(int level, String method, String key, long useTime) {
        EMPLog.log((String)LOGTYPE, (int)level, (int)0, (String)("[" + method + "]:\u8017\u65f6" + useTime + "ms - " + key));
    }

    public static enum QueuePriority {
        HIGHEST(0),
        HIGH(1),
        MIDDLE(2),
        NORMAL(3),
        LOW(4);

        private int value = 0;

        private QueuePriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

