/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.test.dependon;

import com.yucheng.cmis.dao.config.SqlConfigLoader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestBase {
    public static Connection connection = null;
    public static final String driver = "oracle.jdbc.driver.OracleDriver";
    public static final String url = "jdbc:oracle:thin:@192.168.251.139:1521:cmis";
    public static final String user = "cmis_plat";
    public static final String pass = "cmis_plat";
    public static final String sql_file = "src/main/java/com/yucheng/cmis/test/dependon/test.sql.xml";
    protected static final String createSql = "create table TEST_CMIS_DAO_TABLE( t_id varchar2(32),t_name varchar2(80),t_age number(4), t_pay number(24,4), memo clob)";
    protected static final String insertSql = "insert into TEST_CMIS_DAO_TABLE(t_id,t_name,t_age,t_pay)values(?,?,?,?)";
    protected static final String dropSql = "drop table TEST_CMIS_DAO_TABLE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void init() {
        TestBase.createConnection();
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute(createSql);
            TestBase.initData();
        }
        catch (Exception e) {
            try {
                stmt.execute(dropSql);
                stmt.execute(createSql);
                TestBase.initData();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        TestBase.loadSqlFile(null);
    }

    private static void initData() {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(insertSql);
            for (int i = 0; i < 20; ++i) {
                stmt.setString(1, "1000" + i);
                stmt.setString(2, "\u5c0f" + i);
                if (i % 2 == 0) {
                    stmt.setInt(3, 25);
                } else {
                    stmt.setInt(3, 30);
                }
                if (i % 2 == 0) {
                    stmt.setBigDecimal(4, new BigDecimal(5000.89));
                } else {
                    stmt.setBigDecimal(4, new BigDecimal(6000.89));
                }
                stmt.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void destroy() {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            stmt.execute(dropSql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                stmt.close();
                TestBase.releaseConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static void createConnection() {
        try {
            if (connection == null || connection.isClosed()) {
                Class.forName(driver);
                connection = DriverManager.getConnection(url, "cmis_plat", "cmis_plat");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadSqlFile(String file) {
        SqlConfigLoader loader = new SqlConfigLoader();
        try {
            if (file == null) {
                loader.doDigestSQLFile(sql_file);
            } else {
                loader.doDigestSQLFile(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void releaseConnection() {
        try {
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

