/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.test;

import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.cache.TaskQueueClient;
import com.yucheng.cmis.cache.taskqueue.domain.QueueQueryDomain;
import com.yucheng.cmis.dao.test.SUser;
import com.yucheng.cmis.exception.CmisDaoException;
import com.yucheng.cmis.test.MyThread;
import com.yucheng.cmis.test.dependon.WfiWorklistTodo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import junit.framework.TestCase;
import redis.clients.jedis.Jedis;

public class TaskQueueClientTest
extends TestCase {
    public void testByThread() throws CmisDaoException {
        int start = 0;
        int sum = 100;
        try {
            TaskQueueClient.getTaskFromTaskPool("sss", WfiWorklistTodo.class);
            Thread.sleep(1000L);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        for (int i = start; i < start + sum; ++i) {
            new MyThread(i).start();
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(30000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void testAAddUserTask() throws CmisDaoException {
        String taskType = "user.queue.type2";
        WfiWorklistTodo workTodoTask = this.getWorkTodoTask("USER-0", "00000002");
        TaskQueueClient.addUserTask("USER-0", taskType, "00000002", workTodoTask);
        System.out.println("=======");
    }

    public void testAGetUserTaskQueueList() throws CmisDaoException {
        String taskType = "user.queue.type2";
        List<WfiWorklistTodo> list = TaskQueueClient.getUserTaskQueueList("USER-0", taskType, WfiWorklistTodo.class);
        for (WfiWorklistTodo todo : list) {
            System.out.println(todo.getPkValue());
        }
    }

    public void testADeleteUserTask() throws CmisDaoException {
        String taskType = "user.queue.type2";
        TaskQueueClient.deleteUserTask("USER-0", taskType, "00000002");
    }

    private WfiWorklistTodo getWorkTodoTask(String currentUserId, String taskKey) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strDate = sf.format(new Date());
        WfiWorklistTodo todo = new WfiWorklistTodo();
        todo.setInstanceid(UUID.randomUUID().toString());
        todo.setPkValue(taskKey);
        todo.setApplType("tapptype");
        todo.setCusId("\u5ba2\u6237ID_demo");
        todo.setCusName("\u5ba2\u6237\u540d\u79f0_demo");
        todo.setPrenodeid("00");
        todo.setPrenodename("\u524d\u4e00\u8282\u70b9");
        todo.setNodeid("01");
        todo.setNodename("\u5f53\u524d\u8282\u70b9");
        todo.setCurrentnodeuser(currentUserId);
        todo.setNodestatus("\u63d0\u4ea4");
        todo.setNodestarttime(strDate);
        todo.setWfname("\u6d4b\u8bd5xxxx");
        todo.setStatusName("\u529e\u7406\u4e2d");
        return todo;
    }

    public void testGetUserTaskQueueListByPage() throws CmisDaoException {
        int count = TaskQueueClient.getUserTaskQueueListCount("USER-342", "user.queue.type2");
        System.out.println("=========" + count);
        for (int i = 0; i < 10; ++i) {
            List<WfiWorklistTodo> list1 = TaskQueueClient.getUserTaskQueueListByPage("USER-342", "user.queue.type2", WfiWorklistTodo.class, i + 1, 10);
            for (WfiWorklistTodo todo : list1) {
                System.out.println(todo.getPkValue());
            }
        }
    }

    public void testGetTaskPoolListByPage() throws CmisDaoException {
        int count = TaskQueueClient.getTaskPoolListCount("");
        System.out.println("=========" + count);
        for (int i = 0; i < 10; ++i) {
            List<WfiWorklistTodo> list1 = TaskQueueClient.getUserTaskQueueListByPage("USER-342", "user.queue.type2", WfiWorklistTodo.class, i + 1, 10);
            for (WfiWorklistTodo todo : list1) {
                System.out.println(todo.getPkValue());
            }
        }
    }

    public void testTaskPoolGetThreads() throws CmisDaoException {
        String taskPoolType = "task.pool.type1";
        CacheClient.deleteByKey("task.pool.type1:*");
        Jedis cli = (Jedis)CacheClient.getConnection();
        cli.select(5);
        cli.flushDB();
        cli.close();
        for (int i = 0; i < 10; ++i) {
            String taskKey = "000000" + i;
            SUser sUser = new SUser();
            sUser.setActorno("pooltask" + i);
            sUser.setActorname("\u5f85\u5ba1\u6838\u4efb\u52a100" + i);
            TaskQueueClient.addTaskPool("task.pool.type1", taskKey, true, sUser);
        }
        final ArrayList msgs = new ArrayList();
        for (int i = 0; i < 1000; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    long id = Thread.currentThread().getId();
                    try {
                        SUser task = TaskQueueClient.getTaskFromTaskPool("task.pool.type1", SUser.class);
                        List list = msgs;
                        synchronized (list) {
                            msgs.add("Thread-" + id + " : " + task.getDataMap());
                        }
                    }
                    catch (Exception e) {
                        List list = msgs;
                        synchronized (list) {
                            msgs.add("Thread-" + id + " : " + e.getMessage());
                        }
                    }
                }
            }.start();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("===================");
        for (String msg : msgs) {
            System.out.println(msg);
        }
    }

    public void testTaskPoolGet() throws CmisDaoException {
        String taskPoolType = "task.pool.type1";
        String taskKey = "00000003";
        String taskKey1 = "00000004";
        SUser sUser1 = new SUser();
        sUser1.setActorno("pooltask1");
        sUser1.setActorname("\u5f85\u5ba1\u6838\u4efb\u52a1001");
        SUser sUser2 = new SUser();
        sUser2.setActorno("pooltask2");
        sUser2.setActorname("\u5f85\u5ba1\u6838\u4efb\u52a1002");
        CacheClient.deleteByKey(taskPoolType + ":" + "*");
        TaskQueueClient.addTaskPool(taskPoolType, taskKey, true, sUser1);
        TaskQueueClient.addTaskPool(taskPoolType, taskKey1, true, sUser2, TaskQueueClient.QueuePriority.HIGHEST);
        SUser task = TaskQueueClient.getTaskFromTaskPool(taskPoolType, SUser.class);
        System.out.println(task.getDataMap());
    }

    public void testUserTask() throws CmisDaoException {
        String usrCde = "admin";
        String taskType = "user.queue.type1";
        String taskKey = "00000001";
        String taskKey1 = "00000002";
        SUser user1 = new SUser();
        user1.setActorno(usrCde);
        user1.setActorname(taskKey);
        SUser user2 = new SUser();
        user2.setActorno(usrCde);
        user2.setActorname(taskKey);
        CacheClient.deleteByKey(usrCde + ":" + taskType + ":" + "*");
        System.out.println("\n==============\u6dfb\u52a0-\u5f00\u59cb============");
        TaskQueueClient.addUserTask(usrCde, taskType, taskKey, user1);
        TaskQueueClient.addUserTask(usrCde, taskType, taskKey1, user2, TaskQueueClient.QueuePriority.HIGH);
        try {
            TaskQueueClient.addUserTask(usrCde, taskType, taskKey, user1, TaskQueueClient.QueuePriority.HIGH);
        }
        catch (CmisDaoException e) {
            System.out.println(">>>> \u91cd\u590d\u6dfb\u52a0\u629b\u51fa\u5f02\u5e38:" + e.getMessage());
        }
        System.out.println("==============\u6dfb\u52a0-\u7ed3\u675f============");
        System.out.println("\n==============\u666e\u901a\u67e5\u8be2-\u5f00\u59cb============");
        List<SUser> list = TaskQueueClient.getUserTaskQueueList(usrCde, taskType, SUser.class);
        for (SUser sUser : list) {
            System.out.println(">>>> " + sUser.getDataMap());
        }
        System.out.println("==============\u666e\u901a\u67e5\u8be2-\u7ed3\u675f============");
        System.out.println("\n==============\u67e5\u8be2\u6392\u5e8f-\u5f00\u59cb============");
        List<SUser> list1 = TaskQueueClient.getUserTaskQueueListOrderBy(usrCde, taskType, "actorno", "DESC", SUser.class);
        for (SUser sUser : list1) {
            System.out.println(">>>> " + sUser.getDataMap());
        }
        System.out.println("==============\u67e5\u8be2\u6392\u5e8f-\u7ed3\u675f============");
        System.out.println("\n==============\u67e5\u8be2\u8fc7\u6ee4-\u5f00\u59cb============");
        ArrayList<QueueQueryDomain> queryFields = new ArrayList<QueueQueryDomain>();
        QueueQueryDomain domain = new QueueQueryDomain();
        domain.setQueryType(">");
        domain.setQueryFieldName("actorno");
        domain.setQueryFieldValue("mytask1");
        queryFields.add(domain);
        List<SUser> list2 = TaskQueueClient.getUserTaskQueueListBy(usrCde, taskType, queryFields, SUser.class);
        for (SUser sUser : list2) {
            System.out.println(">>>> " + sUser.getDataMap());
        }
        System.out.println("==============\u67e5\u8be2\u8fc7\u6ee4-\u7ed3\u675f============");
        System.out.println("\n==============\u5220\u9664-\u5f00\u59cb============");
        TaskQueueClient.deleteUserTask(usrCde, taskType, taskKey);
        TaskQueueClientTest.assertEquals((int)CacheClient.getKeys(usrCde + ":" + taskType + ":" + "*" + ":" + taskKey).size(), (int)0);
        TaskQueueClient.deleteUserTask(usrCde, taskType, taskKey1);
        TaskQueueClientTest.assertEquals((int)CacheClient.getKeys(usrCde + ":" + taskType + ":" + "*" + ":" + taskKey1).size(), (int)0);
        System.out.println("==============\u5220\u9664-\u7ed3\u675f============");
    }

    public void testTaskPool() throws CmisDaoException {
        String taskPoolType = "task.pool.type2";
        String taskKey = "00000001";
        String taskKey1 = "00000002";
        SUser sUser1 = new SUser();
        sUser1.setActorno("pooltask1");
        sUser1.setActorname("\u5f85\u5ba1\u6838\u4efb\u52a1001");
        SUser sUser2 = new SUser();
        sUser2.setActorno("pooltask2");
        sUser2.setActorname("\u5f85\u5ba1\u6838\u4efb\u52a1002");
        CacheClient.deleteByKey(taskPoolType + ":" + "*");
        System.out.println("\n==============\u6dfb\u52a0-\u5f00\u59cb============");
        TaskQueueClient.addTaskPool(taskPoolType, taskKey, true, sUser1);
        TaskQueueClient.addTaskPool(taskPoolType, taskKey1, true, sUser2, TaskQueueClient.QueuePriority.HIGHEST);
        try {
            TaskQueueClient.addTaskPool(taskPoolType, taskKey, true, sUser1);
        }
        catch (CmisDaoException e) {
            System.out.println(">>>> \u91cd\u590d\u6dfb\u52a0\u629b\u51fa\u5f02\u5e38:" + e.getMessage());
        }
        System.out.println("==============\u6dfb\u52a0-\u7ed3\u675f============");
        System.out.println("\n==============\u4fee\u6539\u4f18\u5148\u7ea7-\u5f00\u59cb============");
        TaskQueueClient.modifyTaskPoolPriority(taskPoolType, TaskQueueClient.QueuePriority.LOW, taskKey, taskKey1);
        TaskQueueClient.modifyTaskPoolPriority(taskPoolType, taskKey, TaskQueueClient.QueuePriority.HIGH);
        System.out.println("==============\u4fee\u6539\u4f18\u5148\u7ea7-\u7ed3\u675f============");
        System.out.println("\n==============\u67e5\u8be2-\u5f00\u59cb============");
        List<SUser> list = TaskQueueClient.getTaskPoolList(taskPoolType, SUser.class);
        for (SUser sUser : list) {
            System.out.println(sUser.getDataMap());
        }
        System.out.println("==============\u67e5\u8be2-\u7ed3\u675f============");
        System.out.println("\n==============\u67e5\u8be2\u6392\u5e8f-\u5f00\u59cb============");
        List<SUser> list1 = TaskQueueClient.getTaskPoolListOrderBy(taskPoolType, "actorno", "DESC", SUser.class);
        for (SUser sUser : list1) {
            System.out.println(sUser.getDataMap());
        }
        System.out.println("==============\u67e5\u8be2\u6392\u5e8f-\u7ed3\u675f============");
    }

    protected void setUp() throws Exception {
        System.out.println("------------" + this.getName() + "-----------");
        super.setUp();
    }
}

