/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.test;

import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.dao.test.SUser;
import com.yucheng.cmis.exception.CmisDaoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class CacheDBRedisTest
extends TestCase {
    public void testExist() throws CmisDaoException {
        CacheDBRedisTest.assertEquals((boolean)CacheClient.exist("test:testExist"), (boolean)false);
    }

    public void testSetSingleValue() throws CmisDaoException {
        CacheClient.setSingleValue("cust:val", "value1");
        String singleValue = CacheClient.getSingleValue("cust:val");
        CacheDBRedisTest.assertEquals((String)singleValue, (String)"value1");
    }

    public void testSetMultiValue() throws CmisDaoException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("cust:val", "value");
        CacheClient.setMultiValue(hashMap);
        String singleValue = CacheClient.getSingleValue("cust:val");
        CacheDBRedisTest.assertEquals((String)singleValue, (String)"value");
    }

    public void testSetSingleDomain() throws CmisDaoException {
        SUser sUser0 = new SUser();
        sUser0.setActorno("0002");
        sUser0.setActorname("\u5f20\u4e09");
        CacheClient.setSingleDomain("cust:object", sUser0);
        SUser domain = CacheClient.getSingleDomain("cust:object", SUser.class);
        CacheDBRedisTest.assertEquals((String)"0002", (String)domain.getActorno());
    }

    public void testSetMultiDomain() throws CmisDaoException {
        HashMap<String, SUser> map = new HashMap<String, SUser>();
        SUser sUser = new SUser();
        sUser.setActorno("0001");
        sUser.setActorname("\u5f20\u4e09");
        map.put("cust:object", sUser);
        CacheClient.setMultiDomain(map);
        SUser domain = CacheClient.getSingleDomain("cust:object", SUser.class);
        CacheDBRedisTest.assertEquals((String)"0001", (String)domain.getActorno());
    }

    public void testSetSingleList() throws CmisDaoException {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("ssss");
        CacheClient.setSingleList("cust:list", list1);
        List<String> singleList = CacheClient.getSingleList("cust:list");
        CacheDBRedisTest.assertEquals((String)singleList.get(0), (String)"ssss");
    }

    public void testSetMultiList() throws CmisDaoException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        ArrayList<String> list = new ArrayList<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("abc");
                this.add("def");
            }
        };
        hashMap.put("cust:list", list);
        CacheClient.setMultiList(hashMap);
        List<String> singleList = CacheClient.getSingleList("cust:list");
        CacheDBRedisTest.assertEquals((int)singleList.size(), (int)2);
    }

    public void testSetSingleDomainList() throws CmisDaoException {
        ArrayList<SUser> list1 = new ArrayList<SUser>();
        SUser sUser = new SUser();
        sUser.setActorno("0002");
        sUser.setActorname("lisi");
        list1.add(sUser);
        CacheClient.setSingleDomainList("cust:objectList", list1);
        List<SUser> list = CacheClient.getSingleDomainList("cust:objectList", SUser.class);
        CacheDBRedisTest.assertEquals((int)list.size(), (int)1);
    }

    public void testSetMultiDomainList() throws CmisDaoException {
        HashMap hashMap = new HashMap();
        ArrayList<SUser> list11 = new ArrayList<SUser>(){
            private static final long serialVersionUID = 1L;
            {
                SUser sUser = new SUser();
                sUser.setActorno("0003");
                sUser.setActorname("lisi");
                this.add(sUser);
            }
        };
        hashMap.put("cust:objectList", list11);
        CacheClient.setMultiDomainList(hashMap);
        List<SUser> list = CacheClient.getSingleDomainList("cust:objectList", SUser.class);
        CacheDBRedisTest.assertEquals((int)list.size(), (int)1);
    }

    public void testAddSingleList() throws CmisDaoException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("hello");
        CacheClient.addSingleList("cust:addSingleList", list);
        List<String> singleList = CacheClient.getSingleList("cust:addSingleList");
        CacheDBRedisTest.assertTrue((singleList.size() >= list.size() ? 1 : 0) != 0);
    }

    public void testAddSingleDomainList() throws CmisDaoException {
        ArrayList<SUser> list = new ArrayList<SUser>();
        SUser sUser = new SUser();
        sUser.setActorno("0012");
        sUser.setActorname("heel");
        list.add(sUser);
        CacheClient.addSingleDomainList("cust:addSingleObjectList", list);
        List<SUser> singleObjectList = CacheClient.getSingleDomainList("cust:addSingleObjectList", SUser.class);
        CacheDBRedisTest.assertTrue((singleObjectList.size() >= list.size() ? 1 : 0) != 0);
    }

    public void testSetSingleStrMap() throws CmisDaoException {
        HashMap<String, String> setMap = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("name1", "\u5f20\u4e09");
                this.put("name2", "\u674e\u56db");
            }
        };
        CacheClient.setSingleStrMap("cust:strMap", (Map<String, String>)setMap);
        Map<String, String> strMap = CacheClient.getSingleStrMap("cust:strMap");
        Set<String> keySet = strMap.keySet();
        for (String str : keySet) {
            System.out.println(str + " = " + strMap.get(str));
        }
    }

    public void testSetSingleListMap() throws CmisDaoException {
        HashMap<String, String> map = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("name", "\u5f20\u4e09");
            }
        };
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        list.add(map);
        CacheClient.setSingleListMap("cust:listMap", list);
        List<Map<String, String>> list2 = CacheClient.getSingleListMap("cust:listMap");
        System.out.println(list2);
    }

    public void testSetSingleSerObject() throws CmisDaoException {
        SUser sUser = new SUser();
        sUser.setActorname("\u5f20\u4e09");
        sUser.setActorno("hello");
        CacheClient.setSingleSerObject("cust:serObject", sUser);
        SUser singleSerObject = (SUser)((Object)CacheClient.getSingleSerObject("cust:serObject"));
        System.out.println(singleSerObject.getDataMap());
    }

    public void testSetMultiValueByFlatMap() throws CmisDaoException {
        HashMap<String, Object> map0 = new HashMap<String, Object>();
        HashMap<String, Object> map1_0 = new HashMap<String, Object>();
        HashMap<String, String> map2_0 = new HashMap<String, String>();
        map2_0.put("key", "hello");
        map1_0.put("key1", "key1");
        map1_0.put("map2_0", map2_0);
        map0.put("key0", "value0");
        map0.put("map1_0", map1_0);
        CacheClient.setMultiValueByFlatMap(map0, "FLAT", ":");
        String singleValue = CacheClient.getSingleValue("FLAT:map1_0:map2_0:key");
        System.out.println(singleValue);
        CacheDBRedisTest.assertEquals((String)singleValue, (String)"hello");
    }

    public void testSetSingleObjectByJson() throws CmisDaoException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", "value");
        CacheClient.setSingleObjectByJson("cust:ObjectByJson", map);
        Map map1 = CacheClient.getSingleObjectByJson("cust:ObjectByJson", HashMap.class);
        System.out.println(map1);
    }

    public void testDeleteByKey() throws CmisDaoException {
        CacheClient.deleteByKey("dictColl\\.*");
    }

    public void testGetDictByType() throws Exception {
        IndexedCollection iColl = CacheClient.getDictByType(null, "S_USR_LANG_TYPE");
        System.out.println(iColl);
    }

    public void testGetAllDicts() throws Exception {
        KeyedCollection allDicts = CacheClient.getAllDicts(null);
        System.out.println(allDicts);
    }

    public void testGet() throws CmisDaoException {
        String value = CacheClient.getSingleValue("aaa");
        System.out.println(value);
    }

    public void testDel() throws CmisDaoException {
        CacheClient.deleteByKey("A1:user.queue.type3:3:*");
    }

    protected void setUp() throws Exception {
        System.out.println("====" + this.getName() + "====");
        super.setUp();
    }
}

