/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.config;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.dao.config.SqlConfig;
import com.yucheng.cmis.dao.config.SqlConfigBuffer;
import com.yucheng.cmis.util.CommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConfigLoader {
    public static final String TAG_RECORD_START = "SQL";
    public static final String TAG_SELECT = "SELECT";
    public static final String TAG_UPDATE = "UPDATE";
    public static final String TAG_DELETE = "DELETE";
    public static final String TAG_INSERT = "INSERT";
    public static final String TAG_DDL = "DDL";
    public static final String TAG_OPTCONDITION = "OPT_CONDITION";
    public static final String TAG_CONDITION_GROUP = "CONDI_GROUP";
    public static final String KEY_DEFUALT_CONDITION = "defaultCondition";
    private static final String ENCODING = "UTF-8";
    private static final String[] dbTypes = new String[]{"Oracle", "MySQL", "SqlServer", "Db2"};
    private static List<String> currentDBSqlList = new ArrayList<String>();

    public void addConfig(Document doc) {
        if (doc == null) {
            return;
        }
        NodeList sqlNode = doc.getElementsByTagName(TAG_RECORD_START);
        int i = 0;
        while (i < sqlNode.getLength()) {
            block16: {
                Document subdoc;
                boolean canUpdateAll;
                String updTableName;
                String sqlType;
                String sql;
                String onlyReturnFirst;
                String resultClass;
                String valueClass;
                String parameterClass;
                String id;
                block15: {
                    NodeList ddlNode;
                    NodeList addNode;
                    NodeList deleteNode;
                    NodeList updateNode;
                    id = sqlNode.item(i).getAttributes().getNamedItem("id").getNodeValue();
                    Node pClassNode = sqlNode.item(i).getAttributes().getNamedItem("parameterClass");
                    parameterClass = pClassNode != null ? pClassNode.getNodeValue() : "";
                    Node vClassNode = sqlNode.item(i).getAttributes().getNamedItem("valueClass");
                    valueClass = vClassNode != null ? vClassNode.getNodeValue() : "";
                    Node rClassNode = sqlNode.item(i).getAttributes().getNamedItem("resultClass");
                    resultClass = rClassNode != null ? rClassNode.getNodeValue() : "";
                    Node rFirstNode = sqlNode.item(i).getAttributes().getNamedItem("onlyReturnFirst");
                    onlyReturnFirst = rFirstNode != null ? rFirstNode.getNodeValue() : "";
                    sql = "";
                    sqlType = "";
                    updTableName = "";
                    canUpdateAll = false;
                    subdoc = sqlNode.item(i).getOwnerDocument();
                    NodeList selectNode = subdoc.getElementsByTagName(TAG_SELECT);
                    if (selectNode != null && selectNode.getLength() > 0) {
                        sql = selectNode.item(0).getTextContent();
                        sqlType = TAG_SELECT;
                    }
                    if ((updateNode = subdoc.getElementsByTagName(TAG_UPDATE)) != null && updateNode.getLength() > 0) {
                        sql = updateNode.item(0).getTextContent();
                        Node tableNmNode = updateNode.item(0).getAttributes().getNamedItem("updTableName");
                        updTableName = tableNmNode != null ? tableNmNode.getNodeValue() : "";
                        Node updateAllNode = updateNode.item(0).getAttributes().getNamedItem("canUpdateAll");
                        canUpdateAll = updateAllNode != null ? Boolean.parseBoolean(updateAllNode.getNodeValue()) : false;
                        sqlType = TAG_UPDATE;
                    }
                    if ((deleteNode = subdoc.getElementsByTagName(TAG_DELETE)) != null && deleteNode.getLength() > 0) {
                        sql = deleteNode.item(0).getTextContent();
                        sqlType = TAG_DELETE;
                    }
                    if ((addNode = subdoc.getElementsByTagName(TAG_INSERT)) != null && addNode.getLength() > 0) {
                        sql = addNode.item(0).getTextContent();
                        Node tableNmNode = addNode.item(0).getAttributes().getNamedItem("updTableName");
                        updTableName = tableNmNode != null ? tableNmNode.getNodeValue() : "";
                        sqlType = TAG_INSERT;
                    }
                    if ((ddlNode = subdoc.getElementsByTagName(TAG_DDL)) != null && ddlNode.getLength() > 0) {
                        sql = ddlNode.item(0).getTextContent();
                        sqlType = TAG_DDL;
                    }
                    if (sql != null && !sql.trim().equals("")) break block15;
                    if (updTableName == null || updTableName.trim().equals("")) break block16;
                    sql = "";
                }
                ArrayList<HashMap> groupCondi = new ArrayList<HashMap>();
                NodeList groupCondiNodeList = subdoc.getElementsByTagName(TAG_CONDITION_GROUP);
                if (groupCondiNodeList != null && groupCondiNodeList.getLength() > 0) {
                    int n = 0;
                    while (n < groupCondiNodeList.getLength()) {
                        Node groupNode = groupCondiNodeList.item(n);
                        String defaultCondi = groupNode.getAttributes().getNamedItem(KEY_DEFUALT_CONDITION).getNodeValue();
                        NodeList optCondi = groupNode.getChildNodes();
                        HashMap<String, String> optCondition = null;
                        optCondition = new HashMap<String, String>();
                        if (defaultCondi == null || defaultCondi.trim().equals("")) {
                            defaultCondi = "";
                        }
                        optCondition.put(KEY_DEFUALT_CONDITION, defaultCondi);
                        SqlConfigLoader.loadOptConditionNode(optCondi, optCondition);
                        groupCondi.add(optCondition);
                        ++n;
                    }
                } else {
                    NodeList optCondiNode = subdoc.getElementsByTagName(TAG_OPTCONDITION);
                    HashMap<String, String> optCondition = null;
                    if (optCondiNode != null && optCondiNode.getLength() > 0) {
                        optCondition = new HashMap<String, String>();
                        SqlConfigLoader.loadOptConditionNode(optCondiNode, optCondition);
                        groupCondi.add(optCondition);
                    }
                }
                SqlConfig sqlCfg = new SqlConfig();
                sqlCfg.setSqlid(id);
                sqlCfg.setParameterClass(parameterClass);
                sqlCfg.setValueClass(valueClass);
                sqlCfg.setResultClass(resultClass);
                sqlCfg.setOnlyReturnFirst(Boolean.parseBoolean(onlyReturnFirst));
                sqlCfg.setGroupCondition(groupCondi);
                sqlCfg.setSql(sql.trim());
                sqlCfg.setSqlType(sqlType);
                sqlCfg.setUpdTableName(updTableName);
                sqlCfg.setCanUpdateAll(canUpdateAll);
                SqlConfigBuffer.setSqlConfig(id, sqlCfg);
            }
            ++i;
        }
    }

    public static void loadOptConditionNode(NodeList optCondiNode, HashMap<String, String> optCondition) {
        int k = 0;
        while (k < optCondiNode.getLength()) {
            String tagNm = optCondiNode.item(k).getNodeName();
            if (!tagNm.startsWith("#")) {
                String condiId = optCondiNode.item(k).getAttributes().getNamedItem("id").getNodeValue();
                String condiRel = optCondiNode.item(k).getAttributes().getNamedItem("relationType").getNodeValue();
                String condi = optCondiNode.item(k).getTextContent();
                condiRel = condiRel != null ? condiRel.trim().toUpperCase() : "AND";
                if (condi != null) {
                    optCondition.put(condiId, String.valueOf(condiRel) + "  " + condi.trim());
                }
            }
            ++k;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean doDigestSQLFile(String filename) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [47[DOLOOP]], but top level block is 65[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadSqlConfig() {
        try {
            String path = String.valueOf(CommonUtil.getClassesPath()) + "/sql/";
            this.loadSqlConfig(path);
            this.loadCurrentDbSqlConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSqlConfigAll(String path) {
        try {
            this.loadSqlConfig(path);
            this.loadCurrentDbSqlConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadCurrentDbSqlConfig() throws Exception {
        for (String file : currentDBSqlList) {
            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u914d\u7f6e\u6587\u4ef6\uff1a" + file));
            this.doDigestSQLFile(file);
        }
    }

    public void loadSqlConfig(String path) throws Exception {
        try {
            String databaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
            File f = new File(path);
            File[] fList = f.listFiles();
            boolean canLoad = true;
            int n = 0;
            while (n < fList.length) {
                String fileName = fList[n].getName();
                if (fList[n].isDirectory()) {
                    this.loadSqlConfig(fList[n].getPath());
                }
                if (fileName.endsWith(".sql.xml")) {
                    if (fileName.toUpperCase().endsWith("_" + databaseType.toUpperCase() + ".SQL.XML")) {
                        currentDBSqlList.add(fList[n].getAbsolutePath());
                    } else {
                        int i = 0;
                        while (i < dbTypes.length) {
                            if (!dbTypes[i].equals(databaseType) && fileName.toUpperCase().endsWith("_" + dbTypes[i].toUpperCase() + ".SQL.XML")) {
                                canLoad = false;
                                break;
                            }
                            ++i;
                        }
                        if (canLoad) {
                            EMPLog.log((String)TAG_RECORD_START, (int)EMPLog.DEBUG, (int)0, (String)("\u52a0\u8f7dSQL\u914d\u7f6e\u6587\u4ef6\uff1a" + fList[n].getAbsolutePath()));
                            this.doDigestSQLFile(fList[n].getAbsolutePath());
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void main(String[] args) {
        SqlConfigLoader load = new SqlConfigLoader();
        load.loadSqlConfigAll("D:/eclipse_workspaces/CMIS5/cmis/src/main/config/sql/");
        SqlConfig con = SqlConfigBuffer.getSqlConfigById("loadMessage");
        System.out.println(con.getSql());
    }
}

