/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.config;

import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.dao.config.SqlConfig;
import com.yucheng.cmis.dao.config.SqlConfigBuffer;
import com.yucheng.cmis.dao.config.SqlParser;
import com.yucheng.cmis.pub.CMISDomain;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SqlConfigContext {
    private static String SINGLE_CONDITION_KEY = "_SIG_VALUE";

    public static String getSqlFromConfig(String sqlConfigId, Object paramValue, String[] pubConditionId, Object value) throws SQLException {
        String resultSql = "";
        SqlConfig sqlConfig = SqlConfigBuffer.getSqlConfigById(sqlConfigId);
        if (sqlConfig == null) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        HashMap params = new HashMap();
        SqlConfigContext.objectToMap(paramValue, params);
        String sTyp = sqlConfig.getSqlType();
        if (sTyp != null && (sTyp.trim().equals("DELETE") || sTyp.trim().equals("UPDATE")) && !SqlConfigContext.checkParamExist(params)) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u4e3a" + sTyp + "\u64cd\u4f5c\uff0c\u5fc5\u987b\u8981\u6709\u67e5\u8be2\u6761\u4ef6");
        }
        SqlConfigContext.objectToMap(value, params);
        resultSql = SqlConfigContext._getSqlFromConfig(sqlConfigId, params, null, pubConditionId);
        SqlConfigContext.checkSql(resultSql, sTyp);
        return resultSql;
    }

    public static boolean checkSql(String sql, String sqlTyp) throws SQLException {
        boolean result = true;
        if (sql == null || sql.trim().equals("")) {
            throw new SQLException("SQL\u4e3a\u7a7a");
        }
        if (sqlTyp != null && (sqlTyp.trim().equals("DELETE") || sqlTyp.trim().equals("UPDATE"))) {
            int idx = sql.toLowerCase().indexOf("where");
            if (idx > 0) {
                idx = sql.indexOf("?", idx);
            }
            if (idx <= 0) {
                EMPLog.log((String)"SQL", (int)EMPLog.ERROR, (int)0, (String)("SQL\uff08" + sql + "\uff09\u5fc5\u987b\u8981\u6709\u67e5\u8be2\u6761\u4ef6"));
                throw new SQLException("SQL\uff08" + sql + "\uff09\u5fc5\u987b\u8981\u6709\u67e5\u8be2\u6761\u4ef6");
            }
            result = true;
        }
        return result;
    }

    public static String getSqlFromConfig(String sqlConfigId, Object paramValue, String[] conditionId, String[] pubConditionId) throws SQLException {
        String resultSql = "";
        HashMap params = new HashMap();
        SqlConfigContext.objectToMap(paramValue, params);
        resultSql = SqlConfigContext._getSqlFromConfig(sqlConfigId, params, conditionId, pubConditionId);
        return resultSql;
    }

    private static String _getSqlFromConfig(String sqlConfigId, Map paramValues, String[] conditionId, String[] pubConditionId) throws SQLException {
        SqlConfig sqlConfig = SqlConfigBuffer.getSqlConfigById(sqlConfigId);
        if (sqlConfig == null) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        return SqlParser.getSql(sqlConfig, paramValues, conditionId, pubConditionId);
    }

    public static String getResultClass(String sqlConfigId) throws SQLException {
        SqlConfig sqlConfig = SqlConfigBuffer.getSqlConfigById(sqlConfigId);
        if (sqlConfig == null) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        return sqlConfig.getResultClass();
    }

    public static boolean getOnlyReturnFirst(String sqlConfigId) throws SQLException {
        SqlConfig sqlConfig = SqlConfigBuffer.getSqlConfigById(sqlConfigId);
        if (sqlConfig == null) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        return sqlConfig.isOnlyReturnFirst();
    }

    public static List getParamList(String sqlConfigId, Object paramValue, String[] conditionId, String[] pubConditionId) throws SQLException {
        SqlConfig sqlConfig = SqlConfigBuffer.getSqlConfigById(sqlConfigId);
        if (sqlConfig == null) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        ArrayList result = new ArrayList();
        HashMap params = new HashMap();
        SqlConfigContext.objectToMap(paramValue, params);
        return SqlParser.getParamList(sqlConfig, params, conditionId, pubConditionId);
    }

    public static List getParamList(String sqlConfigId, Object paramValue, Object value) throws SQLException {
        SqlConfig sqlConfig = SqlConfigBuffer.getSqlConfigById(sqlConfigId);
        if (sqlConfig == null) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c");
        }
        ArrayList result = new ArrayList();
        HashMap params = new HashMap();
        SqlConfigContext.objectToMap(paramValue, params);
        String sTyp = sqlConfig.getSqlType();
        if (sTyp != null && (sTyp.trim().equals("DELETE") || sTyp.trim().equals("UPDATE")) && !SqlConfigContext.checkParamExist(params)) {
            throw new SQLException("[" + sqlConfigId + "]\u5bf9\u5e94\u7684SQL\u4e3a" + sTyp + "\u64cd\u4f5c\uff0c\u5fc5\u987b\u8981\u6709\u67e5\u8be2\u6761\u4ef6");
        }
        SqlConfigContext.objectToMap(value, params);
        return SqlParser.getParamList(sqlConfig, params, null, null);
    }

    public static boolean checkParamExist(Map params) {
        boolean result = false;
        if (params != null && params.keySet().size() > 0) {
            result = false;
            for (Object key : params.keySet()) {
                if (params.get(key) == null) continue;
                result = true;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static void objectToMap(Object value, Map params) {
        if (params == null) {
            return;
        }
        if (value != null) {
            if ("java.util.Map".equalsIgnoreCase(value.getClass().getName()) || "java.util.HashMap".equalsIgnoreCase(value.getClass().getName())) {
                params.putAll((Map)value);
            } else if (value instanceof KeyedCollection) {
                KeyedCollection kCol = (KeyedCollection)value;
                for (String key : kCol.keySet()) {
                    params.put(key, kCol.get((Object)key));
                }
            } else if (value instanceof CMISDomain) {
                params.putAll(((CMISDomain)value).getDataMap());
            } else if (SqlConfigContext.isBasicDataType(value.getClass().getName())) {
                params.put(SINGLE_CONDITION_KEY, value.toString());
            }
        }
    }

    private static boolean isBasicDataType(String Classname) {
        return Classname.equals("java.lang.Double") || Classname.equals("java.lang.Integer") || Classname.equals("java.lang.Float") || Classname.equals("java.lang.String") || Classname.equals("java.math.BigDecimal");
    }
}

