/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.dao.builder;

import com.ecc.emp.log.EMPLog;
import com.yucheng.cmis.cache.util.CMISDaoPropertyManager;
import com.yucheng.cmis.dao.builder.CommonSqlBuilder;
import com.yucheng.cmis.dao.builder.Db2Builder;
import com.yucheng.cmis.dao.builder.MySqlBuilder;
import com.yucheng.cmis.dao.builder.OracleBuilder;
import com.yucheng.cmis.dao.builder.SqlBuilder;
import com.yucheng.cmis.dao.builder.SqlServerBuilder;
import com.yucheng.cmis.exception.CmisDaoException;

public class SqlBuilderFactory {
    public static SqlBuilder getBuilder() {
        CommonSqlBuilder builder = null;
        try {
            String databaseType = CMISDaoPropertyManager.getInstance().getPropertyValue("DatabaseType");
            builder = "Oracle".equals(databaseType) ? new OracleBuilder() : ("MySQL".equals(databaseType) ? new MySqlBuilder() : ("SqlServer".equals(databaseType) ? new SqlServerBuilder() : ("Db2".equals(databaseType) ? new Db2Builder() : new OracleBuilder())));
        }
        catch (CmisDaoException e) {
            EMPLog.log((String)"SQL", (int)EMPLog.ERROR, (int)0, (String)"\u8bfb\u53d6cmis-dao.property\u6587\u4ef6\u7684DatabaseType\u51fa\u9519", (Throwable)((Object)e));
        }
        return builder;
    }
}

