/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.qrcode;

import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.xiongyingqi.qrcode.Profile;
import com.xiongyingqi.qrcode.QRCode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class QRCodeGenerator {
    private Profile profile;

    public static void main(String[] args) throws IOException {
        System.out.println(System.getProperty("java.io.tmpdir"));
    }

    private QRCodeGenerator() {
    }

    public static QRCodeGenerator newGenerator() {
        QRCodeGenerator qrCodeGenerator = new QRCodeGenerator();
        qrCodeGenerator.profile = new Profile();
        qrCodeGenerator.characterSet("UTF-8").errorCorrectionLevel(ErrorCorrectionLevel.H).logoFlag(false).format("png").margin(0).width(300).height(300).path(System.getProperty("java.io.tmpdir"));
        return qrCodeGenerator;
    }

    public QRCodeGenerator content(String content) {
        this.profile.setContent(content);
        return this;
    }

    public QRCodeGenerator width(int width) {
        this.profile.setWidth(width);
        return this;
    }

    public QRCodeGenerator height(int height) {
        this.profile.setHeight(height);
        return this;
    }

    public QRCodeGenerator path(String path) {
        this.profile.setPath(path);
        return this;
    }

    public QRCodeGenerator logoPath(String logoPath) {
        this.profile.setLogoPath(logoPath);
        return this;
    }

    public QRCodeGenerator format(String format) {
        this.profile.setFormat(format);
        return this;
    }

    public QRCodeGenerator errorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) {
        this.profile.setErrorCorrectionLevel(errorCorrectionLevel);
        return this;
    }

    public QRCodeGenerator characterSet(String characterSet) {
        this.profile.setCharacterSet(characterSet);
        return this;
    }

    public QRCodeGenerator margin(int margin) {
        this.profile.setWidth(margin);
        return this;
    }

    public QRCodeGenerator logoFlag(boolean logoFlag) {
        this.profile.setLogoFlag(logoFlag);
        return this;
    }

    public File generate() {
        QRCode qrCode = new QRCode();
        File file = qrCode.encode(this.profile);
        return file;
    }

    public OutputStream generateOutputStream() throws IOException, WriterException {
        QRCode qrCode = new QRCode();
        OutputStream outputStream = qrCode.encodeToOutputStream(this.profile);
        return outputStream;
    }
}

