/*
 * Decompiled with CFR 0.152.
 */
package com.xiongyingqi.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.xiongyingqi.qrcode.Profile;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.UUID;
import javax.imageio.ImageIO;

public class QRCode {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public File encode(Profile profile) {
        try {
            File isFile = new File(profile.getPath());
            if (!isFile.exists()) {
                isFile.mkdirs();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String fileName = UUID.randomUUID() + "." + profile.getFormat();
            File file = new File(profile.getPath(), fileName);
            BufferedImage bufferedImage = this.encodeToBufferedImage(profile);
            ImageIO.write((RenderedImage)bufferedImage, profile.getFormat(), file);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream encodeToOutputStream(Profile profile) throws IOException, WriterException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = this.encodeToBufferedImage(profile);
        ImageIO.write((RenderedImage)bufferedImage, profile.getFormat(), outputStream);
        return outputStream;
    }

    private BufferedImage encodeToBufferedImage(Profile profile) throws WriterException, IOException {
        BitMatrix bitMatrix = this.encodeToBitMatrix(profile);
        BufferedImage bufferedImage = this.getBufferedImage(bitMatrix, profile.isLogoFlag(), profile.getLogoPath());
        return bufferedImage;
    }

    private BitMatrix encodeToBitMatrix(Profile profile) throws WriterException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, profile.getErrorCorrectionLevel());
        hints.put(EncodeHintType.CHARACTER_SET, profile.getCharacterSet());
        hints.put(EncodeHintType.MARGIN, profile.getMargin());
        BitMatrix bitMatrix = new MultiFormatWriter().encode(profile.getContent(), BarcodeFormat.QR_CODE, profile.getWidth(), profile.getHeight(), hints);
        return bitMatrix;
    }

    public BufferedImage getBufferedImage(BitMatrix bitMatrix, boolean isLogo, String logoPath) throws IOException {
        BufferedImage bi = this.toBufferedImageContents(bitMatrix);
        if (isLogo && logoPath != null && !logoPath.isEmpty() && new File(logoPath).exists()) {
            int width_4 = bitMatrix.getWidth() / 4;
            int width_8 = width_4 / 2;
            int height_4 = bitMatrix.getHeight() / 4;
            int height_8 = height_4 / 2;
            BufferedImage bi2 = bi.getSubimage(width_4 + width_8, height_4 + height_8, width_4, height_4);
            Graphics2D g2 = bi2.createGraphics();
            BufferedImage img = ImageIO.read(new File(logoPath));
            int currentImgWidth = ((Image)img).getWidth(null);
            int currentImgHeight = ((Image)img).getHeight(null);
            int resultImgWidth = 0;
            int resultImgHeight = 0;
            if (currentImgWidth != width_4) {
                resultImgWidth = width_4;
            }
            if (currentImgHeight != width_4) {
                resultImgHeight = width_4;
            }
            g2.drawImage(img, 0, 0, resultImgWidth, resultImgHeight, null);
            g2.dispose();
            bi.flush();
        }
        return bi;
    }

    public BufferedImage toBufferedImageContents(BitMatrix bitMatrix) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public String decode(InputStream inputStream) throws IOException, NotFoundException {
        return this.decode(ImageIO.read(inputStream));
    }

    public String decode(BufferedImage image) throws NotFoundException {
        if (image == null) {
            System.out.println("Could not decode image");
        }
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        Result result = new MultiFormatReader().decode(bitmap, hints);
        String resultStr = result.getText();
        return resultStr;
    }

    public String decode(String path) throws IOException, NotFoundException {
        File file;
        BufferedImage image;
        if (path == null || path.equals("")) {
            System.out.println("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ((image = ImageIO.read(file = new File(path))) != null) {
            return this.decode(image);
        }
        return null;
    }
}

