/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.sdk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ProxyConfig {
    public static final String MATCH_ALL_SCHEMES = "*";
    private List<ProxyRule> a;
    private List<String> b;

    public ProxyConfig(List<ProxyRule> list, List<String> list2) {
        this.a = list;
        this.b = list2;
    }

    public List<ProxyRule> getProxyRules() {
        return Collections.unmodifiableList(this.a);
    }

    public List<String> getBypassRules() {
        return Collections.unmodifiableList(this.b);
    }

    public static final class Builder {
        private List<ProxyRule> a;
        private List<String> b;

        public Builder() {
            this.a = new ArrayList<ProxyRule>();
            this.b = new ArrayList<String>();
        }

        public Builder(ProxyConfig proxyConfig) {
            this.a = proxyConfig.getProxyRules();
            this.b = proxyConfig.getBypassRules();
        }

        public ProxyConfig build() {
            return new ProxyConfig(this.a(), this.b());
        }

        public Builder addProxyRule(String string) {
            this.a.add(new ProxyRule(string));
            return this;
        }

        public Builder addProxyRule(String string, String string2) {
            this.a.add(new ProxyRule(string2, string));
            return this;
        }

        public Builder addBypassRule(String string) {
            this.b.add(string);
            return this;
        }

        public Builder addDirect(String string) {
            this.a.add(new ProxyRule(string, "direct://"));
            return this;
        }

        public Builder addDirect() {
            return this.addDirect(ProxyConfig.MATCH_ALL_SCHEMES);
        }

        public Builder bypassSimpleHostnames() {
            return this.addBypassRule("<local>");
        }

        public Builder removeImplicitRules() {
            return this.addBypassRule("<-loopback>");
        }

        private List<ProxyRule> a() {
            return this.a;
        }

        private List<String> b() {
            return this.b;
        }
    }

    public static final class ProxyRule {
        private String a;
        private String b;

        public ProxyRule(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        public ProxyRule(String string) {
            this(ProxyConfig.MATCH_ALL_SCHEMES, string);
        }

        public String getSchemeFilter() {
            return this.a;
        }

        public String getUrl() {
            return this.b;
        }
    }
}

