/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.sdk.stat;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.utils.FileProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MttLoader {
    public static final String QQBROWSER_DOWNLOAD_URL = "https://mdc.html5.qq.com/mh?channel_id=50079&u=";
    public static final int RESULT_OK = 0;
    public static final int RESULT_UNKNOWN = 1;
    public static final int RESULT_INVALID_URL = 2;
    public static final int RESULT_INVALID_CONTEXT = 3;
    public static final int RESULT_NOT_INSTALL_QQBROWSER = 4;
    public static final int RESULT_QQBROWSER_LOW = 5;
    public static final String MTT_ACTION = "com.tencent.QQBrowser.action.VIEW";
    public static final String MTT_ACTION_SP = "com.tencent.QQBrowser.action.VIEWSP";
    public static final String PID_MOBILE_QQ = "50079";
    public static final String PID_QQPIM = "50190";
    public static final String PID_ARTICLE_NEWS = "21272";
    public static final String PID_WECHAT = "10318";
    public static final String PID_QZONE = "10494";
    public static final String QQBROWSER_SCHEME = "mttbrowser://url=";
    public static final String QQBROWSER_PARAMS_PD = ",product=";
    public static final String QQBROWSER_PARAMS_VERSION = ",version=";
    public static final String QQBROWSER_PARAMS_PACKAGENAME = ",packagename=";
    public static final String QQBROWSER_PARAMS_FROME = ",from=";
    public static final String QQBROWSER_DIRECT_DOWNLOAD_URL = "https://mdc.html5.qq.com/d/directdown.jsp?channel_id=50079";
    @Deprecated
    public static final String KEY_APP_NAME = "KEY_APPNAME";
    @Deprecated
    public static final String KEY_PACKAGE = "KEY_PKG";
    @Deprecated
    public static final String KEY_ACTIVITY_NAME = "KEY_ACT";
    public static final String KEY_PID = "KEY_PID";
    public static final String KEY_EUSESTAT = "KEY_EUSESTAT";
    public static final String CHANNEL_ID = "ChannelID";
    public static final String POS_ID = "PosID";
    public static final String STAT_KEY = "StatKey";
    public static final String ENTRY_ID = "entryId";

    public static String getValidQBUrl(Context context, String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("qb://")) {
            boolean bl = false;
            BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
            if (browserInfo.browserType == -1) {
                bl = true;
            } else if (browserInfo.browserType == 2 && browserInfo.ver < 33) {
                bl = true;
            }
            if (bl) {
                return MttLoader.getDownloadUrlWithQb(string);
            }
        }
        return string;
    }

    public static String getDownloadUrlWithQb(String string) {
        try {
            return QQBROWSER_DOWNLOAD_URL + URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return QQBROWSER_DOWNLOAD_URL;
        }
    }

    public static boolean isSupportQBScheme(Context context) {
        BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
        if (browserInfo.browserType == -1) {
            return false;
        }
        return browserInfo.browserType != 2 || browserInfo.ver >= 42;
    }

    public static boolean openDocWithQb(Context context, String string, int n2, String string2, HashMap<String, String> hashMap) {
        return MttLoader.openDocWithQb(context, string, n2, string2, hashMap, null);
    }

    public static boolean openDocWithQb(Context context, String string, int n2, String string2, HashMap<String, String> hashMap, Bundle bundle) {
        return MttLoader.openDocWithQb(context, string, n2, string2, "", hashMap, null);
    }

    public static boolean openDocWithQb(Context context, String string, int n2, String string2, String string3, HashMap<String, String> hashMap, Bundle bundle) {
        try {
            Uri uri;
            Object object;
            Intent intent = new Intent("com.tencent.QQBrowser.action.sdk.document");
            if (hashMap != null && (object = hashMap.keySet()) != null) {
                uri = object.iterator();
                while (uri.hasNext()) {
                    String string4 = (String)uri.next();
                    String string5 = hashMap.get(string4);
                    if (TextUtils.isEmpty((CharSequence)string5)) continue;
                    intent.putExtra(string4, string5);
                }
            }
            object = new File(string);
            intent.putExtra("key_reader_sdk_id", 3);
            intent.putExtra("key_reader_sdk_type", n2);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                intent.putExtra("big_brother_source_key", string3);
            }
            if (n2 == 0) {
                intent.putExtra("key_reader_sdk_path", string);
            } else if (n2 == 1) {
                intent.putExtra("key_reader_sdk_url", string);
            }
            intent.putExtra("key_reader_sdk_format", string2);
            if (context != null && context.getApplicationInfo().targetSdkVersion >= 24 && Build.VERSION.SDK_INT >= 24) {
                intent.addFlags(1);
            }
            intent.addFlags(0x10000000);
            uri = MttLoader.a(context, string);
            if (uri == null) {
                return false;
            }
            intent.setDataAndType(uri, "mtt/" + string2);
            intent.putExtra("loginType", MttLoader.a(context.getApplicationContext()));
            if (bundle != null) {
                intent.putExtra("key_reader_sdk_extrals", bundle);
            }
            context.startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private static Uri a(Context context, String string) {
        return FileProvider.a(context, string);
    }

    public static boolean openVideoWithQb(Context context, String string, HashMap<String, String> hashMap) {
        Set<String> set;
        Uri uri = Uri.parse((String)string);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setDataAndType(uri, "video/*");
        if (hashMap != null && (set = hashMap.keySet()) != null) {
            for (String string2 : set) {
                String string3 = hashMap.get(string2);
                if (TextUtils.isEmpty((CharSequence)string3)) continue;
                intent.putExtra(string2, string3);
            }
        }
        boolean bl = false;
        try {
            intent.putExtra("loginType", MttLoader.a(context));
            intent.setComponent(new ComponentName("com.tencent.mtt", "com.tencent.mtt.browser.video.H5VideoThrdcallActivity"));
            context.startActivity(intent);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!bl) {
            try {
                intent.setComponent(null);
                context.startActivity(intent);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static int loadUrl(Context context, String string, HashMap<String, String> hashMap, String string2, WebView webView) {
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        try {
            string3 = null;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (string3 = packageManager.getPackageInfo("com.tencent.mtt", 0)) != null && ((PackageInfo)string3).versionCode > 601000) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string3 = URLEncoder.encode(string, "UTF-8");
            string = bl ? string3 : string;
        }
        catch (Exception exception) {
            bl = false;
        }
        string3 = bl ? ",encoded=1" : "";
        stringBuilder.append(QQBROWSER_SCHEME).append(string).append(QQBROWSER_PARAMS_PD).append("TBS").append(QQBROWSER_PARAMS_PACKAGENAME).append(context.getPackageName()).append(QQBROWSER_PARAMS_FROME).append(string2).append(QQBROWSER_PARAMS_VERSION).append("4.3.0.253").append(string3);
        return MttLoader.loadUrl(context, stringBuilder.toString(), hashMap, webView);
    }

    public static int loadUrl(Context context, String string, HashMap<String, String> hashMap, WebView webView) {
        Point point;
        Object object;
        if (context == null) {
            return 3;
        }
        if (!MttLoader.a(string)) {
            string = "http://" + string;
        }
        Uri uri = null;
        try {
            uri = Uri.parse((String)string);
            if (uri == null) {
                return 2;
            }
        }
        catch (Exception exception) {
            return 2;
        }
        BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
        if (browserInfo.browserType == -1) {
            return 4;
        }
        if (browserInfo.browserType == 2 && browserInfo.ver < 33) {
            return 5;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        if (browserInfo.browserType == 2) {
            if (browserInfo.ver >= 33 && browserInfo.ver <= 39) {
                intent.setClassName("com.tencent.mtt", "com.tencent.mtt.MainActivity");
            } else if (browserInfo.ver >= 40 && browserInfo.ver <= 45) {
                intent.setClassName("com.tencent.mtt", "com.tencent.mtt.SplashActivity");
            } else if (browserInfo.ver >= 46) {
                intent = new Intent(MTT_ACTION);
                object = MttLoader.a(context, uri);
                if (object != null && !TextUtils.isEmpty((CharSequence)((a)object).a)) {
                    intent.setClassName(((a)object).b, ((a)object).a);
                }
            }
        } else if (browserInfo.browserType == 1) {
            if (browserInfo.ver == 1) {
                intent.setClassName("com.tencent.qbx5", "com.tencent.qbx5.MainActivity");
            } else if (browserInfo.ver == 2) {
                intent.setClassName("com.tencent.qbx5", "com.tencent.qbx5.SplashActivity");
            }
        } else if (browserInfo.browserType == 0) {
            if (browserInfo.ver >= 4 && browserInfo.ver <= 6) {
                intent.setClassName("com.tencent.qbx", "com.tencent.qbx.SplashActivity");
            } else if (browserInfo.ver > 6) {
                intent = new Intent(MTT_ACTION);
                object = MttLoader.a(context, uri);
                if (object != null && !TextUtils.isEmpty((CharSequence)((a)object).a)) {
                    intent.setClassName(((a)object).b, ((a)object).a);
                }
            }
        } else {
            intent = new Intent(MTT_ACTION);
            object = MttLoader.a(context, uri);
            if (object != null && !TextUtils.isEmpty((CharSequence)((a)object).a)) {
                intent.setClassName(((a)object).b, ((a)object).a);
            }
        }
        intent.setData(uri);
        if (hashMap != null && (object = hashMap.keySet()) != null) {
            point = object.iterator();
            while (point.hasNext()) {
                String string2 = (String)point.next();
                String string3 = hashMap.get(string2);
                if (TextUtils.isEmpty((CharSequence)string3)) continue;
                intent.putExtra(string2, string3);
            }
        }
        try {
            intent.putExtra("loginType", MttLoader.a(context));
            intent.addFlags(0x10000000);
            if (webView != null) {
                object = new Point(webView.getScrollX(), webView.getScrollY());
                intent.putExtra("AnchorPoint", (Parcelable)object);
                point = new Point(webView.getContentWidth(), webView.getContentHeight());
                intent.putExtra("ContentSize", (Parcelable)point);
            }
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return 4;
        }
        return 0;
    }

    private static int a(Context context) {
        int n2 = 26;
        String string = context.getApplicationInfo().processName;
        if (string.equals("com.tencent.mobileqq")) {
            n2 = 13;
        } else if (string.equals("com.qzone")) {
            n2 = 14;
        } else if (string.equals("com.tencent.WBlog")) {
            n2 = 15;
        } else if (string.equals("com.tencent.mm")) {
            n2 = 24;
        }
        return n2;
    }

    private static a a(Context context, Uri uri) {
        Intent intent = new Intent(MTT_ACTION);
        intent.setData(uri);
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        if (list.size() <= 0) {
            return null;
        }
        a a2 = new a();
        for (ResolveInfo resolveInfo : list) {
            String string = resolveInfo.activityInfo.packageName;
            if (string.contains("com.tencent.mtt")) {
                a2.a = resolveInfo.activityInfo.name;
                a2.b = resolveInfo.activityInfo.packageName;
                return a2;
            }
            if (!string.contains("com.tencent.qbx")) continue;
            a2.a = resolveInfo.activityInfo.name;
            a2.b = resolveInfo.activityInfo.packageName;
        }
        return a2;
    }

    public static BrowserInfo getBrowserInfo(Context context) {
        SharedPreferences sharedPreferences = context.getApplicationContext().getSharedPreferences("x5_proxy_setting", 0);
        boolean bl = sharedPreferences.getBoolean("qb_install_status", false);
        BrowserInfo browserInfo = new BrowserInfo();
        if (bl) {
            return browserInfo;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = null;
            try {
                packageInfo = packageManager.getPackageInfo("com.tencent.mtt", 0);
                browserInfo.browserType = 2;
                browserInfo.packageName = "com.tencent.mtt";
                browserInfo.quahead = "ADRQB_";
                if (packageInfo != null && packageInfo.versionCode > 420000) {
                    browserInfo.ver = packageInfo.versionCode;
                    browserInfo.quahead = browserInfo.quahead + packageInfo.versionName.replaceAll("\\.", "");
                    browserInfo.vn = packageInfo.versionName.replaceAll("\\.", "");
                    return browserInfo;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            try {
                packageInfo = packageManager.getPackageInfo("com.tencent.qbx", 0);
                browserInfo.browserType = 0;
                browserInfo.packageName = "com.tencent.qbx";
                browserInfo.quahead = "ADRQBX_";
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                try {
                    packageInfo = packageManager.getPackageInfo("com.tencent.qbx5", 0);
                    browserInfo.browserType = 1;
                    browserInfo.packageName = "com.tencent.qbx5";
                    browserInfo.quahead = "ADRQBX5_";
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                    try {
                        packageInfo = packageManager.getPackageInfo("com.tencent.mtt", 0);
                        browserInfo.packageName = "com.tencent.mtt";
                        browserInfo.browserType = 2;
                        browserInfo.quahead = "ADRQB_";
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException3) {
                        try {
                            packageInfo = packageManager.getPackageInfo("com.tencent.mtt.x86", 0);
                            browserInfo.packageName = "com.tencent.mtt.x86";
                            browserInfo.browserType = 2;
                            browserInfo.quahead = "ADRQB_";
                        }
                        catch (Exception exception) {
                            try {
                                a a2 = MttLoader.a(context, Uri.parse((String)QQBROWSER_DOWNLOAD_URL));
                                if (a2 != null && !TextUtils.isEmpty((CharSequence)a2.b)) {
                                    packageInfo = packageManager.getPackageInfo(a2.b, 0);
                                    browserInfo.packageName = a2.b;
                                    browserInfo.browserType = 2;
                                    browserInfo.quahead = "ADRQB_";
                                }
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (packageInfo != null) {
                browserInfo.ver = packageInfo.versionCode;
                browserInfo.quahead = browserInfo.quahead + packageInfo.versionName.replaceAll("\\.", "");
                browserInfo.vn = packageInfo.versionName.replaceAll("\\.", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return browserInfo;
    }

    private static boolean a(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = string.trim();
        int n2 = string2.toLowerCase().indexOf("://");
        int n3 = string2.toLowerCase().indexOf(46);
        if (n2 > 0 && n3 > 0 && n2 > n3) {
            return false;
        }
        return string2.toLowerCase().contains("://");
    }

    public static boolean isBrowserInstalled(Context context) {
        BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
        return browserInfo.browserType != -1;
    }

    public static boolean isBrowserInstalledEx(Context context) {
        BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
        boolean bl = false;
        try {
            long l2 = Long.valueOf(browserInfo.vn);
            if (l2 >= 6001500L) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if (browserInfo.ver >= 601500) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSupportingTbsTips(Context context) {
        BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
        return browserInfo.browserType == 2 && browserInfo.ver >= 580000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verifySignature(File file) {
        JarFile jarFile = null;
        InputStream inputStream = null;
        try {
            jarFile = new JarFile(file);
            JarEntry jarEntry = jarFile.getJarEntry("AndroidManifest.xml");
            if (jarEntry == null) {
                boolean bl = false;
                return bl;
            }
            byte[] byArray = new byte[8192];
            inputStream = jarFile.getInputStream(jarEntry);
            while (inputStream.read(byArray, 0, byArray.length) != -1) {
            }
            inputStream.close();
            Certificate[] certificateArray = jarEntry.getCertificates();
            if (certificateArray.length < 1) {
                boolean bl = false;
                return bl;
            }
            String string = MttLoader.a(certificateArray[0]);
            if (string == null) return false;
            if (!string.equals("3082023f308201a8a00302010202044c46914a300d06092a864886f70d01010505003064310b30090603550406130238363110300e060355040813074265696a696e673110300e060355040713074265696a696e673110300e060355040a130754656e63656e74310c300a060355040b13035753443111300f0603550403130873616d75656c6d6f301e170d3130303732313036313835305a170d3430303731333036313835305a3064310b30090603550406130238363110300e060355040813074265696a696e673110300e060355040713074265696a696e673110300e060355040a130754656e63656e74310c300a060355040b13035753443111300f0603550403130873616d75656c6d6f30819f300d06092a864886f70d010101050003818d0030818902818100c209077044bd0d63ea00ede5b839914cabcc912a87f0f8b390877e0f7a2583f0d5933443c40431c35a4433bc4c965800141961adc44c9625b1d321385221fd097e5bdc2f44a1840d643ab59dc070cf6c4b4b4d98bed5cbb8046e0a7078ae134da107cdf2bfc9b440fe5cb2f7549b44b73202cc6f7c2c55b8cfb0d333a021f01f0203010001300d06092a864886f70d010105050003818100b007db9922774ef4ccfee81ba514a8d57c410257e7a2eba64bfa17c9e690da08106d32f637ac41fbc9f205176c71bde238c872c3ee2f8313502bee44c80288ea4ef377a6f2cdfe4d3653c145c4acfedbfbadea23b559d41980cc3cdd35d79a68240693739aabf5c5ed26148756cf88264226de394c8a24ac35b712b120d4d23a")) return false;
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isGreatBrowserVer(Context context, long l2, long l3) {
        BrowserInfo browserInfo = MttLoader.getBrowserInfo(context);
        boolean bl = false;
        try {
            long l4 = Long.valueOf(browserInfo.vn);
            if (l4 >= l2) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if ((long)browserInfo.ver >= l3) {
            bl = true;
        }
        return bl;
    }

    private static String a(Certificate certificate) throws CertificateEncodingException {
        byte[] byArray = certificate.getEncoded();
        int n2 = byArray.length;
        int n3 = n2 * 2;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2];
            int n4 = by >> 4 & 0xF;
            cArray[i2 * 2] = (char)(n4 >= 10 ? 97 + n4 - 10 : 48 + n4);
            n4 = by & 0xF;
            cArray[i2 * 2 + 1] = (char)(n4 >= 10 ? 97 + n4 - 10 : 48 + n4);
        }
        return new String(cArray);
    }

    private static class a {
        public String a = "";
        public String b = "";

        private a() {
        }
    }

    public static class BrowserInfo {
        public int browserType = -1;
        public int ver = -1;
        public String quahead = "";
        public String vn = "0";
        public String packageName = null;
    }
}

