/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util.filelock;

import com.sunyard.common.Configuration;
import com.sunyard.ecm.server.cache.LazySingleton;
import com.sunyard.ecm.server.dao.SunECMDao;
import com.sunyard.util.DateUtil;
import com.sunyard.util.SpringUtil;
import com.sunyard.util.filelock.Lock;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseLock
implements Lock {
    private static Logger log = LoggerFactory.getLogger(DatabaseLock.class);
    private SunECMDao lockDao = (SunECMDao)SpringUtil.getSpringBean("sunECMDao");
    private String lockName;
    private boolean isLock = false;
    private String serverId;
    private String groupID;
    private String threadType;

    public DatabaseLock(String lockName, Class<?> threadType) {
        this.serverId = LazySingleton.getInstance().load.getNodeInfoBean().getServer_id();
        this.groupID = LazySingleton.getInstance().load.getNodeInfoBean().getGroup_id();
        this.lockName = lockName + this.groupID;
        this.threadType = threadType.getSimpleName();
    }

    @Override
    public boolean obtain() throws IOException {
        log.info("\u83b7\u53d6\u9501\uff1a\u76ee\u6807\u9501LockName:" + this.lockName + ",\u76ee\u6807\u9501\u7684server_id:" + this.serverId + ",\u76ee\u6807\u9501threadType:" + this.threadType);
        String lockTime = DateUtil.get12bitDateStr();
        String lockSql = "insert into group_lock(lock_name,server_id,thread_type,lock_time)values(?,?,?,?)";
        String querySql = "select LOCK_NAME ,SERVER_ID,THREAD_TYPE from group_lock where lock_name=?";
        List record = this.lockDao.searchSql(querySql, new Object[]{this.lockName});
        if (record == null || record.isEmpty()) {
            String result = this.lockDao.insertSql(lockSql, new Object[]{this.lockName, this.serverId, this.threadType, lockTime});
            if ("SUCCESS".equals(result)) {
                log.info("\u83b7\u53d6\u9501\u6210\u529f\uff1a\u76ee\u6807\u9501LockName:" + this.lockName + ",\u76ee\u6807\u9501\u7684server_id:" + this.serverId + ",\u76ee\u6807\u9501threadType:" + this.threadType);
                this.isLock = true;
            } else {
                log.info("\u83b7\u53d6\u9501\u5931\u8d25,\u8be5\u9501\u5df2\u88ab\u5176\u4ed6\u8fdb\u7a0b\u6216\u7ebf\u7a0b\u83b7\u53d6,\u5931\u8d25\u4fe1\u606f\uff1a" + result + ";\u9501\u8bb0\u5f55:\u76ee\u6807\u9501LockName:" + this.lockName + ",\u76ee\u6807\u9501\u7684server_id:" + this.serverId + ",\u76ee\u6807\u9501threadType:" + this.threadType);
                this.isLock = false;
            }
        } else {
            Map map = (Map)record.get(0);
            String serverId = (String)map.get("SERVER_ID");
            String threadType = (String)map.get("THREAD_TYPE");
            String lockName = (String)map.get("LOCK_NAME");
            String _30minbefore = Configuration.get((String)"lockTime", (String)"30");
            String newLockTime = DateUtil.get12bitDateStr();
            String unlockSql = "update group_lock set lock_time = ?, server_id = ? where lock_name = ? and server_id = ? and thread_type = ? and lock_time < ?";
            String result = this.lockDao.updateSql(unlockSql, new Object[]{newLockTime, this.serverId, lockName, serverId, threadType, _30minbefore});
            log.debug("\u8bb0\u5f55\u7684server_id:" + serverId + ",\u8bb0\u5f55\u7684threadType:" + threadType + ",\u6570\u636e\u5e93\u8bb0\u5f55\u4e3a\uff1a" + map);
            if (!result.equals("0")) {
                log.info("\u83b7\u53d6\u9501\u6210\u529f,\u9501\u8bb0\u5f55:\u76ee\u6807\u9501LockName:" + lockName + ",\u76ee\u6807\u9501\u7684server_id:" + this.serverId + ",\u76ee\u6807\u9501threadType:" + this.threadType);
                this.isLock = true;
            } else {
                log.info("\u83b7\u53d6\u9501\u5931\u8d25,\u8be5\u9501\u5df2\u88ab\u5176\u4ed6\u8fdb\u7a0b\u6216\u7ebf\u7a0b\u83b7\u53d6.\u9501\u8bb0\u5f55:" + map);
                this.isLock = false;
            }
        }
        return this.isLock;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void unlock() {
        if (!this.isLock) {
            log.info("\u8be5\u5bf9\u8c61\u6ca1\u6709\u6301\u6709\u9501\uff1alockName:" + this.lockName + ",serverID:" + this.serverId + ",threadType:" + this.threadType);
            return;
        }
        log.info("\u79fb\u9664\u9501\u8bb0\u5f55\uff1alockName:" + this.lockName + ",serverID:" + this.serverId + ",threadType:" + this.threadType);
        String unlockSql = "delete from group_lock where lock_name=? and server_id=? and thread_type=? ";
        String result = this.lockDao.deleteSql(unlockSql, new Object[]{this.lockName, this.serverId, this.threadType});
        if ("SUCCESS".equals(result)) {
            log.info("\u79fb\u9664\u9501\u8bb0\u5f55\u6210\u529f\uff1alockName:" + this.lockName + ",serverID:" + this.serverId + ",threadType:" + this.threadType);
            this.isLock = false;
            return;
        }
        log.error("\u79fb\u9664\u9501\u8bb0\u5f55\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + result + ";\u9501\u8bb0\u5f55\u4e3a:" + this.lockName);
        throw new RuntimeException(result);
    }
}

