/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);

    public static String getNowTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    public static String get8bitDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get8bitDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get4bitDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get4bitDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get6bitDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get6bitDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get12bitDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get12bitDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get10bitDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
        String s_date = sdf.format(date);
        long l_date = Long.parseLong(s_date);
        String ddate = String.valueOf(l_date);
        return ddate;
    }

    public static String get14bitDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String get14bitDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String getMDrqzhsti(String format) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s_date = sdf.format(date);
        return s_date;
    }

    public static String getMinusDate(String time, String minDate, String option) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        try {
            Date date = sdf.parse(time);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if ("ADD".equalsIgnoreCase(option)) {
                calendar.add(12, Integer.parseInt(minDate));
            } else {
                calendar.add(12, -Integer.parseInt(minDate));
            }
            String s_date = sdf.format(calendar.getTime());
            long l_date = Long.parseLong(s_date);
            String ddate = String.valueOf(l_date);
            return ddate;
        }
        catch (ParseException e) {
            log.error("\u7ebf\u7a0b\u51fa\u9519[" + time + "]");
            return "";
        }
    }

    public static String get10bitDateStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
        String s_date = sdf.format(date);
        long l_date = Long.parseLong(s_date);
        String ddate = String.valueOf(l_date);
        return ddate;
    }

    public static long getMinutesDate() {
        Date now = new Date();
        return now.getTime() / 1800000L;
    }

    public static String getTimeBeforeX(int x) {
        Date date = new Date();
        long time = date.getTime() - (long)(x * 60 * 1000);
        Date newDate = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        String minbefore = sdf.format(newDate);
        return minbefore;
    }

    public static String getHms() {
        return DateUtil.getHms(new Date());
    }

    public static String getHms(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        String s_date = sdf.format(date);
        return s_date;
    }

    public static List<String> getBetweenDayList(String start, String end, boolean includeStart) throws ParseException {
        ArrayList<String> r = new ArrayList<String>();
        if (includeStart) {
            r.add(start);
        }
        String next = null;
        try {
            next = DateUtil.getNextDay(start);
        }
        catch (ParseException e) {
            log.error("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u51fa\u9519\uff1a" + start, (Throwable)e);
            throw e;
        }
        while (next.compareTo(end) <= 0) {
            r.add(next);
            try {
                next = DateUtil.getNextDay(next);
            }
            catch (ParseException e) {
                log.error("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u51fa\u9519\uff1a" + next, (Throwable)e);
                throw e;
            }
        }
        return r;
    }

    public static String getNextDay(String day) throws ParseException {
        SimpleDateFormat dft = new SimpleDateFormat("yyyyMMdd");
        Date beginDate = dft.parse(day);
        Calendar date = Calendar.getInstance();
        date.setTime(beginDate);
        date.add(5, 1);
        String dateString = dft.format(date.getTime());
        return dateString;
    }
}

