/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.connQueueControl;

import com.sunyard.client.conn.SocketConn;
import com.sunyard.common.Configuration;
import com.sunyard.ecm.util.net.JSSEClientSocketFactory;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import java.net.Socket;
import javax.net.SocketFactory;
import org.apache.log4j.Logger;

public class SocketConnObject {
    private static final Logger log = Logger.getLogger(SocketConnObject.class);
    private String ip = "";
    private String port = "";
    private SocketConn connObject = null;

    public SocketConnObject(String ip, String port) throws SunECMException {
        this(ip, port, Configuration.getBoolean((String)"ssl.client.enable", (boolean)false));
    }

    public SocketConnObject(String ip, String port, boolean sslEnable) throws SunECMException {
        SocketFactory scf;
        this.ip = ip = CodeUtil.changeIp(ip);
        this.port = port;
        log.debug((Object)(this.ip + "======" + this.port));
        int iport = 0;
        if (sslEnable) {
            iport = Configuration.getInt((String)"ssl.client.port", (int)8025);
            scf = new JSSEClientSocketFactory();
        } else {
            iport = Integer.parseInt(port);
            scf = SocketFactory.getDefault();
        }
        try {
            Socket socket = scf.createSocket(ip, iport);
            this.connObject = new SocketConn(socket);
        }
        catch (Exception e) {
            log.error((Object)("\u8fde\u63a5\u670d\u52a1\u5668" + ip + ":" + port + "\u53d1\u751f\u95ee\u9898"), (Throwable)e);
            throw new SunECMException(705, "IO exception ip=" + ip + ";port = " + port, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConn() {
        try {
            try {
                this.connObject.sendMsg("0009");
            }
            catch (Exception e) {
                log.error((Object)("socket ip=" + this.ip + "; port = " + this.port + " close fail , error info-->" + e.getMessage()));
            }
        }
        finally {
            this.connObject.destroy();
        }
    }

    public String getIp() {
        return this.ip;
    }

    public SocketConn getClientTrans() {
        return this.connObject;
    }
}

