/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.conn;

import com.sunyard.client.conn.TransConn;
import com.sunyard.ws.client.WSAccessClient;
import com.sunyard.ws.comm.Base64Coder;
import com.sunyard.ws.internalapi.SunEcmAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class WSConn
implements TransConn {
    private static final Logger log = Logger.getLogger(WSConn.class);
    private static SunEcmAccess access;
    private static WSAccessClient wsAccessClient;
    private String returnMsg = "";

    private String getReturnMsg() {
        return this.returnMsg;
    }

    private void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public WSConn(String ip, int httpPort, String serverName) {
        String url = "http://" + ip + ":" + httpPort + "/" + serverName + "/webservices/WsInterface";
        log.info((Object)("--WSConn-->WSConn-->\u5efa\u7acbWEBSERVICE\u8fde\u63a5:" + url));
        access = wsAccessClient.getAccessClient(url, 300000L);
    }

    @Override
    public void destroy() {
    }

    @Override
    public String receiveMsg() {
        return this.getReturnMsg();
    }

    @Override
    public boolean sendFileData(String filePath, String contentID, String transType) throws IOException {
        File file;
        log.info((Object)("WEBSERVICE\u53d1\u9001\u6587\u4ef6,\u6587\u4ef6\u8def\u5f84:" + filePath + ",\u5185\u5bb9ID:" + contentID));
        int i = filePath.lastIndexOf(46);
        String format = "";
        if (i > -1 && i < filePath.length()) {
            format = filePath.substring(i + 1, filePath.length());
        }
        if (!(file = new File(filePath)).exists()) {
            log.debug((Object)("\u6587\u4ef6\u4e0d\u5b58\u5728,\u6587\u4ef6\u8def\u5f84:" + filePath));
            return false;
        }
        long fileSize = file.length();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("FILENAME=" + file.getName() + ",FILESIZE=" + Long.toString(fileSize) + ",FILEPATH=" + filePath + ",CONTENTID = " + contentID + ",FORMAT=" + format + ",FILE=");
        try {
            byte[] fileBytes = WSConn.getBytesFromFile(file);
            char[] fileChars = Base64Coder.encode((byte[])fileBytes);
            sbuf.append(fileChars);
            access.receiveFileFromClient(sbuf.toString());
            return true;
        }
        catch (IOException e) {
            log.error((Object)("-->WSConn-->sendFileData-->SunECMException-->" + e.toString()));
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = null;
        try {
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                ((InputStream)is).close();
                throw new IOException("File is to large " + file.getName());
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                ((InputStream)is).close();
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    @Override
    public void sendMsg(String msg) {
        log.info((Object)"WEBSERVICE\u53d1\u9001\u6d88\u606f");
        String returnMsg = access.receiveMsgFromClient(msg);
        this.setReturnMsg(returnMsg);
    }

    static {
        wsAccessClient = new WSAccessClient();
    }
}

