/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.conn;

import com.sunyard.ecm.server.bean.NodeInfo;
import com.sunyard.ecm.server.cache.LazySingleton;
import com.sunyard.initialization.LoadConfigFile;
import com.syd.common.serviceinit.ServiceInterface;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatOfDM
implements ServiceInterface,
Runnable {
    public static Map<String, CopyOnWriteArrayList<NodeInfo>> aliveServers = new ConcurrentHashMap<String, CopyOnWriteArrayList<NodeInfo>>();
    public static Map<String, CopyOnWriteArrayList<NodeInfo>> deadServers = new ConcurrentHashMap<String, CopyOnWriteArrayList<NodeInfo>>();
    private final ScheduledExecutorService scheduledPool = Executors.newScheduledThreadPool(2);
    private static final Logger log = LoggerFactory.getLogger(HeartBeatOfDM.class);

    public String getServiceName() {
        return "HeartBeatOfDM";
    }

    public boolean start() {
        Thread socket = new Thread(this);
        socket.start();
        return true;
    }

    private String print(Map<String, CopyOnWriteArrayList<NodeInfo>> maps) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, CopyOnWriteArrayList<NodeInfo>> entry : maps.entrySet()) {
            sb.append("[groupName=" + entry.getKey());
            sb.append(",serverInfo:");
            for (NodeInfo node : entry.getValue()) {
                sb.append(node.getServer_ip() + ":" + node.getSocket_port());
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void run() {
        this.init();
    }

    public void stop() {
        this.scheduledPool.shutdownNow();
    }

    public void init() {
        try {
            log.info("begin to get heart");
            HeartBeatOfDM.initAliveServers();
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    log.info("begin to checkAliveServers");
                    HeartBeatOfDM.checkAliveServers();
                    log.debug("AliveServers:" + HeartBeatOfDM.this.print(aliveServers));
                    log.debug("DeadServers:" + HeartBeatOfDM.this.print(deadServers) + "\n\n");
                }
            }, 4L, LoadConfigFile.getInstance().getConfigBean().getClient_dm_heartbeat_alive(), TimeUnit.SECONDS);
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    log.info("begin to checkDeadServers");
                    HeartBeatOfDM.checkDeadServers();
                    log.info("AliveServers:" + HeartBeatOfDM.this.print(aliveServers));
                    log.info("DeadServers:" + HeartBeatOfDM.this.print(deadServers) + "\n\n");
                }
            }, 5L, LoadConfigFile.getInstance().getConfigBean().getClient_dm_heartbeat_dead(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("heartBeatOfDM init error-", (Throwable)e);
        }
    }

    public static void initAliveServers() {
        HeartBeatOfDM.initAllServers();
    }

    public static void initAllServers() {
        log.info("begin to initAllServers");
        aliveServers.clear();
        deadServers.clear();
        Map map = LazySingleton.getInstance().allNodeInfoTable.getAllNodeInfoTable();
        Set set = map.keySet();
        ArrayList<String> allGroupName = new ArrayList<String>();
        CopyOnWriteArrayList<NodeInfo> nodelist = null;
        for (String serverID : set) {
            NodeInfo node;
            if (serverID.startsWith("UA") || !"0".equals((node = (NodeInfo)map.get(serverID)).getDeploy_mode())) continue;
            String groupName = node.getGroup_name();
            nodelist = aliveServers.get(groupName);
            if (nodelist != null) {
                aliveServers.get(groupName).addIfAbsent(node);
            } else {
                nodelist = new CopyOnWriteArrayList();
                nodelist.add(node);
                aliveServers.put(groupName, nodelist);
            }
            allGroupName.add(groupName);
        }
        for (String gname : allGroupName) {
            deadServers.put(gname, new CopyOnWriteArrayList());
        }
        log.info("end to initAllServers");
    }

    public static void mockAliveServers() {
        for (int groupSize = 0; groupSize < 1; ++groupSize) {
            CopyOnWriteArrayList<NodeInfo> list = new CopyOnWriteArrayList<NodeInfo>();
            for (int i = 0; i < 3; ++i) {
                NodeInfo serverBean = new NodeInfo();
                serverBean.setServer_id(String.valueOf(i));
                serverBean.setServer_ip("ip-" + i);
                serverBean.setSocket_port("802" + i);
                serverBean.setState("1");
                list.add(serverBean);
            }
            aliveServers.put("Group-" + groupSize, list);
            deadServers.put("Group-" + groupSize, new CopyOnWriteArrayList());
        }
    }

    public static List<NodeInfo> getAliveServersByGroup(String group) {
        if (aliveServers != null) {
            return aliveServers.get(group);
        }
        return null;
    }

    public static void checkAliveServers() {
        if (aliveServers == null) {
            log.warn("begin to checkAliveServers,aliveServer is null");
        }
        boolean connected = true;
        for (Map.Entry<String, CopyOnWriteArrayList<NodeInfo>> entry : aliveServers.entrySet()) {
            List serverList = entry.getValue();
            for (NodeInfo node : serverList) {
                connected = HeartBeatOfDM.checkRealConnect(node.getServer_ip(), Integer.parseInt(node.getSocket_port()));
                String startGname = entry.getKey();
                if (!connected) {
                    aliveServers.get(startGname).remove(node);
                    deadServers.get(startGname).addIfAbsent(node);
                    log.error(node.getServer_ip() + "[" + startGname + "] disconnect, remove");
                    continue;
                }
                log.debug(node.getServer_ip() + "[" + startGname + "] can connect");
            }
        }
    }

    public static void checkDeadServers() {
        if (deadServers == null) {
            log.info("begin to checkDeadServers,deadServer.size is null");
            return;
        }
        boolean connected = true;
        for (Map.Entry<String, CopyOnWriteArrayList<NodeInfo>> entry : deadServers.entrySet()) {
            List serverList = entry.getValue();
            for (NodeInfo node : serverList) {
                connected = HeartBeatOfDM.checkRealConnect(node.getServer_ip(), Integer.parseInt(node.getSocket_port()));
                String stopGname = entry.getKey();
                if (connected) {
                    deadServers.get(stopGname).remove(node);
                    aliveServers.get(stopGname).addIfAbsent(node);
                    log.info(node.getServer_ip() + "[" + stopGname + "] connect, add");
                    continue;
                }
                log.error(node.getServer_ip() + "[" + stopGname + "] can not connect");
            }
        }
    }

    public static boolean checkConnected(String ip, int port) {
        return RandomUtils.nextInt((int)5) >= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkRealConnect(String ip, int port) {
        boolean connection = true;
        Socket socket = null;
        try {
            socket = new Socket(ip, port);
        }
        catch (UnknownHostException e) {
            connection = false;
            log.error("\u65e0\u6cd5\u8fde\u63a5[" + ip + ":" + port + "]");
        }
        catch (IOException e1) {
            connection = false;
            log.error("\u65e0\u6cd5\u8fde\u63a5[" + ip + ":" + port + "]");
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    log.error("\u6d4b\u8bd5socket\u8054\u901a\uff0c\u5173\u95edsocket\u51fa\u9519");
                }
            }
        }
        return connection;
    }
}

