/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.util;

import com.sunyard.util.CharSequenceInputStream;
import java.io.InputStream;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);

    public static String addClientIp(String xml, String clientIp) throws DocumentException {
        if (xml.contains("BatchBean") || xml.contains("BatchDownBean")) {
            SAXReader reader = new SAXReader();
            Document d = reader.read((InputStream)new CharSequenceInputStream((CharSequence)xml, "utf-8"));
            d.getRootElement().addAttribute("CLIENT_IP", clientIp);
            return d.getRootElement().asXML();
        }
        log.warn("May be a bad xml :" + xml);
        return xml;
    }

    public static void addClientIp(Map<String, String> map, String clientIp) {
        String xml = map.get("XML");
        if (xml != null) {
            try {
                String newXml = TokenUtil.addClientIp(xml, clientIp);
                map.put("XML", newXml);
            }
            catch (DocumentException e) {
                log.warn("Add clientIp to xml get a exception", (Throwable)e);
            }
        }
    }
}

