/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.ecm.server.bean.converter;

import com.sunyard.ecm.server.bean.AttributeBean;
import com.sunyard.ws.utils.XMLUtil;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;

public class AttributeBeanConverter
implements Converter {
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.map2xml(value, writer, context);
    }

    protected void map2xml(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object subvalue = entry.getValue();
            writer.startNode(key);
            if (this.canConvert(subvalue.getClass())) {
                this.map2xml(subvalue, writer, context);
            } else {
                writer.setValue(XMLUtil.bean2XML(subvalue));
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map map = (Map)this.populateMap(reader, context);
        return map;
    }

    protected Object populateMap(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, AttributeBean> map = new HashMap<String, AttributeBean>();
        String key = "";
        AttributeBean value = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            key = reader.getNodeName();
            value = this.convertAttributeBean(reader, context);
            reader.moveUp();
            map.put(key, value);
        }
        return map;
    }

    protected AttributeBean convertAttributeBean(HierarchicalStreamReader reader, UnmarshallingContext context) {
        AttributeBean attributeBean = new AttributeBean();
        reader.moveDown();
        attributeBean = (AttributeBean)context.convertAnother((Object)attributeBean, AttributeBean.class);
        reader.moveUp();
        return attributeBean;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Map.class) || clazz.equals(HashMap.class) || clazz.equals(LinkedMap.class);
    }
}

