/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.ecm.server.bean;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupSequence {
    public String groupName;
    public GroupSequence superSeq;
    public List<GroupSequence> childSeqs = new ArrayList<GroupSequence>();
    private static final Logger log = LoggerFactory.getLogger(GroupSequence.class);

    public GroupSequence(String groupName, GroupSequence superSeq) {
        this.groupName = groupName;
        this.superSeq = superSeq;
        if (this.superSeq != null) {
            this.superSeq.childSeqs.add(this);
        }
    }

    public static List<GroupSequence> configGroupSequence(String modelCode, List<String> list) {
        ArrayList<GroupSequence> slist = new ArrayList<GroupSequence>();
        if (list == null || list.size() == 0) {
            log.warn("list is null");
            return slist;
        }
        log.info("configGroupSequence");
        for (String str : list) {
            GroupSequence gs = GroupSequence.findByGroup(slist, str.split(",")[0]);
            if (gs != null) continue;
            GroupSequence parentGs = GroupSequence.findByGroup(slist, str.split(",")[1]);
            if (parentGs != null) {
                gs = new GroupSequence(str.split(",")[0], parentGs);
                slist.add(gs);
                continue;
            }
            parentGs = new GroupSequence(str.split(",")[1], null);
            gs = new GroupSequence(str.split(",")[0], parentGs);
            slist.add(gs);
            slist.add(parentGs);
        }
        for (GroupSequence gs : slist) {
            log.info("begin reset,modelCode:" + modelCode + ",gname:" + gs.groupName + " > " + (gs.superSeq != null ? gs.superSeq.groupName : "NULL"));
        }
        return slist;
    }

    private static GroupSequence findByGroup(List<GroupSequence> slist, String s) {
        for (GroupSequence gs : slist) {
            if (!gs.groupName.equals(s)) continue;
            return gs;
        }
        return null;
    }
}

