/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.impl;

import com.sunyard.client.SunEcmClientApi;
import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.client.bean.ClientHeightQuery;
import com.sunyard.client.common.ClientConfiguration;
import com.sunyard.client.conn.SocketConn;
import com.sunyard.client.impl.AbstractSunECMClientApi;
import com.sunyard.client.impl.MD5Util;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.ecm.util.net.DummyTrustManager;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import com.sunyard.util.OptionKey;
import com.sunyard.ws.client.WSConsoleClient;
import com.sunyard.ws.internalapi.SunEcmConsole;
import com.sunyard.ws.utils.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunEcmClientSocketApiImpl
extends AbstractSunECMClientApi
implements SunEcmClientApi {
    private static final Logger log = LoggerFactory.getLogger(SunEcmClientSocketApiImpl.class);
    protected SocketConn conn;
    protected String splitSym = "<<::>>";
    protected String ipAddress;
    protected int socketPort;
    private boolean ssl = false;

    public SunEcmClientSocketApiImpl(String ip, int socketPort) {
        this.ipAddress = ip;
        this.socketPort = socketPort;
    }

    public SunEcmClientSocketApiImpl(String ip, int socketPort, boolean ssl) {
        this.ipAddress = ip;
        this.socketPort = socketPort;
        this.ssl = ssl;
    }

    protected boolean connectToHost(String host, int port) throws SunECMException {
        log.debug("--connectToHost-->\u5efa\u7acbsocket\u8fde\u63a5-->host: " + host + "port: " + port);
        int connectretrytimes = ClientConfiguration.getInt("client.socket.retrytimes", 5);
        for (int i = 0; i < connectretrytimes; ++i) {
            if (this.newHost(host, port)) {
                return true;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                log.debug("--connectToHost-->\u5efa\u7acbsocket\u8fde\u63a5\u5c1d\u8bd5\u8fde\u63a5\u6b21\u6570\uff1a" + (i + 1));
            }
            if (i != connectretrytimes - 1) continue;
            log.warn("\u8fde\u63a5\u4e3b\u673a\uff1a" + host + " \u7aef\u53e3:" + port + "\u5931\u8d25");
            throw new SunECMException(736, "\u8fde\u63a5\u4e3b\u673a\uff1a" + host + " \u7aef\u53e3:" + port + "\u5931\u8d25");
        }
        return false;
    }

    private boolean newHost(String ip, int socketPort) {
        log.debug("--newHost-->\u5efa\u7acb\u8fde\u63a5-->ip: " + ip + " socketPort:" + socketPort);
        Socket socket = null;
        try {
            if (this.ssl) {
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                SSLSocketFactory factory = context.getSocketFactory();
                socket = (SSLSocket)factory.createSocket(ip, socketPort);
            } else {
                socket = new Socket(ip, socketPort);
            }
            socket.setSendBufferSize(ClientConfiguration.getInt("client.socket.sendbuffersize", 8192));
            this.conn = new SocketConn(socket);
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkIn(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        String result;
        block19: {
            log.debug("--checkIn-->\u68c0\u5165");
            this.connectToHost(this.ipAddress, this.socketPort);
            result = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.CHECKIN + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
                sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
                this.conn.sendMsg(sendMsg);
                log.debug("--checkIn-->\u68c0\u5165\u65f6\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + sendMsg);
                String msg = this.conn.receiveMsg();
                if (msg == null) {
                    log.error("\u8fd4\u56de\u4e3a \u7a7a");
                    String string = "";
                    return string;
                }
                log.debug("--checkIn-->\u68c0\u5165\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg);
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym : "FAIL";
                    break block19;
                }
                log.warn("--checkIn-->\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
                throw new SunECMException("--checkIn-->\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        log.debug("--checkIn-->\u68c0\u5165-->result:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkOut(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        String result;
        block19: {
            log.debug("---->checkOut-->\u68c0\u51fa");
            this.connectToHost(this.ipAddress, this.socketPort);
            result = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.CHECKOUT + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
                sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
                this.conn.sendMsg(sendMsg);
                log.debug("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + sendMsg);
                String msg = this.conn.receiveMsg();
                if (msg == null) {
                    log.error("\u8fd4\u56de\u4e3a \u7a7a");
                    String string = "";
                    return string;
                }
                log.debug("--checkOut-->\u68c0\u51fa\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg);
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
                    break block19;
                }
                log.warn("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
                throw new SunECMException("--checkOut-->\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        log.debug("---->checkOut-->\u68c0\u51fa(over)-->result:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createContentID(ClientBatchBean clientBatchBean, String groupname) throws SunECMException, IOException {
        String result;
        block19: {
            log.debug("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7");
            this.connectToHost(this.ipAddress, this.socketPort);
            result = "";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.CREATEID + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",GROUPNAME=" + groupname;
                sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
                this.conn.sendMsg(sendMsg);
                String msg = this.conn.receiveMsg();
                if (msg == null) {
                    log.error("\u8fd4\u56de\u4e3a \u7a7a");
                    String string = "";
                    return string;
                }
                log.debug("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg);
                String[] strArray = msg.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? msg : "0001" + this.splitSym + "FAIL" + strArray[2];
                    break block19;
                }
                log.warn("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
                throw new SunECMException("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        log.debug("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7-->result:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String delete(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug("--delete-->\u5220\u9664");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.DEL + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
            sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
            this.conn.sendMsg(sendMsg);
            log.debug("--delete-->\u5220\u9664\u65f6\u53d1\u9001\u7684\u4fe1\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--delete-->\u5220\u9664\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--delete-->\u5220\u9664(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String login(String userName, String password) throws SunECMException, IOException {
        password = CodeUtil.encode(password);
        log.debug("--login-->\u767b\u5f55 userName:" + userName + "password:" + password);
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultMsg = "FAIL";
        try {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("0002").append(this.splitSym + "OPTION=" + OptionKey.LOGIN + ",USERNAME=").append(userName).append(",PASSWORD=").append(password);
            this.conn.sendMsg(sbuf.toString());
            log.debug("--login-->\u767b\u5f55\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString());
            String msg = this.conn.receiveMsg();
            log.debug("--login-->\u767b\u5f55\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg);
            if (msg == null || "null".equals(msg)) {
                throw new SunECMException("--login-->\u767b\u9646\u5931\u8d25");
            }
            String[] strArray = msg.split(this.splitSym);
            if (strArray[0].equals("0001")) {
                if (strArray[1].equals("SUCCESS")) {
                    resultMsg = "SUCCESS";
                } else {
                    log.warn("--login-->\u767b\u9646\u5931\u8d25");
                }
            }
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--login-->\u767b\u5f55(over)-->resultMsg:" + resultMsg);
        return resultMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String logout(String userName) throws SunECMException, IOException {
        String resultMsg;
        block19: {
            log.debug("--logout-->\u767b\u51fa  userName:" + userName);
            this.connectToHost(this.ipAddress, this.socketPort);
            resultMsg = "FAIL";
            try {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append("0002").append(this.splitSym + "OPTION=" + OptionKey.LOGOUT + ",USERNAME=").append(userName);
                this.conn.sendMsg(sbuf.toString());
                log.debug("--logout-->\u767b\u51fa\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sbuf.toString());
                String msg = this.conn.receiveMsg();
                if (msg == null) {
                    log.error("\u8fd4\u56de\u4e3a \u7a7a");
                    String string = "";
                    return string;
                }
                log.debug("--logout-->\u767b\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg);
                log.debug(msg);
                String[] strArray = msg.split(this.splitSym);
                if (!strArray[0].equals("0001")) break block19;
                if (strArray[1].equals("SUCCESS")) {
                    resultMsg = "SUCCESS";
                    break block19;
                }
                log.warn("--logout-->\u767b\u51fa\u5f02\u5e38");
                throw new SunECMException("--logout-->\u767b\u51fa\u5f02\u5e38");
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        log.debug("--logout-->\u767b\u51fa (over)-->resultMsg:" + resultMsg);
        return resultMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String operAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            this.conn.sendMsg("0002" + this.splitSym + "OPTION=" + OptionKey.A_OR_U_ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName);
            resultStr = this.conn.receiveMsg();
            log.debug("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--operAnnotation-->\u6279\u6ce8\u64cd\u4f5c(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.ANNOTATION + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
            this.conn.sendMsg(sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--queryAnnotation-->\u6279\u6ce8\u67e5\u8be2(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryBatch(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        log.debug("--queryBatch-->\u67e5\u8be2");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        clientBatchBean.setPASSWD(clientBatchBean.getPassWord());
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.QUERY + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
            sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
            this.conn.sendMsg(sendMsg);
            log.debug("--queryBatch-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--queryBatch-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--queryBatch-->\u67e5\u8be2(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String update(ClientBatchBean clientBatchBean, String dmsName, boolean isAutoCheck) throws SunECMException, IOException {
        log.debug("--update-->\u66f4\u65b0");
        String resultStr = "FAIL";
        if (!this.checkFileExist(clientBatchBean)) {
            return "FAIL<<::>>707";
        }
        MD5Util.addBatchMD5Code(clientBatchBean);
        if (isAutoCheck) {
            String OldPassWord = clientBatchBean.getPassWord();
            String checkOutMsg = this.checkOut(clientBatchBean, dmsName);
            log.debug("--update-->\u68c0\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f: " + checkOutMsg);
            if (!checkOutMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                throw new SunECMException("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg);
            }
            clientBatchBean.setCheckToken(checkOutMsg.split(this.splitSym)[1]);
            log.debug("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u6210\u529f");
            try {
                clientBatchBean.setPassWord(OldPassWord);
                resultStr = this.update(clientBatchBean, dmsName);
                log.debug("--update-->\u81ea\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u6d88\u606f\uff1a" + resultStr);
            }
            finally {
                clientBatchBean.setPassWord(OldPassWord);
                String checkInMsg = this.checkIn(clientBatchBean, dmsName);
                if (!checkInMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                    throw new SunECMException("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg);
                }
            }
            log.debug("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u6210\u529f");
        } else {
            resultStr = this.update(clientBatchBean, dmsName);
            log.debug("--update-->\u624b\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u6d88\u606f\uff1a" + resultStr);
        }
        log.debug("--update-->\u66f4\u65b0(over)-->resultStr:" + resultStr);
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String update(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        String resultStr;
        block29: {
            this.connectToHost(this.ipAddress, this.socketPort);
            resultStr = "FAIL";
            CodeUtil.encodeInBean(clientBatchBean);
            try {
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.UPDATE + ",START=START,XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName;
                sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
                this.conn.sendMsg(sendMsg);
                log.debug("--update-->\u66f4\u65b0\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
                String msg = this.conn.receiveMsg();
                if (msg == null) {
                    log.error("\u8fd4\u56de\u4e3a \u7a7a");
                    String string = "";
                    return string;
                }
                log.debug("--update-->\u66f4\u65b0\u524d\u5efa\u7acb\u8fde\u63a5\u65f6\u670d\u52a1\u7aef\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg);
                String[] msgArray = msg.split(this.splitSym);
                if (msgArray[0].equals("0001")) {
                    if (clientBatchBean.isBreakPoint()) {
                        this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID(), clientBatchBean.getModelCode());
                    } else {
                        this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), clientBatchBean.getIndex_Object().getContentID());
                    }
                    String sendMsg_1 = "0002" + this.splitSym + "OPTION=" + OptionKey.UPDATE + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
                    this.conn.sendMsg(sendMsg_1);
                    log.debug("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg_1);
                    msg = this.conn.receiveMsg();
                    if (msg == null) {
                        log.error("\u8fd4\u56de\u4e3a \u7a7a");
                        String string = "";
                        return string;
                    }
                    log.debug("--update-->\u66f4\u65b0\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u540e\u670d\u52a1\u7aef\u8fd4\u56de\uff1a" + msg);
                    String[] strArray = msg.split(this.splitSym);
                    if (strArray[0].equals("0001")) {
                        if (strArray[1].equals("SUCCESS")) {
                            resultStr = "SUCCESS";
                        }
                        break block29;
                    }
                    resultStr = resultStr + "<<::>>" + msg;
                    break block29;
                }
                resultStr = msg;
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        log.debug("--update-->return:" + resultStr);
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String upload(ClientBatchBean clientBatchBean, String dmsName) throws SunECMException, IOException {
        String resultStr;
        long start;
        block30: {
            log.debug("--upload-->\u4e0a\u4f20");
            start = System.currentTimeMillis();
            this.connectToHost(this.ipAddress, this.socketPort);
            if (!this.checkFileExist(clientBatchBean)) {
                return "false";
            }
            CodeUtil.encodeInBean(clientBatchBean);
            MD5Util.addBatchMD5Code(clientBatchBean);
            resultStr = "";
            String contentID = "FAIL";
            try {
                long beginstart = System.currentTimeMillis();
                long beginend = System.currentTimeMillis();
                log.debug("--upload-->socket\u8fde\u63a5\u548c\u6821\u9a8c\u8017\u65f6[" + (beginend - beginstart) + "]\u6beb\u79d2");
                long end1 = System.currentTimeMillis();
                String str = XMLUtil.bean2XML((Object)clientBatchBean);
                long end3 = System.currentTimeMillis();
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.UPLOAD + ",START=START,XML=" + str + ",DMSNAME=" + dmsName;
                sendMsg = this.createBatchSendMsgbyToken(clientBatchBean, sendMsg);
                log.debug("--upload-->\u7ec4\u88c5BEAN\u7684XML\u8017\u65f6[" + (end3 - end1) + "]\u6beb\u79d2" + sendMsg);
                this.conn.sendMsg(sendMsg);
                String msg = this.conn.receiveMsg();
                if (msg == null) {
                    log.error("\u8fd4\u56de\u4e3a\u7a7a");
                    String string = "";
                    return string;
                }
                long end2 = System.currentTimeMillis();
                log.debug("--upload-->\u53d1\u9001\u8017\u65f6[" + (end2 - end3) + "]\u6beb\u79d2");
                log.debug("--upload-->\u4e0a\u4f20\u6587\u4ef6\u524d\u8fd4\u56de:" + msg);
                String[] params = msg.split(this.splitSym);
                if (params[0].equals("0001")) {
                    long _end3 = System.currentTimeMillis();
                    contentID = params[1];
                    resultStr = "FAIL<<::>>" + contentID;
                    clientBatchBean.getIndex_Object().setContentID(contentID);
                    if (clientBatchBean.isBreakPoint()) {
                        this.sendBreakClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID, clientBatchBean.getModelCode());
                    } else {
                        this.sendClientBatchFileBean(clientBatchBean.getDocument_Objects(), contentID);
                    }
                    long _end4 = System.currentTimeMillis();
                    log.debug("--upload-->\u4e0a\u4f20\u6587\u4ef6\u8017\u65f6[" + (_end4 - _end3) + "]\u6beb\u79d2");
                    String sendMsg_1 = "0002" + this.splitSym + "OPTION=" + OptionKey.UPLOAD + ",START=END,CONTENTID=" + clientBatchBean.getIndex_Object().getContentID() + ",DMSNAME=" + dmsName;
                    log.debug("--upload-->\u4e0a\u4f20\u6587\u4ef6\u5b8c\u6210" + sendMsg_1);
                    this.conn.sendMsg(sendMsg_1);
                    msg = this.conn.receiveMsg();
                    if (msg == null) {
                        log.error("\u8fd4\u56de\u4e3a\u7a7a");
                        String string = "";
                        return string;
                    }
                    long _end5 = System.currentTimeMillis();
                    log.debug("--upload-->\u4e0a\u4f20\u6587\u4ef6\u540e\u53d1\u9001\u62a5\u6587\u8017\u65f6[" + (_end5 - _end4) + "]\u6beb\u79d2, \u670d\u52a1\u7aef\u8fd4\u56de\u4fe1\u606f" + msg);
                    String[] strArray = msg.split(this.splitSym);
                    if (strArray[0].equals("0001")) {
                        if (strArray[1].equals("SUCCESS")) {
                            resultStr = "SUCCESS<<::>>" + strArray[2];
                        }
                        break block30;
                    }
                    resultStr = resultStr + "<<::>>" + msg;
                    break block30;
                }
                resultStr = "FAIL<<::>>" + msg;
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        long end4 = System.currentTimeMillis();
        log.debug("--upload-->\u4e0a\u4f20\u64cd\u4f5c\u8017\u65f6[" + (end4 - start) + "]\u6beb\u79d2");
        log.debug("--upload(over)-->resultStr=" + resultStr);
        return resultStr;
    }

    private void sendClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID) throws SunECMException, IOException {
        log.debug("--sendClientBatchFileBean-->\u53d1\u9001\u6279\u6b21\u6587\u4ef6 contentID:" + contentID);
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                this.conn.sendFileData(fileBean.getFileName(), contentID, "0003<<::>>");
            }
        }
    }

    private void sendBreakClientBatchFileBean(List<ClientBatchFileBean> ClientBatchFileBeans, String contentID, String modeCode) throws IOException, SunECMException {
        log.debug("--sendBreakClientBatchFileBean-->\u53d1\u9001\u6279\u6b21\u6587\u4ef6");
        this.conn.sendMsg("0002" + this.splitSym + "OPTION=" + OptionKey.BREAK_POINT + ",CONTENTID=" + contentID + ",MODECODE=" + modeCode);
        String aa = this.conn.receiveMsg();
        if (aa == null) {
            log.error("\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        String filesStr = aa.split(this.splitSym)[1];
        log.debug("--sendBreakClientBatchFileBean-->Break Point Msg is: " + filesStr);
        List completeFiles = XMLUtil.xml2list((String)filesStr, ClientFileBean.class);
        log.debug("--sendBreakClientBatchFileBean-->\u7edf\u8ba1\u6240\u6709\u7684\u5f85\u4e0a\u4f20\u6587\u4ef6");
        ArrayList<ClientFileBean> totalFileBean = new ArrayList<ClientFileBean>();
        for (ClientBatchFileBean batchFileBean : ClientBatchFileBeans) {
            List<ClientFileBean> fileBeans = batchFileBean.getFiles();
            for (ClientFileBean fileBean : fileBeans) {
                if (fileBean.getFileName() == null) continue;
                totalFileBean.add(fileBean);
            }
        }
        log.debug("--sendBreakClientBatchFileBean-->totalFileBean:" + ((Object)totalFileBean).toString());
        log.debug("--sendBreakClientBatchFileBean-->\u5c06\u4e0d\u5c5e\u4e8e\u5df2\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0a\u4f20");
        if (completeFiles.size() != 0) {
            ArrayList<ClientFileBean> breakFileBean = new ArrayList<ClientFileBean>();
            for (ClientFileBean fileBean : totalFileBean) {
                boolean flag = true;
                for (ClientFileBean complteFile : completeFiles) {
                    if (!fileBean.getFileName().equals(complteFile.getOrigName())) continue;
                    flag = false;
                    Long l = new File(fileBean.getFileName()).length();
                    if (complteFile.getReceived() == null || l.equals(complteFile.getReceived())) continue;
                    breakFileBean.add(fileBean);
                }
                if (!flag) continue;
                breakFileBean.add(fileBean);
            }
            for (ClientFileBean fileBean : breakFileBean) {
                this.conn.sendFileData(fileBean.getFileName(), contentID, "0003<<::>>");
            }
        } else {
            this.sendClientBatchFileBean(ClientBatchFileBeans, contentID);
        }
    }

    private boolean checkFileExist(ClientBatchBean clientBatchBean) {
        log.debug("--checkFileExist-->\u6821\u9a8c\u6587\u4ef6\u662f\u5426\u5b58\u5728");
        boolean flag = false;
        if (clientBatchBean.getIndex_Object().getAmount() == null || clientBatchBean.getIndex_Object().getAmount().equals("")) {
            flag = true;
        }
        int totalFile = 0;
        List<ClientBatchFileBean> batchFileBeans = clientBatchBean.getDocument_Objects();
        for (ClientBatchFileBean clientBatchFileBean : batchFileBeans) {
            List<ClientFileBean> files = clientBatchFileBean.getFiles();
            for (ClientFileBean clientFileBean : files) {
                if (clientBatchFileBean.getFilePartName().equals(clientBatchBean.getModelCode())) {
                    clientBatchBean.getIndex_Object().setCustomMap(clientFileBean.getOtherAtt());
                }
                if (clientFileBean.getFileName() != null) {
                    File file = new File(clientFileBean.getFileName());
                    if (!file.exists() || file.isDirectory()) {
                        log.debug("--checkFileExist-->" + file.getPath() + "\u6587\u4ef6\u4e0d\u5b58\u5728...");
                        return false;
                    }
                    if (flag) {
                        ++totalFile;
                    }
                }
                if (clientFileBean.getProtocol() == null || !flag) continue;
                ++totalFile;
            }
        }
        if (flag) {
            clientBatchBean.getIndex_Object().setAmount(String.valueOf(totalFile));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String heightQuery(ClientHeightQuery heightQuery, String dmsName) throws SunECMException, IOException {
        log.debug("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(heightQuery);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.HEIGHT_QUERY + ",XML=" + XMLUtil.bean2XML((Object)heightQuery) + ",DMSNAME=" + dmsName;
            sendMsg = this.createHeightQuerySendMsgbyToken(heightQuery, sendMsg);
            this.conn.sendMsg(sendMsg);
            log.debug("--heightQuery-->\u67e5\u8be2\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--heightQuery-->\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAllModelMsg_Client() throws SunECMException, IOException {
        log.debug("--getAllModelMsg_Client-->\u5ba2\u6237\u7aef\u83b7\u5f97\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.ALLMODELMSG;
            this.conn.sendMsg(sendMsg);
            log.debug("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--getAllModelMsg_Client-->\u83b7\u5f97\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--getAllModelMsg_Client-->\u5ba2\u6237\u7aef\u83b7\u5f97\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentServerInfo_Client() throws SunECMException, IOException {
        log.debug("--getContentServerInfo_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.GET_NODE;
            this.conn.sendMsg(sendMsg);
            log.debug("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--getContentServerInfo_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getModelTemplate_Client(String[] modeCodes) throws SunECMException, IOException {
        log.debug("--getModelTemplate_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            StringBuffer modeNamesStr = new StringBuffer();
            for (String modeCode : modeCodes) {
                modeNamesStr.append(modeCode).append("::");
            }
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.METATEMPLATE + ",MODENAMES=" + modeNamesStr.toString();
            this.conn.sendMsg(sendMsg);
            log.debug("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--getModelTemplate_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPermissions_Client(String userName, String passWord) throws SunECMException, IOException {
        log.debug("--getPermissions_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650 userName:" + userName);
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.PERMISSION + ",USERNAME=" + userName + ",PASSWORD=" + CodeUtil.encode(passWord);
            this.conn.sendMsg(sendMsg);
            log.debug("--getPermissions_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--getPermissions_Client-->\u5ba2\u6237\u7aef\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6743\u9650(over)");
        return resultStr;
    }

    @Override
    public String getToken(String ipAddress, String tokenCheckValue, String userName, String operationCode) throws SunECMException {
        log.debug("--getToken-->\u5ba2\u6237\u7aef\u83b7\u53d6\u52a8\u6001\u4ee4\u724c");
        String token = "";
        WSConsoleClient consoleClient = new WSConsoleClient();
        SunEcmConsole console = consoleClient.getEcmConsoleClient(ipAddress + "/webservices/WsInterface", 300000L);
        log.debug("--getToken-->\u83b7\u53d6\u52a8\u6001\u4ee4\u724c\u53d1\u9001\u65f6\u7684\u53c2\u6570[tokenCheckValue,userName,operationCode]:" + tokenCheckValue + "," + userName + "," + operationCode);
        token = console.getToken(tokenCheckValue, userName, operationCode);
        log.debug("--getToken-->\u83b7\u53d6\u52a8\u6001\u4ee4\u724c\u53d1\u8fd4\u56de\u7684\u6d88\u606f:" + token);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String inquireDMByGroup(String userName, String groupName) throws Exception {
        log.debug("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740userName:" + userName + "groupName" + groupName);
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.INQUIREDM + ",USERNAME=" + userName + ",DMSNAME=" + groupName;
            this.conn.sendMsg(sendMsg);
            log.debug("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u53d1\u9001\u7684\u6d88\u606f:" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u8fd4\u56de\u7684\u6d88\u606f:" + sendMsg);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740(over)-->resultStr:" + resultStr);
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String immedMigrate(MigrateBatchBean migrateBatchBean, String dmsName) throws Exception {
        log.debug("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(migrateBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.IMMEDIATEMIGRATE + ",XML=" + XMLUtil.bean2XML((Object)migrateBatchBean) + ",DMSNAME=" + dmsName;
            sendMsg = this.createImmigrateBatchSendMsgbyToken(migrateBatchBean, sendMsg);
            this.conn.sendMsg(sendMsg);
            log.debug("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u53d1\u9001\u7684\u6d88\u606f:" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u53d1\u9001\u7684\u6d88\u606f:" + resultStr);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--immedMigrate-->\u7acb\u5373\u8fc1\u79fb(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryNodeInfoByGroupIdAndInsNo(String itemType, String insNo) throws Exception {
        log.debug("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.QUERY_NODEINFO_BY_GROUPID_AND_INSNO + ",MODELCODE=" + itemType + ",INSNO=" + insNo;
            this.conn.sendMsg(sendMsg);
            log.debug("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u5019\u53d1\u9001\u7684\u4fe1\u606f:" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f\u65f6\u5019\u8fd4\u56de\u7684\u6d88\u606f:" + sendMsg);
        }
        finally {
            try {
                this.conn.sendMsg("0009");
                this.conn.receiveMsg();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            finally {
                this.conn.destroy();
            }
        }
        log.debug("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f(over)-->resultStr:" + resultStr);
        return resultStr;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createUserToken(String username, String password) throws Exception {
        String result;
        block14: {
            log.info("\u5f00\u59cb\u83b7\u53d6\u7528\u6237\u4ee4\u724c");
            result = "FAIL";
            try {
                this.connectToHost(this.ipAddress, this.socketPort);
                String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.CREATEUSERTOKEN + ",USERNAME=" + username + ",PASSWORD=" + CodeUtil.encode(password);
                this.conn.sendMsg(sendMsg);
                log.debug("--createUserToken-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u65f6\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
                String res = this.conn.receiveMsg();
                log.debug("--createUserToken-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + res);
                if (res == null || "null".equals(res)) {
                    log.warn("--login-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u5931\u8d25-->msg=" + res);
                    throw new SunECMException("--createUserToken-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u5931\u8d25");
                }
                String[] strArray = res.split(this.splitSym);
                if (strArray[0].equals("0001")) {
                    result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
                    break block14;
                }
                throw new SunECMException("\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + res);
            }
            finally {
                try {
                    this.conn.sendMsg("0009");
                    this.conn.receiveMsg();
                }
                catch (Exception e) {
                    log.warn(e.toString());
                }
                finally {
                    this.conn.destroy();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String copyBatch(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.debug("--copyBatch-->\u6279\u6b21\u590d\u5236(begin)");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + OptionKey.COPY_BATCH + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",DMSNAME=" + dmsName + ",USERNAME=" + clientBatchBean.getUser() + ",PASSWORD=" + clientBatchBean.getPassWord();
            this.conn.sendMsg(sendMsg);
            log.debug("--copyBatch-->\u6279\u6b21\u590d\u5236\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--copyBatch-->\u6279\u6b21\u590d\u5236\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug("--copyBatch-->\u6279\u6b21\u590d\u5236(over)");
        return resultStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String otherRuquest(ClientBatchBean clientBatchBean, String requestName) throws Exception {
        log.debug("--\u7b2c\u4e09\u65b9\u8bf7\u6c42-->");
        this.connectToHost(this.ipAddress, this.socketPort);
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        try {
            String sendMsg = "0002" + this.splitSym + "OPTION=" + "OTHERREQUEST" + ",XML=" + XMLUtil.bean2XML((Object)clientBatchBean) + ",REQUESTNAME=" + requestName;
            this.conn.sendMsg(sendMsg);
            log.debug("--otherRuquest-->\u7b2c\u4e09\u65b9\u8bf7\u6c42\u53d1\u9001\u7684\u6d88\u606f\uff1a" + sendMsg);
            resultStr = this.conn.receiveMsg();
            log.debug("--otherRuquest-->\u7b2c\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr);
        }
        finally {
            this.conn.sendMsg("0009");
            this.conn.destroy();
        }
        log.debug("--\u7b2c\u4e09\u65b9\u8bf7\u6c42--->(over)");
        return resultStr;
    }

    static {
        ClientConfiguration.init();
    }
}

