/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.impl;

import com.sunyard.client.SunEcmClientApi;
import com.sunyard.client.bean.ClientBatchBean;
import com.sunyard.client.bean.ClientBatchFileBean;
import com.sunyard.client.bean.ClientFileBean;
import com.sunyard.client.bean.ClientHeightQuery;
import com.sunyard.client.impl.MD5Util;
import com.sunyard.ecm.server.bean.MigrateBatchBean;
import com.sunyard.exception.SunECMException;
import com.sunyard.util.CodeUtil;
import com.sunyard.util.StringUtil;
import com.sunyard.ws.client.WSConsoleClient;
import com.sunyard.ws.internalapi.SunEcmConsole;
import com.sunyard.ws.utils.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SunECMClientRestApiImpl
implements SunEcmClientApi {
    private static final Logger log = Logger.getLogger(SunECMClientRestApiImpl.class);
    private String ip;
    private int restPort;
    private int httpPort;
    private String serverName;
    private int connTimeOut = 30000;
    private int reqTimeOut = 30000;
    private String splitSym = "<<::>>";

    public SunECMClientRestApiImpl(String ip, int httpPort, String serverName) {
        this.ip = ip;
        this.httpPort = httpPort;
        this.serverName = serverName;
    }

    private String getRestUrl(String option) {
        return "http://" + this.ip + ":" + this.httpPort + "/" + this.serverName + "/" + option;
    }

    private String doGet(String url, Map<String, String> param) {
        String result;
        block17: {
            Iterator<Map.Entry<String, String>> it = param.entrySet().iterator();
            int size = param.size();
            if (size > 0) {
                url = String.valueOf(url) + "?";
            }
            int i = 0;
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                String key = entry.getKey();
                String value = entry.getValue();
                value = value.replaceAll("\"", "%22").replaceAll("<", "%3c").replaceAll(">", "%3e").replaceAll(" ", "%20");
                url = ++i == size ? String.valueOf(url) + key + "=" + value : String.valueOf(url) + key + "=" + value + "&";
            }
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connTimeOut).setConnectionRequestTimeout(this.reqTimeOut).build();
            httpGet.setConfig(requestConfig);
            CloseableHttpClient client = HttpClientBuilder.create().build();
            result = "";
            try {
                try {
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (IOException e) {
                    log.error((Object)"doGet error", (Throwable)e);
                    if (httpGet != null) {
                        httpGet.abort();
                    }
                    if (client == null) break block17;
                    try {
                        client.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (httpGet != null) {
                    httpGet.abort();
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private String doPost(String url, Map<String, String> param) {
        String result;
        block16: {
            HttpPost httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : param.entrySet()) {
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connTimeOut).setConnectionRequestTimeout(this.reqTimeOut).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpClient client = HttpClientBuilder.create().build();
            result = "";
            try {
                try {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, "UTF-8"));
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    }
                }
                catch (IOException e) {
                    log.error((Object)"doPost error", (Throwable)e);
                    if (httpPost != null) {
                        httpPost.abort();
                    }
                    if (client == null) break block16;
                    try {
                        client.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (httpPost != null) {
                    httpPost.abort();
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private String postFile(String url, Map<String, File> mapFile, Map<String, String> param) {
        String result = "";
        try {
            ArrayList list = new ArrayList();
            MultipartEntityBuilder reqEntity = MultipartEntityBuilder.create();
            reqEntity.setCharset(Charset.forName("UTF-8"));
            reqEntity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (mapFile != null) {
                for (Map.Entry<String, Object> entry : mapFile.entrySet()) {
                    String fileName = entry.getKey();
                    File file = (File)entry.getValue();
                    ContentType ctype = ContentType.create((String)"application/octet-stream", (String)"UTF-8");
                    reqEntity.addPart("imageFiles", (ContentBody)new FileBody(file, ctype, fileName));
                    System.out.println("======================" + file.getAbsolutePath());
                }
            }
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                String key = entry.getKey();
                String value = (String)entry.getValue();
                reqEntity.addPart(key, (ContentBody)new StringBody(value));
            }
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(reqEntity.build());
            CloseableHttpClient client = HttpClientBuilder.create().build();
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            result = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"doFilePost error", (Throwable)e);
            return result;
        }
    }

    protected void createBatchSendMsgbyToken(ClientBatchBean clientBatchBean, Map<String, String> map) {
        if (StringUtil.stringIsNull(clientBatchBean.getUser())) {
            map.put("TOKEN", clientBatchBean.getToken());
        } else {
            map.put("USERNAME", clientBatchBean.getUser());
            map.put("PASSWORD", clientBatchBean.getPassWord());
        }
    }

    protected void createHeightQuerySendMsgbyToken(ClientHeightQuery heightQuery, Map<String, String> map) {
        if (StringUtil.stringIsNull(heightQuery.getUserName())) {
            map.put("TOKEN", heightQuery.getToken());
        } else {
            map.put("USERNAME", heightQuery.getUserName());
            map.put("PASSWORD", heightQuery.getPassWord());
        }
    }

    protected void createImmigrateBatchSendMsgbyToken(MigrateBatchBean migrateBatchBean, Map<String, String> map) {
        if (StringUtil.stringIsNull(migrateBatchBean.getUserName())) {
            map.put("TOKEN", migrateBatchBean.getToken());
        } else {
            map.put("USERNAME", migrateBatchBean.getUserName());
            map.put("PASSWORD", migrateBatchBean.getPassWord());
        }
    }

    @Override
    public String inquireDMByGroup(String userName, String groupName) throws Exception {
        log.info((Object)"--inquireDMByGroup-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("USERNAME", userName);
        map.put("DMSNAME", groupName);
        String url = this.getRestUrl("inquiredmbyGroup");
        String result = this.doPost(url, map);
        log.debug((Object)("--inquireDMByGroup-->\u67e5\u8be2\u5185\u5bb9\u5b58\u50a8\u670d\u52a1\u5668\u7684\u5730\u5740\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + result));
        return result;
    }

    @Override
    public String login(String userName, String password) throws Exception {
        password = CodeUtil.encode(password);
        log.info((Object)("--login-->\u767b\u5f55userName" + userName + "password" + password));
        String resultMsg = "FAIL";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("USERNAME", userName);
        map.put("PASSWORD", password);
        String url = this.getRestUrl("login");
        String msg = this.doPost(url, map);
        log.debug((Object)("--login-->\u767b\u5f55\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        if (msg == null || "null".equals(msg)) {
            log.warn((Object)("--login-->\u767b\u9646\u5931\u8d25-->msg=" + msg));
            throw new SunECMException("--login-->\u767b\u9646\u5931\u8d25");
        }
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            if (strArray[1].equals("SUCCESS")) {
                resultMsg = "SUCCESS";
            } else {
                log.warn((Object)"\u767b\u9646\u5931\u8d25");
            }
        }
        log.info((Object)("--login-->\u767b\u5f55(over)-->resultMsg:" + resultMsg));
        return resultMsg;
    }

    @Override
    public String logout(String userName) throws Exception {
        log.info((Object)("--logout-->\u767b\u51fauserName" + userName));
        String resultMsg = "FAIL";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("USERNAME", userName);
        String url = this.getRestUrl("logout");
        String msg = this.doPost(url, map);
        log.debug((Object)("--logout-->\u767b\u51fa\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            if (strArray[1].equals("SUCCESS")) {
                resultMsg = "SUCCESS";
            } else {
                log.warn((Object)"\u767b\u51fa\u5f02\u5e38");
                throw new SunECMException("\u767b\u51fa\u5f02\u5e38");
            }
        }
        log.info((Object)"--logout-->\u767b\u51fa(over)");
        return resultMsg;
    }

    @Override
    public String upload(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--upload-->\u4e0a\u4f20");
        Map<String, File> mapFile = this.checkFileExist(clientBatchBean);
        if (mapFile == null) {
            return "FAIL";
        }
        CodeUtil.encodeInBean(clientBatchBean);
        MD5Util.addBatchMD5Code(clientBatchBean);
        log.debug((Object)"--upload-->\u4e0a\u4f20\u5f00\u59cb");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        map.put("connModel", clientBatchBean.getModelCode());
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("upload");
        String rs = this.postFile(url, mapFile, map);
        log.info((Object)("--upload-->\u4e0a\u4f20(over)-->reslutMsg=" + rs));
        return rs;
    }

    public String update(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--update-->\u66f4\u65b0");
        Map<String, File> mapFile = this.checkFileExist(clientBatchBean);
        CodeUtil.encodeInBean(clientBatchBean);
        MD5Util.addBatchMD5Code(clientBatchBean);
        log.debug((Object)"--update-->\u66f4\u65b0\u5f00\u59cb");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        map.put("connModel", clientBatchBean.getModelCode());
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("update");
        String rs = this.postFile(url, mapFile, map);
        log.info((Object)("--update-->\u66f4\u65b0(over)-->reslutMsg=" + rs));
        return rs;
    }

    @Override
    public String update(ClientBatchBean clientBatchBean, String dmsName, boolean isAutoCheck) throws Exception {
        log.info((Object)"--update-->\u66f4\u65b0");
        String resultStr = "FAIL";
        Map<String, File> mapFile = this.checkFileExist(clientBatchBean);
        if (mapFile == null) {
            return "FAIL<<::>>707";
        }
        MD5Util.addBatchMD5Code(clientBatchBean);
        if (isAutoCheck) {
            String OldPassWord = clientBatchBean.getPassWord();
            String checkOutMsg = this.checkOut(clientBatchBean, dmsName);
            if (!checkOutMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                log.warn((Object)("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg));
                throw new SunECMException("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u5931\u8d25:" + checkOutMsg);
            }
            clientBatchBean.setCheckToken(checkOutMsg.split(this.splitSym)[1]);
            log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u51fa\u6210\u529f..."));
            try {
                clientBatchBean.setPassWord(OldPassWord);
                resultStr = this.update(clientBatchBean, dmsName);
                log.debug((Object)("--update-->\u81ea\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c\uff1a" + resultStr));
            }
            finally {
                clientBatchBean.setPassWord(OldPassWord);
                String checkInMsg = this.checkIn(clientBatchBean, dmsName);
                if (!checkInMsg.split(this.splitSym)[0].equals("SUCCESS")) {
                    log.warn((Object)("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg));
                    throw new SunECMException("\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u5931\u8d25:" + checkInMsg);
                }
            }
            log.debug((Object)("--update-->\u6279\u6b21[" + clientBatchBean.getIndex_Object().getContentID() + "]\u81ea\u52a8\u68c0\u5165\u6210\u529f..."));
        } else {
            resultStr = this.update(clientBatchBean, dmsName);
            log.debug((Object)("--update-->\u624b\u52a8\u68c0\u5165\u68c0\u51fa\u66f4\u65b0\u8fd4\u56de\u7ed3\u679c\uff1a" + resultStr));
        }
        log.info((Object)"--update-->\u66f4\u65b0(over)");
        return resultStr;
    }

    @Override
    public String delete(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--delete-->\u5220\u9664 clientBatchBean");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        map.put("connModel", clientBatchBean.getModelCode());
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("delete");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--delete-->\u5220\u9664\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.info((Object)"--delete(over)");
        return resultStr;
    }

    @Override
    public String checkIn(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--checkIn-->\u68c0\u5165clientBatchBean");
        String result = "FAIL";
        CodeUtil.encodeInBean(clientBatchBean);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("checkin");
        String msg = this.doPost(url, map);
        log.info((Object)("--checkIn-->\u68c0\u5165\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym : "FAIL";
        } else {
            log.warn((Object)("\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
            throw new SunECMException("\u68c0\u5165\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
        }
        log.info((Object)("--checkIn(over)-->\u68c0\u5165" + result));
        return result;
    }

    @Override
    public String checkOut(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--checkOut-->\u68c0\u51fa clientBatchBean");
        CodeUtil.encodeInBean(clientBatchBean);
        String result = "FAIL";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("checkout");
        String msg = this.doPost(url, map);
        log.debug((Object)("--checkOut-->\u68c0\u51fa\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + msg));
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
        } else {
            throw new SunECMException("\u68c0\u51fa\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
        }
        log.info((Object)("--checkOut-->\u68c0\u51fa(over)-->result:" + result));
        return result;
    }

    @Override
    public String createContentID(ClientBatchBean clientBatchBean, String groupName) throws Exception {
        log.info((Object)"--createID-->\u7533\u8bf7\u6279\u6b21\u53f7");
        String result = "";
        CodeUtil.encodeInBean(clientBatchBean);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", groupName);
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("createid");
        String msg = this.doPost(url, map);
        log.debug((Object)("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7\u65f6\u8fd4\u56de\u7684\u4fe1\u606f\uff1a" + msg));
        String[] strArray = msg.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            result = strArray[1].equals("SUCCESS") ? msg : "FAIL";
        } else {
            log.warn((Object)("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg));
            throw new SunECMException("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + msg);
        }
        log.info((Object)("--createContentID-->\u7533\u8bf7\u6279\u6b21\u53f7-->result:" + result));
        return result;
    }

    @Override
    public String queryBatch(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.info((Object)"--queryBatch-->\u67e5\u8be2\u6279\u6b21\u6587\u4ef6");
        CodeUtil.encodeInBean(clientBatchBean);
        clientBatchBean.setPASSWD(clientBatchBean.getPassWord());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        map.put("connModel", clientBatchBean.getModelCode());
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("query");
        String result = this.doPost(url, map);
        log.debug((Object)("--queryBatch-->\u67e5\u8be2\u6279\u6b21\u6587\u4ef6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + result));
        return result;
    }

    @Override
    public String heightQuery(ClientHeightQuery heightQuery, String dmsName) throws Exception {
        log.info((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2");
        CodeUtil.encodeInBean(heightQuery);
        log.debug((Object)XMLUtil.bean2XML((Object)heightQuery));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)heightQuery));
        map.put("DMSNAME", dmsName);
        map.put("connModel", heightQuery.getModelCode());
        this.createHeightQuerySendMsgbyToken(heightQuery, map);
        String url = this.getRestUrl("heightquery");
        String rs = this.doPost(url, map);
        log.debug((Object)("--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + rs));
        log.info((Object)"--heightQuery-->\u9ad8\u7ea7\u67e5\u8be2(over)");
        return rs;
    }

    @Override
    public String operAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        return null;
    }

    @Override
    public String queryAnnotation(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        return null;
    }

    @Override
    public String getPermissions_Client(String userName, String passWord) throws Exception {
        log.info((Object)("--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u83b7\u53d6 username:" + userName));
        String resultStr = "FAIL";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("USERNAME", userName);
        map.put("PASSWORD", CodeUtil.encode(passWord));
        String url = this.getRestUrl("getpermission");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.info((Object)"--getPermissions_Client-->\u83b7\u5f97\u5185\u5bb9\u6a21\u578b\u6743\u9650\u83b7\u53d6(over)");
        return resultStr;
    }

    @Override
    public String getContentServerInfo_Client() throws Exception {
        log.info((Object)"--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f");
        String resultStr = "FAIL";
        String url = this.getRestUrl("getnodeinfo");
        HashMap<String, String> map = new HashMap<String, String>();
        resultStr = this.doGet(url, map);
        log.debug((Object)("--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.info((Object)"--getContentServerInfo_Client-->\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5668\u4fe1\u606f(over)");
        return resultStr;
    }

    @Override
    public String getAllModelMsg_Client() throws Exception {
        log.info((Object)"--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f");
        String resultStr = "FAIL";
        HashMap<String, String> map = new HashMap<String, String>();
        String url = this.getRestUrl("getallmodelmsg");
        resultStr = this.doGet(url, map);
        log.debug((Object)("--getAllModelMsg_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u5217\u8868\u4fe1\u606f\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.info((Object)"--getAllModelMsg_Client(over)");
        return resultStr;
    }

    @Override
    public String getModelTemplate_Client(String[] modeCodes) throws Exception {
        log.info((Object)"--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248");
        String resultStr = "FAIL";
        StringBuffer modeNamesStr = new StringBuffer();
        String[] stringArray = modeCodes;
        int n = modeCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String modeCode = stringArray[n2];
            modeNamesStr.append(modeCode).append("::");
            ++n2;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("MODELNAMES", modeNamesStr.toString());
        String url = this.getRestUrl("getmodeltemplate");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.info((Object)"--getModelTemplate_Client-->\u83b7\u53d6\u5185\u5bb9\u6a21\u578b\u6a21\u7248(over)");
        return resultStr;
    }

    @Override
    public String getToken(String ipAddress, String tokenCheckValue, String userName, String operationCode) throws Exception {
        log.info((Object)"--getToken-->\u83b7\u5f97\u4ee4\u724c");
        String token = "FAIL";
        WSConsoleClient consoleClient = new WSConsoleClient();
        SunEcmConsole console = consoleClient.getEcmConsoleClient(String.valueOf(ipAddress) + "/webservices/WsInterface", 300000L);
        token = console.getToken(tokenCheckValue, userName, operationCode);
        log.info((Object)("--getToken-->\u83b7\u5f97\u4ee4\u724c token:" + token));
        return token;
    }

    @Override
    public String immedMigrate(MigrateBatchBean migrateBatchBean, String dmsName) throws Exception {
        log.info((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb");
        String resultStr = "FAIL";
        CodeUtil.encodeInBean(migrateBatchBean);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)migrateBatchBean));
        map.put("DMSNAME", dmsName);
        this.createImmigrateBatchSendMsgbyToken(migrateBatchBean, map);
        String url = this.getRestUrl("immedmigrate");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--SunEcmClientHttpApiImpl-->immedMigrate-->\u7acb\u5373\u8fc1\u79fb\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.info((Object)"--immedMigrate-->\u7acb\u5373\u8fc1\u79fb(over)");
        return resultStr;
    }

    @Override
    public String queryNodeInfoByGroupIdAndInsNo(String itemType, String insNo) throws Exception {
        log.info((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f,modelCode" + itemType + "insNo" + insNo));
        String resultStr = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("MODELCODE", itemType);
        map.put("INSNO", insNo);
        String url = this.getRestUrl("queryNodeInfoByGroupIdAndInsNo");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f" + resultStr));
        log.info((Object)("--queryNodeInfoByGroupIdAndInsNo-->\u5411\u7edf\u4e00\u63a5\u5165\u95ee\u8be2\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u7684\u670d\u52a1\u5668\u4fe1\u606f(over)-->resultStr:" + resultStr));
        return resultStr;
    }

    @Override
    public String createUserToken(String username, String password) throws Exception {
        log.info((Object)"\u5f00\u59cb\u83b7\u53d6\u7528\u6237\u4ee4\u724c");
        String result = "FAIL";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("USERNAME", username);
        map.put("PASSWORD", password);
        String url = this.getRestUrl("createusertoken");
        String res = this.doPost(url, map);
        log.debug((Object)("--createUserToken-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u65f6\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + res));
        if (res == null || "null".equals(res)) {
            log.warn((Object)("--login-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u5931\u8d25-->msg=" + res));
            throw new SunECMException("--createUserToken-->\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u5931\u8d25");
        }
        String[] strArray = res.split(this.splitSym);
        if (strArray[0].equals("0001")) {
            result = strArray[1].equals("SUCCESS") ? "SUCCESS" + this.splitSym + strArray[2] : "FAIL" + this.splitSym + strArray[2];
        } else {
            throw new SunECMException("\u83b7\u53d6\u7528\u6237\u4ee4\u724c\u65f6\u53d1\u751f\u5f02\u5e38...\u5f02\u5e38\u4ee3\u7801\uff1a" + res);
        }
        return result;
    }

    @Override
    public String copyBatch(ClientBatchBean clientBatchBean, String dmsName) throws Exception {
        log.debug((Object)"--copyBatch-->\u6279\u6b21\u590d\u5236(begin)");
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("DMSNAME", dmsName);
        map.put("USERNAME", clientBatchBean.getUser());
        map.put("PASSWORD", clientBatchBean.getPassWord());
        this.createBatchSendMsgbyToken(clientBatchBean, map);
        String url = this.getRestUrl("copybatch");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--copyBatch-->\u6279\u6b21\u590d\u5236\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.debug((Object)"--copyBatch-->\u6279\u6b21\u590d\u5236(over)");
        return resultStr;
    }

    @Override
    public String otherRuquest(ClientBatchBean clientBatchBean, String requestName) throws Exception {
        log.debug((Object)"--\u7b2c\u4e09\u65b9\u8bf7\u6c42-->");
        String resultStr = "";
        CodeUtil.encodeInBean(clientBatchBean);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("XML", XMLUtil.bean2XML((Object)clientBatchBean));
        map.put("REQUESTNAME", requestName);
        String url = this.getRestUrl("otherrequest");
        log.debug((Object)"--otherRuquest-->\u7b2c\u4e09\u65b9\u8bf7\u6c42\u53d1\u9001\u7684\u6d88\u606f");
        resultStr = this.doPost(url, map);
        log.debug((Object)("--otherRuquest-->\u7b2c\u4e09\u65b9\u8bf7\u6c42\u8fd4\u56de\u7684\u6d88\u606f\uff1a" + resultStr));
        log.debug((Object)"--\u7b2c\u4e09\u65b9\u8bf7\u6c42-->(over)");
        return resultStr;
    }

    private Map<String, File> checkFileExist(ClientBatchBean clientBatchBean) {
        log.info((Object)"--checkFileExist-->\u6821\u9a8c\u6587\u4ef6\u662f\u5426\u5b58\u5728,\u5e76\u7edf\u8ba1\u6587\u4ef6\u6570");
        boolean flag = false;
        if (clientBatchBean.getIndex_Object().getAmount() == null || clientBatchBean.getIndex_Object().getAmount().equals("")) {
            flag = true;
        }
        HashMap<String, File> mapFile = new HashMap<String, File>();
        int totalFile = 0;
        List<ClientBatchFileBean> batchFileBeans = clientBatchBean.getDocument_Objects();
        for (ClientBatchFileBean clientBatchFileBean : batchFileBeans) {
            List<ClientFileBean> files = clientBatchFileBean.getFiles();
            for (ClientFileBean clientFileBean : files) {
                if (clientBatchFileBean.getFilePartName().equals(clientBatchBean.getModelCode())) {
                    clientBatchBean.getIndex_Object().setCustomMap(clientFileBean.getOtherAtt());
                }
                if (clientFileBean.getFileName() != null) {
                    File file = new File(clientFileBean.getFileName());
                    if (!file.exists() || file.isDirectory()) {
                        log.debug((Object)("--checkFileExist-->" + file.getPath() + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
                        return null;
                    }
                    mapFile.put(clientFileBean.getFileName(), file);
                    if (flag) {
                        ++totalFile;
                    }
                }
                if (clientFileBean.getProtocol() == null || !flag) continue;
                ++totalFile;
            }
        }
        if (flag) {
            clientBatchBean.getIndex_Object().setAmount(String.valueOf(totalFile));
        }
        return mapFile;
    }
}

