/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfiguration {
    private static final String[] DEFAULT_RESOURCE = new String[]{"clientConfig.properties"};
    private static volatile boolean INIT = false;
    private static Properties props;
    private static String[] RESOURCES;
    private static final Logger LOG;

    public static String get(String key) {
        return props.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if ("true".equals(valueString)) {
            return true;
        }
        if ("false".equals(valueString)) {
            return false;
        }
        return defaultValue;
    }

    public static float getFloat(String name, float defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int getInt(String name, int defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLong(String name, long defaultValue) {
        String valueString = ClientConfiguration.get(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (INIT) {
            return;
        }
        props = new Properties();
        InputStream in = null;
        try {
            for (String resource : RESOURCES) {
                LOG.info("load resource:" + resource);
                in = ClientConfiguration.class.getClassLoader().getResourceAsStream(resource);
                if (in == null) continue;
                props.load(in);
                in.close();
            }
            INIT = true;
        }
        catch (Exception e) {
            INIT = false;
            ClientConfiguration.clear();
            LOG.warn("Failed to init conf, resource:" + Arrays.toString(RESOURCES));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error("\u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    public static void init(String[] resource) {
        RESOURCES = resource;
        ClientConfiguration.init();
    }

    public static void clear() {
        props.clear();
        INIT = false;
    }

    static {
        RESOURCES = DEFAULT_RESOURCE;
        LOG = LoggerFactory.getLogger(ClientConfiguration.class);
    }
}

