/*
 * Decompiled with CFR 0.152.
 */
package com.sunyard.client.bean.converter;

import com.sunyard.ws.utils.XMLUtil;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;

public class ClientStringCustomConverter
implements Converter {
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.map2xml(value, writer, context);
    }

    protected void map2xml(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object subvalue = entry.getValue();
            writer.startNode(key);
            if (this.canConvert(subvalue.getClass())) {
                this.map2xml(subvalue, writer, context);
            } else {
                writer.setValue(XMLUtil.bean2XML(subvalue));
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Map map = (Map)this.populateMap(reader, context);
        return map;
    }

    protected Object populateMap(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        String key = "";
        String value = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            key = reader.getNodeName();
            value = this.convertAttributeBean(reader, context);
            reader.moveUp();
            map.put(key, value);
        }
        return map;
    }

    protected String convertAttributeBean(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String str = new String();
        reader.moveDown();
        str = (String)context.convertAnother((Object)str, String.class);
        reader.moveUp();
        return str;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Map.class) || clazz.equals(HashMap.class) || clazz.equals(LinkedMap.class);
    }
}

