/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public OneOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ObjectMapper mapper) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(mapper, this.getValidatorType().getValue(), schemaNode.get(i), parentSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        int numberOfValidSchema = 0;
        Set<ValidationMessage> errors = new HashSet<ValidationMessage>();
        for (JsonSchema schema : this.schemas) {
            Set<ValidationMessage> schemaErrors = schema.validate(node, rootNode, at);
            if (schemaErrors.isEmpty()) {
                ++numberOfValidSchema;
                errors = new HashSet();
            }
            if (numberOfValidSchema == 0) {
                errors.addAll(schemaErrors);
            }
            if (numberOfValidSchema <= 1) continue;
            break;
        }
        if (numberOfValidSchema == 0) {
            errors = errors.stream().filter(msg -> !ValidatorTypeCode.ADDITIONAL_PROPERTIES.equals((Object)ValidatorTypeCode.fromValue(msg.getType()))).collect(Collectors.toSet());
        }
        if (numberOfValidSchema > 1) {
            errors = new HashSet();
            errors.add(this.buildValidationMessage(at, ""));
        }
        return errors;
    }
}

