/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.property;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.dto.AllowableListValues;
import com.mangofactory.swagger.models.dto.AllowableRangeValues;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;

public final class ApiModelProperties {
    private ApiModelProperties() {
        throw new UnsupportedOperationException();
    }

    public static Function<ApiModelProperty, AllowableValues> toAllowableValues() {
        return new Function<ApiModelProperty, AllowableValues>(){

            public AllowableValues apply(ApiModelProperty annotation) {
                return ApiModelProperties.allowableValueFromString(annotation.allowableValues());
            }
        };
    }

    public static AllowableValues allowableValueFromString(String allowableValueString) {
        AllowableValues allowableValues = new AllowableListValues(Lists.newArrayList(), "LIST");
        if ((allowableValueString = allowableValueString.trim().replaceAll(" ", "")).startsWith("range[")) {
            allowableValueString = allowableValueString.replaceAll("range\\[", "").replaceAll("]", "");
            Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)allowableValueString);
            ArrayList ranges = Lists.newArrayList((Iterable)split);
            allowableValues = new AllowableRangeValues((String)ranges.get(0), (String)ranges.get(1));
        } else if (allowableValueString.contains(",")) {
            Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)allowableValueString);
            allowableValues = new AllowableListValues(Lists.newArrayList((Iterable)split), "LIST");
        } else if (StringUtils.hasText((String)allowableValueString)) {
            List<String> singleVal = Arrays.asList(allowableValueString.trim());
            allowableValues = new AllowableListValues(singleVal, "LIST");
        }
        return allowableValues;
    }

    public static Function<ApiModelProperty, Boolean> toIsRequired() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.required();
            }
        };
    }

    public static Function<ApiModelProperty, String> toDescription() {
        return new Function<ApiModelProperty, String>(){

            public String apply(ApiModelProperty annotation) {
                String description = "";
                if (!Strings.isNullOrEmpty((String)annotation.value())) {
                    description = annotation.value();
                } else if (!Strings.isNullOrEmpty((String)annotation.notes())) {
                    description = annotation.notes();
                }
                return description;
            }
        };
    }

    public static Function<ApiModelProperty, Integer> toPosition() {
        return new Function<ApiModelProperty, Integer>(){

            public Integer apply(ApiModelProperty annotation) {
                return annotation.position();
            }
        };
    }

    public static Function<ApiModelProperty, Boolean> toHidden() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.hidden();
            }
        };
    }
}

