/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.t4;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServerListEntry
implements Serializable {
    private static final long serialVersionUID = 6677872638504273601L;
    private String[] serverName_ = null;
    private int[] portNumber_ = null;
    private InetAddress[] inetAddress_ = null;
    private long lastUpdated_;

    public ServerListEntry(String[] stringArray, int[] nArray, long l10) {
        int n2 = stringArray.length;
        this.serverName_ = new String[n2];
        this.portNumber_ = new int[n2];
        for (int i10 = 0; i10 < n2; ++i10) {
            this.serverName_[i10] = stringArray[i10];
            this.portNumber_[i10] = nArray[i10];
        }
        this.inetAddress_ = new InetAddress[this.serverName_.length];
        this.lastUpdated_ = l10;
        this.updateInetAddress();
    }

    public synchronized void update(String[] stringArray, int[] nArray, InetAddress[] inetAddressArray, long l10) {
        this.serverName_ = stringArray;
        this.portNumber_ = nArray;
        this.inetAddress_ = inetAddressArray;
        this.lastUpdated_ = l10;
    }

    public synchronized void updateServer(String[] stringArray) {
        this.serverName_ = stringArray;
        this.updateInetAddress();
    }

    public synchronized void updatePortNumber(int[] nArray) {
        this.portNumber_ = nArray;
    }

    public synchronized void updateLastUpdatedTime(long l10) {
        this.lastUpdated_ = l10;
    }

    private void updateInetAddress() {
        try {
            if (this.inetAddress_.length != this.serverName_.length) {
                this.inetAddress_ = new InetAddress[this.serverName_.length];
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw ServerListEntry.b(unknownHostException);
        }
        for (int i10 = 0; i10 < this.serverName_.length; ++i10) {
            try {
                this.inetAddress_[i10] = InetAddress.getByName(this.serverName_[i10]);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                this.inetAddress_[i10] = null;
            }
        }
    }

    public String[] getServerName() {
        return this.serverName_;
    }

    public int[] getPortNumber() {
        return this.portNumber_;
    }

    public InetAddress[] getInetAddress() {
        return this.inetAddress_;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdated_;
    }

    private static UnknownHostException b(UnknownHostException unknownHostException) {
        return unknownHostException;
    }
}

