/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.internal.generator.GeneratorImpl;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import com.ibm.db2.cmx.tools.internal.generator.metadata.MethodInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlProcessor
extends DefaultHandler {
    public DocumentBuilderFactory documentBuilderFactory_;
    public ClassInfo classInfo_;
    public Document document_;
    public GeneratorImpl generatorImpl_;
    public static final String STR_ROOT = "entity-mappings";
    public static final String STR_NAMED_QUERY = "named-native-query";
    public static final String STR_HINT = "hint";
    public static final String STR_QUERY = "query";
    public static final String STR_NAME = "name";
    public static final String STR_ENTITY = "entity";
    public static final String STR_TABLE = "table";
    public static final String STR_SCHEMA = "schema";
    public static final String STR_COLUMN = "column";
    public static final String STR_CLASS = "class";
    public static final String STR_GENERATED = "generated-value";
    public static final String STR_ID = "id";
    public static final String STR_BASIC = "basic";
    public static final String STR_ATTRIBUTES = "attributes";
    public static final String STR_ATTRIBUTE_OVERRIDE = "attribute-override";
    public static final String NO_NS_PATH_ENTITY_MAPPINGS = "./entity-mappings";
    public static final String NO_NS_PATH_NAMED_NATIVE_QUERIES = "./named-native-query | ./entity/named-native-query";
    public static final String NO_NS_PATH_NAME_ATTRIBUTE = "./@name";
    public static final String NO_NS_PATH_QUERY_TEXT = "./query/text()";
    public static final String NO_NS_PATH_HINTS = "./hint";

    public XmlProcessor(String string, ClassInfo classInfo, GeneratorImpl generatorImpl) {
        this.classInfo_ = classInfo;
        this.generatorImpl_ = generatorImpl;
        this.createDocumentBuilderFactoryInstance();
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory_.newDocumentBuilder();
            File file = new File(string);
            this.classInfo_.getOriginInfo().setAbsolutePathToXmlFile(file.getAbsolutePath());
            this.classInfo_.getOriginInfo().setLastModificationDateOfXmlFile(file.lastModified());
            FileInputStream fileInputStream = new FileInputStream(string);
            this.document_ = documentBuilder.parse(fileInputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), parserConfigurationException, 10204, null, null);
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), iOException, 10205, null, null);
        }
        catch (SAXException sAXException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), sAXException, 10206, null, null);
        }
    }

    public void processXmlInformation() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            Node node = (Node)xPath.evaluate(NO_NS_PATH_ENTITY_MAPPINGS, this.document_, XPathConstants.NODE);
            if (node == null) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_NOENT", new Object[0]), null, 10207, null, null);
            }
            NodeList nodeList = (NodeList)xPath.evaluate(NO_NS_PATH_NAMED_NATIVE_QUERIES, node, XPathConstants.NODESET);
            if (null != nodeList) {
                for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
                    this.processNamedNativeQueryAttributes(nodeList.item(i10), xPath);
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), xPathExpressionException, 10357, null, null);
        }
    }

    private void processNamedNativeQueryAttributes(Node node, XPath xPath) {
        try {
            NodeList nodeList;
            String string = xPath.evaluate(NO_NS_PATH_NAME_ATTRIBUTE, node);
            if (null == string) {
                return;
            }
            List<MethodInfo> list = this.classInfo_.getListOfMethods();
            MethodInfo methodInfo = XmlProcessor.parseMethodSignature(list, string);
            if (methodInfo != null) {
                this.processColumnAnnotationInformation(methodInfo);
            }
            if (methodInfo == null) {
                return;
            }
            methodInfo.setNamedNativeQueryName(string);
            String string2 = xPath.evaluate(NO_NS_PATH_QUERY_TEXT, node);
            if (null != string2) {
                this.checkForXmlSQLOverriddingInterfaceSQLAndWarn(methodInfo, string, string2);
                methodInfo.setSql(string2);
                methodInfo.setUsesNamedNativeQuerySql(true);
            }
            if (null != (nodeList = (NodeList)xPath.evaluate(NO_NS_PATH_HINTS, node, XPathConstants.NODESET))) {
                for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
                    this.processHint(methodInfo, nodeList.item(i10));
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_FILE", new Object[0]), xPathExpressionException, 10356, null, null);
        }
    }

    private void checkForXmlSQLOverriddingInterfaceSQLAndWarn(MethodInfo methodInfo, String string, String string2) {
        String string3 = methodInfo.getSql();
        if (null != string3 && !string3.equalsIgnoreCase(string2)) {
            WarningFactory.createPureQueryWarningForGeneratorOnly(Messages.getText("WARN_XML_SQL_OVERRIDING_IMPL_SQL", string, string2, string3), 10298, this.generatorImpl_, null, methodInfo, this.getClass(), "checkForXmlSQLOverriddingInterfaceSQLAndWarn (MethodInfo, String, String)");
        }
    }

    private void processHint(MethodInfo methodInfo, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(STR_NAME);
        String string = node2.getTextContent();
        Node node3 = namedNodeMap.getNamedItem("value");
        String string2 = node3.getTextContent();
        if ("concurrency".equals(string)) {
            int n2;
            try {
                n2 = XmlTags.getConcurrencyNumber(string2);
            }
            catch (DataRuntimeException dataRuntimeException) {
                n2 = 1007;
            }
            methodInfo.setCursorConcurrency(n2);
            methodInfo.addNamedNativeQueryHint(string, string2);
        } else if ("holdability".equals(string)) {
            int n3;
            try {
                n3 = XmlTags.getHoldabilityNumber(string2, 2);
            }
            catch (DataRuntimeException dataRuntimeException) {
                n3 = 2;
            }
            methodInfo.setCursorHoldability(n3);
            methodInfo.addNamedNativeQueryHint(string, string2);
        } else if ("type".equals(string)) {
            try {
                int n4 = XmlTags.getCursorTypeNumber(string2);
            }
            catch (DataRuntimeException dataRuntimeException) {
                int n5 = 1003;
            }
            methodInfo.setCursorType(XmlTags.getCursorTypeNumber(string2));
            methodInfo.addNamedNativeQueryHint(string, string2);
        } else if ("allowStaticRowsetCursors".equals(string)) {
            methodInfo.setAllowStaticRowsetCursors(XmlTags.getValueOfBoolean(string2, false));
            methodInfo.addNamedNativeQueryHint(string, string2);
        }
    }

    private void createDocumentBuilderFactoryInstance() {
        if (this.documentBuilderFactory_ == null) {
            this.documentBuilderFactory_ = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory_.setCoalescing(true);
        }
    }

    public static MethodInfo parseMethodSignature(List<MethodInfo> list, String string) {
        if (!(string = string.trim()).endsWith(")")) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_METSIGN", new Object[0]), null, 10208, null, null);
        }
        int n2 = string.indexOf(35);
        if (n2 == -1) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_POUND", new Object[0]), null, 10209, null, null);
        }
        String string2 = string.substring(0, n2);
        if (string2.contains(" ")) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_INV_CL", string2), null, 10210, null, null);
        }
        int n3 = string.indexOf(40, n2 + 1);
        if (n3 == -1) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_XML_METSIGN2", new Object[0]), null, 10211, null, null);
        }
        String string3 = string.substring(n2 + 1);
        return XmlProcessor.matchXmlMethodNameToInterface(list, string3);
    }

    private boolean ifNodeorNameisNull(Node node) {
        if (node == null) {
            return true;
        }
        return node.getLocalName() == null;
    }

    private Map<String, String> getColumnOverrideMap(List<String> list, NodeList nodeList) {
        HashMap<String, String> hashMap = null;
        for (int i10 = 0; i10 < list.size(); ++i10) {
            String string = list.get(i10);
            int n2 = this.getMatchingBeanIndex(string, nodeList);
            if (n2 == -1) {
                return null;
            }
            Node node = nodeList.item(n2);
            Node node2 = null;
            NodeList nodeList2 = node.getChildNodes();
            for (int i11 = 0; i11 <= nodeList2.getLength(); ++i11) {
                String string2;
                Node node3 = nodeList2.item(i11);
                if (this.ifNodeorNameisNull(node3) || !(node3 = nodeList2.item(i11)).getLocalName().equals(STR_ATTRIBUTE_OVERRIDE) || !node3.hasAttributes()) continue;
                NamedNodeMap namedNodeMap = node3.getAttributes();
                node2 = namedNodeMap.getNamedItem(STR_NAME);
                String string3 = string2 = node2 != null ? node2.getNodeValue() : null;
                if (string2 == null) continue;
                NodeList nodeList3 = node3.getChildNodes();
                for (int i12 = 0; i12 <= nodeList3.getLength(); ++i12) {
                    String string4;
                    Node node4 = nodeList3.item(i12);
                    if (this.ifNodeorNameisNull(node4) || !node4.getLocalName().equals(STR_COLUMN) || !node4.hasAttributes()) continue;
                    NamedNodeMap namedNodeMap2 = node4.getAttributes();
                    node2 = namedNodeMap2.getNamedItem(STR_NAME);
                    String string5 = string4 = node2 != null ? node2.getNodeValue() : null;
                    if (string4 == null) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<String, String>();
                    }
                    hashMap.put(string2.toLowerCase(), string4.toLowerCase());
                }
            }
        }
        return hashMap;
    }

    private MethodInfo processColumnAnnotationInformation(MethodInfo methodInfo) {
        Set<String> set;
        Map<String, BeanInformation> map = methodInfo.getOutputBeanInfoMap();
        Set<String> set2 = set = map != null ? map.keySet() : null;
        if (set != null) {
            for (String string : set) {
                BeanInformation beanInformation = null;
                beanInformation = map.get(string);
                if (beanInformation == null) continue;
                NodeList nodeList = this.getElementsForEntityTag();
                List<String> list = beanInformation.getBeanInteritanceList();
                Map<String, String> map2 = this.getColumnOverrideMap(list, nodeList);
                for (int i10 = 0; i10 < list.size(); ++i10) {
                    String string2 = list.get(i10);
                    int n2 = this.getMatchingBeanIndex(string2, nodeList);
                    if (n2 == -1) {
                        return null;
                    }
                    Node node = nodeList.item(n2);
                    Node node2 = null;
                    NodeList nodeList2 = node.getChildNodes();
                    Node node3 = null;
                    Node node4 = null;
                    for (int i11 = 0; i11 <= nodeList2.getLength(); ++i11) {
                        node4 = nodeList2.item(i11);
                        if (this.ifNodeorNameisNull(node4) || !(node2 = nodeList2.item(i11)).getLocalName().equals(STR_ATTRIBUTES)) continue;
                        NodeList nodeList3 = node2.getChildNodes();
                        for (int i12 = 0; i12 <= nodeList3.getLength(); ++i12) {
                            String string3;
                            node3 = nodeList3.item(i12);
                            if (this.ifNodeorNameisNull(node3) || !node3.getLocalName().equals(STR_BASIC) && !node3.getLocalName().equals(STR_ID) || !node3.hasAttributes()) continue;
                            NamedNodeMap namedNodeMap = node3.getAttributes();
                            node4 = namedNodeMap.getNamedItem(STR_NAME);
                            String string4 = string3 = node4 != null ? node4.getNodeValue().toLowerCase() : null;
                            if (string3 == null) continue;
                            node4 = namedNodeMap.getNamedItem(STR_TABLE);
                            String string5 = node4 != null ? node4.getNodeValue().toLowerCase() : null;
                            NodeList nodeList4 = node3.getChildNodes();
                            for (int i13 = 0; i13 <= nodeList4.getLength(); ++i13) {
                                Node node5 = nodeList4.item(i13);
                                if (this.ifNodeorNameisNull(node5)) continue;
                                this.compareNamesAndSetBeanInfo(methodInfo, beanInformation, string3, string5, node5, map2);
                            }
                        }
                    }
                }
            }
        }
        return methodInfo;
    }

    private void compareNamesAndSetBeanInfo(MethodInfo methodInfo, BeanInformation beanInformation, String string, String string2, Node node, Map<String, String> map) {
        String string3 = null;
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(STR_NAME);
            String string4 = node2 != null ? node2.getNodeValue() : null;
            BeanPropertyInformation beanPropertyInformation = beanInformation.getPropertyUsingCaseInSensitiveName(string, string2, false);
            String string5 = string.toLowerCase();
            if (beanPropertyInformation == null) {
                return;
            }
            if (map != null && (string3 = map.get(string5)) != null) {
                this.overridePropertyInBeanInfo(methodInfo, string3, beanInformation, beanPropertyInformation);
            } else if (string4 != null && !string4.equalsIgnoreCase(string5)) {
                this.overridePropertyInBeanInfo(methodInfo, string4, beanInformation, beanPropertyInformation);
            }
        }
    }

    private void overridePropertyInBeanInfo(MethodInfo methodInfo, String string, BeanInformation beanInformation, BeanPropertyInformation beanPropertyInformation) {
        String string2 = beanPropertyInformation.getCaseSensitivePropertyName();
        if (string2 != null) {
            BeanPropertyInformation beanPropertyInformation2 = new BeanPropertyInformation();
            beanPropertyInformation2.setCaseSensitivePropertyName(string);
            beanPropertyInformation2.setDerivedProperty(true);
            beanPropertyInformation2.setField(beanPropertyInformation.getField());
            beanPropertyInformation2.setReadMethod(beanPropertyInformation.getReadMethod());
            beanPropertyInformation2.setWriteMethod(beanPropertyInformation.getWriteMethod());
            beanPropertyInformation2.setPropertyTypeInfo(beanPropertyInformation.getPropertyTypeInfo());
            beanInformation.addBeanPropertyMap(string.toLowerCase(), beanPropertyInformation2);
        }
    }

    private NodeList getElementsForEntityTag() {
        Element element = this.document_.getDocumentElement();
        String string = element.getPrefix();
        String string2 = string != null ? string + ":" + STR_ENTITY : STR_ENTITY;
        NodeList nodeList = element.getElementsByTagName(string2);
        return nodeList;
    }

    private int getMatchingBeanIndex(String string, NodeList nodeList) {
        String string2 = null;
        int n2 = -1;
        for (int i10 = 0; i10 < nodeList.getLength(); ++i10) {
            Node node;
            Node node2 = nodeList.item(i10);
            if (node2 == null || !node2.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = node = namedNodeMap != null ? namedNodeMap.getNamedItem(STR_CLASS) : null;
            if (node != null) {
                string2 = node.getNodeValue();
            }
            if (!string.equals(string2)) continue;
            n2 = i10;
            break;
        }
        return n2;
    }

    private static MethodInfo matchXmlMethodNameToInterface(List<MethodInfo> list, String string) {
        if (null != list) {
            for (MethodInfo methodInfo : list) {
                if (!string.equals(methodInfo.getMethodNameAndParameterTypesString())) continue;
                return methodInfo;
            }
        }
        return null;
    }
}

