/*
 * Decompiled with CFR 0.152.
 */
package com.help.feign.analysis;

import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.util.BeanConvert;
import com.help.exception.HelpHystrixBadRequestException;
import com.help.feign.IHelpFeignBusinessExceptionAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class HelpInvocationResultFeignAnalysis
implements IHelpFeignBusinessExceptionAnalysis {
    Logger logger = LoggerFactory.getLogger(HelpInvocationResultFeignAnalysis.class);

    @Override
    public RuntimeException analysis(@NonNull Object object) {
        if (object instanceof InvocationResult) {
            InvocationResult invocationResult = (InvocationResult)object;
            if (!UnifyErrorCode.SUCCESS.getCode().equals(invocationResult.getState())) {
                this.logger.warn("HTTP\u901a\u8baf\u670d\u52a1\u7aef\u6267\u884c\u5f02\u5e38: {}", (Object)BeanConvert.toJson((Object)object));
                return new HelpHystrixBadRequestException(UnifyErrorCode.parse((String)invocationResult.getState()), invocationResult.getCustomState(), invocationResult.getMessage());
            }
            return null;
        }
        return null;
    }
}

