/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.autoconfig.HelpWebAutoConfiguration;
import com.help.feign.IHelpFeignBusinessExceptionAnalysis;
import com.help.feign.analysis.HelpInvocationResultFeignAnalysis;
import com.help.feign.coder.HelpFeignErrorDecoder;
import com.help.feign.coder.HelpFeignResponseDecoder;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={HelpWebAutoConfiguration.class, FeignAutoConfiguration.class})
@ConditionalOnClass(value={Feign.class})
@ConditionalOnBean(value={FeignContext.class})
public class HelpFeignAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HelpFeignErrorDecoder helpFeignErrorDecoder() {
        return new HelpFeignErrorDecoder();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="help.context", name={"auto-error-throw"}, havingValue="true", matchIfMissing=true)
    public HelpFeignResponseDecoder helpFeignResponseDecoder(@Autowired(required=false) List<IHelpFeignBusinessExceptionAnalysis> analysisList, ObjectFactory<HttpMessageConverters> messageConverters) {
        return new HelpFeignResponseDecoder(analysisList, (Decoder)new SpringDecoder(messageConverters));
    }

    @Bean
    @ConditionalOnMissingBean
    public HelpInvocationResultFeignAnalysis helpInvocationResultFeignAnalysis() {
        return new HelpInvocationResultFeignAnalysis();
    }

    @Bean
    @ConditionalOnMissingBean(value={Logger.Level.class})
    public Logger.Level loggerLevel() {
        return Logger.Level.BASIC;
    }
}

