/*
 * Decompiled with CFR 0.152.
 */
package com.help.autoconfig;

import com.help.aop.FeignHelpExceptionAspect;
import com.help.autoconfig.HelpWebAutoConfiguration;
import com.help.feign.encoder.HelpFeighFormEncoder;
import com.help.feign.encoder.HelpFeignInvocationDecoder;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={HelpWebAutoConfiguration.class, FeignAutoConfiguration.class})
@ConditionalOnClass(value={Feign.class})
@ConditionalOnBean(value={FeignContext.class})
public class HelpFeignAutoConfiguration {
    @Autowired
    ObjectFactory<HttpMessageConverters> messageConverters;

    @Bean
    @ConditionalOnMissingBean
    public Encoder helpFeighFormEncoder() {
        return new HelpFeighFormEncoder(new SpringEncoder(this.messageConverters));
    }

    @Bean
    @ConditionalOnMissingBean
    public Decoder feignDecoder() {
        return new HelpFeignInvocationDecoder((Decoder)new SpringDecoder(this.messageConverters));
    }

    @Bean
    @ConditionalOnMissingBean(value={Logger.Level.class})
    public Logger.Level loggerLevel() {
        return Logger.Level.BASIC;
    }

    @Bean
    @ConditionalOnMissingBean
    public FeignHelpExceptionAspect feignHelpExceptionAspect() {
        return new FeignHelpExceptionAspect();
    }
}

