/*
 * Decompiled with CFR 0.152.
 */
package com.help.aop;

import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.Ordered;

@Aspect
public class FeignHelpExceptionAspect
implements Ordered {
    @Pointcut(value="@within(org.springframework.cloud.openfeign.FeignClient) && execution(public com.help.common.InvocationResult+ *(..)) ")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object execute(ProceedingJoinPoint pjp) throws Throwable {
        return pjp.proceed();
    }

    @AfterReturning(pointcut="pointCut()", returning="returnVal")
    public void afterReturn(InvocationResult returnVal) {
        if (returnVal != null) {
            InvocationResult result = returnVal;
            if (!UnifyErrorCode.SUCCESS.getCode().equalsIgnoreCase(result.getState())) {
                throw new UnifyException(result.getState(), result.getMessage());
            }
        }
    }

    public int getOrder() {
        return 110;
    }
}

