/*
 * Decompiled with CFR 0.152.
 */
package com.help.validator;

import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.Convert;
import com.help.common.util.StringUtil;
import com.help.common.validate.Range;
import com.help.common.validate.intf.IFieldValidator;
import com.help.validator.HelpValidator;
import java.lang.reflect.Field;
import java.math.BigDecimal;

public class RangeFieldValidator
implements IFieldValidator<Range, Object> {
    public void validate(Field field, Object value, Object entity, Range anno) {
        if (field.getType().isPrimitive() || field.getType().equals(String.class) || Number.class.isAssignableFrom(field.getType())) {
            BigDecimal v = Convert.toBigDecimal((Object)value);
            if (v.compareTo(new BigDecimal(anno.max())) > 0 || v.compareTo(new BigDecimal(anno.min())) < 0) {
                String msg = anno.error();
                String name = HelpValidator.getFieldName(field);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new UnifyValidateException(msg.replace("{0}", name).replace("{1}", String.valueOf(anno.min())).replace("{2}", String.valueOf(anno.max())));
                }
                throw new UnifyValidateException(name + "\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            }
        } else {
            throw new UnifyException("\u5728\u5b57\u6bb5" + HelpValidator.getFieldName(field) + "\u4e0a\u8fdb\u884c\u6570\u636e\u9a8c\u8bc1\u5931\u8d25!Range\u9a8c\u8bc1\u53ea\u80fd\u7528\u5728\u57fa\u672c\u7c7b\u578b,\u5b57\u7b26\u4e32\u53ca\u6570\u5b57\u7684\u5305\u88c5\u7c7b");
        }
    }
}

