/*
 * Decompiled with CFR 0.152.
 */
package com.help.validator;

import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.common.validate.Length;
import com.help.common.validate.intf.IFieldValidator;
import com.help.validator.HelpValidator;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import org.springframework.beans.factory.annotation.Value;

public class LengthFieldValidator
implements IFieldValidator<Length, Object> {
    @Value(value="${spring.datasource.db_charset:utf-8}")
    private String charset;

    public void validate(Field field, Object value, Object entity, Length anno) {
        if (field.getType().equals(String.class)) {
            if (StringUtil.isNotEmpty((Object)value)) {
                int strLength = 0;
                if (anno.dbmode()) {
                    try {
                        strLength = value.toString().getBytes(this.charset).length;
                    }
                    catch (UnsupportedEncodingException e) {
                        strLength = value.toString().length();
                    }
                } else {
                    strLength = value.toString().length();
                }
                if (anno.min() > -1 && strLength < anno.min()) {
                    String msg = anno.error();
                    if (StringUtil.isNotEmpty((String)msg)) {
                        String name = HelpValidator.getFieldName(field);
                        if (anno.dbmode()) {
                            throw new UnifyValidateException(msg.replace("{0}", name).replace("{1}", anno.min() <= 0 ? "0" : String.valueOf(anno.min()) + "(" + this.charset + "\u5b57\u8282)").replace("{2}", String.valueOf(anno.max()) + "(" + this.charset + "\u5b57\u8282)"));
                        }
                        throw new UnifyValidateException(msg.replace("{0}", name).replace("{1}", anno.min() <= 0 ? "0" : String.valueOf(anno.min())).replace("{2}", String.valueOf(anno.max())));
                    }
                    throw new UnifyValidateException(HelpValidator.getFieldName(field) + "\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
                }
                if (strLength > anno.max()) {
                    String msg = anno.error();
                    if (StringUtil.isNotEmpty((String)msg)) {
                        String name = HelpValidator.getFieldName(field);
                        if (anno.dbmode()) {
                            throw new UnifyValidateException(msg.replace("{0}", name).replace("{1}", anno.min() <= 0 ? "0" : String.valueOf(anno.min()) + "(" + this.charset + "\u5b57\u8282)").replace("{2}", String.valueOf(anno.max()) + "(" + this.charset + "\u5b57\u8282)"));
                        }
                        throw new UnifyValidateException(msg.replace("{0}", name).replace("{1}", anno.min() <= 0 ? "0" : String.valueOf(anno.min())).replace("{2}", String.valueOf(anno.max())));
                    }
                    throw new UnifyValidateException(HelpValidator.getFieldName(field) + "\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
                }
            }
        } else {
            throw new UnifyException("\u5728\u5b57\u6bb5" + HelpValidator.getFieldName(field) + "\u4e0a\u8fdb\u884c\u6570\u636e\u9a8c\u8bc1\u5931\u8d25!Length\u9a8c\u8bc1\u53ea\u80fd\u7528\u5728String\u7c7b\u578b");
        }
    }
}

