/*
 * Decompiled with CFR 0.152.
 */
package com.help.validator;

import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.common.util.reflect.ReflectUtil;
import com.help.common.validate.Name;
import com.help.common.validate.ValidateAnnotation;
import com.help.common.validate.intf.IFieldValidator;
import com.help.common.validate.intf.IModuleValidator;
import com.help.common.validate.intf.IValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class HelpValidator {
    @Autowired
    private ApplicationContext applicationContext;
    private ThreadLocal<Map<ValidateAnnotation, Set<IFieldValidator>>> fieldValidatorMap = new ThreadLocal();
    private ThreadLocal<Map<ValidateAnnotation, Set<IModuleValidator>>> moduleValidatorMap = new ThreadLocal();

    private static boolean hasChild(Class<?> clazz) {
        return !clazz.isPrimitive() && !String.class.isAssignableFrom(clazz) && !Boolean.class.isAssignableFrom(clazz) && !Character.class.isAssignableFrom(clazz) && !Byte.class.isAssignableFrom(clazz) && !Short.class.isAssignableFrom(clazz) && !Integer.class.isAssignableFrom(clazz) && !Long.class.isAssignableFrom(clazz) && !Float.class.isAssignableFrom(clazz) && !Double.class.isAssignableFrom(clazz) && !Void.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz) && !Collection.class.isAssignableFrom(clazz) && !Date.class.isAssignableFrom(clazz) && !BigDecimal.class.isAssignableFrom(clazz) && !clazz.isArray();
    }

    public void validateForException(Object obj) {
        ValidateHolder holder = new ValidateHolder();
        this.validate(obj, holder);
        if (holder.hasError()) {
            throw new UnifyValidateException(holder.getError());
        }
    }

    public boolean validate(Object obj) {
        ValidateHolder holder = new ValidateHolder();
        this.validate(obj, holder);
        return !holder.hasError();
    }

    public void validate(Object obj, ValidateHolder holder) {
        if (obj == null) {
            throw new UnifyException("\u6a21\u578b\u9a8c\u8bc1\u5931\u8d25,\u4e0d\u80fd\u5bf9\u7a7a\u5bf9\u8c61\u8fdb\u884c\u6a21\u578b\u9a8c\u8bc1");
        }
        if (!holder.validated.contains(obj)) {
            holder.validated.add(obj);
            for (Annotation a : obj.getClass().getAnnotations()) {
                ValidateAnnotation valAnno = a.annotationType().getAnnotation(ValidateAnnotation.class);
                if (valAnno == null) continue;
                Set<IModuleValidator> validators = this.getModuleValidators(valAnno);
                for (IModuleValidator iModuleValidator : validators) {
                    try {
                        iModuleValidator.validate(obj, a);
                    }
                    catch (UnifyValidateException e) {
                        holder.addError("object", e.getMessage());
                    }
                }
            }
            if (HelpValidator.hasChild(obj.getClass())) {
                Field[] allFields;
                for (Field f : allFields = ReflectUtil.getAllFields(obj.getClass())) {
                    Annotation[] ans;
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    ArrayList<Annotation> annos = new ArrayList<Annotation>();
                    for (Annotation a : ans = f.getAnnotations()) {
                        if (a.annotationType().getAnnotation(ValidateAnnotation.class) == null) continue;
                        annos.add(a);
                    }
                    for (Annotation anno : annos) {
                        try {
                            this.validate(obj, f, f.get(obj), anno, holder);
                        }
                        catch (UnifyException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new UnifyException("\u5728\u5b57\u6bb5" + HelpValidator.getFieldName(f) + "\u4e0a\u8fdb\u884c\u6570\u636e\u9a8c\u8bc1\u5931\u8d25!", (Throwable)e);
                        }
                    }
                    try {
                        Object object;
                        Object var10_16 = null;
                        if (!HelpValidator.hasChild(f.getType()) || (object = f.get(obj)) == null) continue;
                        this.validate(object, holder);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void validate(Object obj, Field field, Object value, Annotation annotation, ValidateHolder holder) {
        ValidateAnnotation validAnno = annotation.annotationType().getAnnotation(ValidateAnnotation.class);
        if ((value == null || value instanceof String && "".equals(value)) && !validAnno.nullable()) {
            return;
        }
        Set<IFieldValidator> validators = this.getFieldValidators(validAnno);
        if (validators.size() > 0) {
            for (IFieldValidator validator : validators) {
                try {
                    validator.validate(field, value, obj, annotation);
                }
                catch (UnifyValidateException e) {
                    holder.addError(HelpValidator.getFieldName(field), e.getMessage());
                }
            }
        }
    }

    private Set<IFieldValidator> getFieldValidators(ValidateAnnotation annotation) {
        Set<IFieldValidator> set;
        Map<ValidateAnnotation, Set<IFieldValidator>> map = this.fieldValidatorMap.get();
        if (map == null) {
            map = new HashMap<ValidateAnnotation, Set<IFieldValidator>>();
            this.fieldValidatorMap.set(map);
        }
        if ((set = map.get(annotation)) == null) {
            String[] clzNames;
            set = new HashSet<IFieldValidator>();
            Class[] clz = annotation.value();
            if (clz != null && clz.length > 0) {
                for (Class c : clz) {
                    try {
                        IValidator bean = (IValidator)this.applicationContext.getBean(c);
                        if (bean == null || !(bean instanceof IFieldValidator)) continue;
                        set.add((IFieldValidator)bean);
                    }
                    catch (Exception e) {
                        throw new UnifyException("\u9a8c\u8bc1\u7c7b[" + c + "]\u4e0d\u5b58\u5728");
                    }
                }
            }
            if ((clzNames = annotation.className()) != null && clzNames.length > 0) {
                for (String n : annotation.className()) {
                    try {
                        Class<?> c = Class.forName(n);
                        Object bean = this.applicationContext.getBean(c);
                        if (bean == null || !(bean instanceof IFieldValidator)) continue;
                        set.add((IFieldValidator)bean);
                    }
                    catch (Exception e) {
                        throw new UnifyException("\u9a8c\u8bc1\u7c7b[" + n + "]\u4e0d\u5b58\u5728");
                    }
                }
            }
            map.put(annotation, set);
        }
        return set;
    }

    private Set<IModuleValidator> getModuleValidators(ValidateAnnotation annotation) {
        Set<IModuleValidator> set;
        Map<ValidateAnnotation, Set<IModuleValidator>> map = this.moduleValidatorMap.get();
        if (map == null) {
            map = new HashMap<ValidateAnnotation, Set<IModuleValidator>>();
            this.moduleValidatorMap.set(map);
        }
        if ((set = map.get(annotation)) == null) {
            String[] clzNames;
            set = new HashSet<IModuleValidator>();
            Class[] clz = annotation.value();
            if (clz != null && clz.length > 0) {
                for (Class c : clz) {
                    try {
                        IValidator bean = (IValidator)this.applicationContext.getBean(c);
                        if (bean == null || !(bean instanceof IModuleValidator)) continue;
                        set.add((IModuleValidator)bean);
                    }
                    catch (Exception e) {
                        throw new UnifyException("\u9a8c\u8bc1\u7c7b[" + c + "]\u4e0d\u5b58\u5728");
                    }
                }
            }
            if ((clzNames = annotation.className()) != null && clzNames.length > 0) {
                for (String n : annotation.className()) {
                    try {
                        Class<?> c = Class.forName(n);
                        Object bean = this.applicationContext.getBean(c);
                        if (bean == null || !(bean instanceof IModuleValidator)) continue;
                        set.add((IModuleValidator)bean);
                    }
                    catch (Exception e) {
                        throw new UnifyException("\u9a8c\u8bc1\u7c7b[" + n + "]\u4e0d\u5b58\u5728");
                    }
                }
            }
            map.put(annotation, set);
        }
        return set;
    }

    public static String getFieldName(Field field) {
        Name n = field.getAnnotation(Name.class);
        if (n != null) {
            return "[" + n.value() + "(" + field.getName() + ")]";
        }
        return "[" + field.getName() + "]";
    }

    public static class ValidateHolder {
        private Map<String, String> error = new HashMap<String, String>();
        public List<Object> validated = new ArrayList<Object>();

        public Map<String, String> getError() {
            return this.error;
        }

        public void setError(Map<String, String> error) {
            this.error = error;
        }

        public void addError(String field, String msg) {
            String old = this.error.get(field);
            old = StringUtil.isEmpty((String)old) ? msg : old + "," + msg;
            this.error.put(field, old);
        }

        public boolean hasError() {
            return this.error.size() > 0;
        }
    }
}

