/*
 * Decompiled with CFR 0.152.
 */
package com.help.validator;

import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.Compare;
import com.help.common.util.StringUtil;
import com.help.common.validate.DateRange;
import com.help.common.validate.intf.IFieldValidator;
import com.help.validator.HelpValidator;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateRangeFieldValidator
implements IFieldValidator<DateRange, Object> {
    public void validate(Field field, Object value, Object entity, DateRange anno) {
        if (field.getType().equals(String.class) || field.getType().equals(Date.class)) {
            SimpleDateFormat format = new SimpleDateFormat(anno.format());
            Date date = null;
            Date begin = null;
            Date end = null;
            if (value instanceof Date) {
                date = (Date)value;
            } else {
                try {
                    date = format.parse(value.toString());
                }
                catch (ParseException e) {
                    String name = HelpValidator.getFieldName(field);
                    throw new UnifyValidateException(name + "\u4e0d\u662f\u6709\u6548\u7684\u65e5\u671f\u683c\u5f0f");
                }
            }
            try {
                begin = format.parse(anno.min());
                end = format.parse(anno.max());
            }
            catch (ParseException e) {
                throw new UnifyException("\u5728\u5b57\u6bb5" + HelpValidator.getFieldName(field) + "\u4e0a\u8fdb\u884c\u6570\u636e\u9a8c\u8bc1\u5931\u8d25!DateRange\u9a8c\u8bc1\u53ea\u80fd\u7528\u5728\u65e5\u671f\u7c7b\u578b\u6216\u65e5\u671f\u578b\u5b57\u7b26\u4e32");
            }
            if (Compare.before((Date)date, (Date)begin) || Compare.after((Date)date, (Date)end)) {
                String msg = anno.error();
                String name = HelpValidator.getFieldName(field);
                if (StringUtil.isNotEmpty((String)msg)) {
                    throw new UnifyValidateException(msg.replace("{0}", name).replace("{1}", anno.min()).replace("{2}", anno.max()));
                }
                throw new UnifyValidateException(HelpValidator.getFieldName(field) + "\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            }
        } else {
            throw new UnifyException("\u5728\u5b57\u6bb5" + HelpValidator.getFieldName(field) + "\u4e0a\u8fdb\u884c\u6570\u636e\u9a8c\u8bc1\u5931\u8d25!DateRange\u9a8c\u8bc1\u53ea\u80fd\u7528\u5728\u65e5\u671f\u7c7b\u578b\u6216\u65e5\u671f\u578b\u5b57\u7b26\u4e32");
        }
    }
}

