/*
 * Decompiled with CFR 0.152.
 */
package com.help.storage;

import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.FileUtil;
import com.help.common.util.StreamUtils;
import com.help.common.util.StringUtil;
import com.help.storage.IFileStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class LocalFileStorage
implements IFileStorage {
    private String root;

    public LocalFileStorage(String root) {
        if (StringUtil.isEmpty((String)root)) {
            root = "/";
        }
        if (!root.endsWith("/") && !root.endsWith("\\")) {
            root = root + File.separatorChar;
        }
        this.root = root;
    }

    private String getFileName(String id) {
        String dir = this.root + id.substring(id.length() - 3);
        FileUtil.mkdir((String)dir);
        return dir + File.separatorChar + id;
    }

    public String save(byte[] file, String originalFileName) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(file);
        return this.save(byteArrayInputStream, originalFileName);
    }

    public String save(InputStream is, String originalFileName) {
        return this.save(is, originalFileName, -1L);
    }

    public String save(InputStream is, String originalFileName, long size) {
        String id = UUID.randomUUID().toString().replace("-", "");
        int count = this.save(is, originalFileName, id);
        if (size != -1L && size != (long)count) {
            this.delete(id);
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25,\u6587\u4ef6\u5b9e\u9645\u5c3a\u5bf8[" + count + "]\u4e0e\u9884\u5b9a\u5c3a\u5bf8[" + size + "]\u4e0d\u76f8\u7b49");
        }
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int save(InputStream is, String originalFileName, String id) {
        try (FileOutputStream fos = new FileOutputStream(this.getFileName(id));){
            int n = StreamUtils.copy((InputStream)is, (OutputStream)fos);
            return n;
        }
        catch (Exception e) {
            throw new UnifyException(UnifyErrorCode.UNKNOW_FAIL, "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25:[" + e.getMessage() + "]");
        }
    }

    public void delete(String fileId) {
        File file = new File(this.getFileName(fileId));
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] get(String fileId) {
        try (InputStream is = this.getInputStream(fileId);){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new UnifyException("\u6587\u4ef6[" + fileId + "]\u8bfb\u53d6\u5931\u8d25");
        }
    }

    public InputStream getInputStream(String fileId) {
        try {
            return new FileInputStream(this.getFileName(fileId));
        }
        catch (FileNotFoundException e) {
            throw new UnifyException(UnifyErrorCode.NON_DATA, "\u6587\u4ef6[" + fileId + "]\u4e0d\u5b58\u5728");
        }
    }

    public long getSize(String fileId) {
        File file = new File(this.getFileName(fileId));
        if (file.exists()) {
            return file.length();
        }
        throw new UnifyException("\u6587\u4ef6[" + fileId + "]\u4e0d\u5b58\u5728");
    }

    public void setPermission(boolean publicRead, String ... fileIds) {
    }
}

