/*
 * Decompiled with CFR 0.152.
 */
package com.help.logger.http.server;

import com.help.common.util.BeanConvert;
import com.help.common.util.StreamUtils;
import com.help.filter.RepeatedlyReadRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.MediaType;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class HelpServerRequestInfoPrinter
extends OncePerRequestFilter {
    private Logger logger = LoggerFactory.getLogger(HelpServerRequestInfoPrinter.class);
    private String mdcKey = "request-url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filter) throws ServletException, IOException {
        RepeatedlyReadRequestWrapper requestWrapper;
        boolean match;
        block17: {
            match = false;
            requestWrapper = null;
            try {
                AntPathMatcher antPathMatcher = new AntPathMatcher();
                String url = request.getRequestURI();
                if (antPathMatcher.match("/**/actuator/**", url) || url.endsWith(".js") || url.endsWith(".gif") || url.endsWith(".jpg") || url.endsWith(".bmp") || url.endsWith(".jpeg") || url.endsWith(".png") || url.endsWith(".css") || url.endsWith(".ico") || url.endsWith(".html") || url.endsWith(".woff") || url.endsWith(".woff2")) break block17;
                match = true;
                String fullUrl = request.getRequestURL().toString();
                MDC.put((String)this.mdcKey, (String)fullUrl);
                this.logger.info(request.getMethod() + " => " + fullUrl);
                if (!this.logger.isDebugEnabled()) break block17;
                StringBuffer sb = new StringBuffer();
                sb.append("\n------------Header------------\n");
                Enumeration headerKey = request.getHeaderNames();
                while (headerKey.hasMoreElements()) {
                    String k = (String)headerKey.nextElement();
                    String v = request.getHeader(k);
                    sb.append(k + "=" + v + "\n");
                }
                sb.append("------------Body------------\n");
                MediaType media = null;
                try {
                    media = MediaType.valueOf((String)request.getContentType());
                }
                catch (Exception e) {
                    media = null;
                }
                if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(media)) {
                    sb.append(BeanConvert.toJson((Object)request.getParameterMap()));
                    sb.append("\n");
                } else if (MediaType.APPLICATION_JSON.isCompatibleWith(media)) {
                    requestWrapper = new RepeatedlyReadRequestWrapper(request, 2);
                    sb.append(StreamUtils.copyToString((InputStream)requestWrapper.getInputStream(), (Charset)Charset.forName(request.getCharacterEncoding())));
                    sb.append("\n");
                }
                sb.append("------------End------------\n");
                this.logger.debug(sb.toString());
            }
            catch (Exception e) {
                this.logger.warn("\u8bf7\u6c42\u65e5\u5fd7\u8f93\u51fa\u5931\u8d25", (Throwable)e);
            }
        }
        long startTime = System.currentTimeMillis();
        try {
            if (requestWrapper == null) {
                filter.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                filter.doFilter(requestWrapper, (ServletResponse)response);
            }
        }
        finally {
            MDC.remove((String)this.mdcKey);
            if (match) {
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > 800L) {
                    this.logger.warn("\u8bf7\u6c42\u6267\u884c\u65f6\u95f4\u8fc7\u957f,\u82b1\u8d39\u4e86[{}]\u6beb\u79d2", (Object)(endTime - startTime));
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u8bf7\u6c42\u6267\u884c\u82b1\u8d39\u4e86[{}]\u6beb\u79d2", (Object)(endTime - startTime));
                }
            }
        }
    }
}

