/*
 * Decompiled with CFR 0.152.
 */
package com.help.logger.http.resttemplate;

import com.help.common.MediaTypeUtil;
import com.help.common.util.StreamUtils;
import com.help.common.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class HelpRestTemplateLoggerInterceptor
implements ClientHttpRequestInterceptor {
    Logger logger = LoggerFactory.getLogger(HelpRestTemplateLoggerInterceptor.class);
    int maxLength;

    public HelpRestTemplateLoggerInterceptor(int maxLength) {
        this.maxLength = maxLength;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} => {}", (Object)request.getMethod().name(), (Object)request.getURI());
            if (this.logger.isDebugEnabled()) {
                try {
                    HttpHeaders headers = request.getHeaders();
                    StringBuffer sb = new StringBuffer();
                    sb.append("\r\n--------------Header---------------\r\n");
                    for (String k : headers.keySet()) {
                        if (headers.get((Object)k) == null) continue;
                        sb.append(k);
                        sb.append("=");
                        sb.append(StringUtil.join((Iterable)headers.get((Object)k), (String)","));
                        sb.append("\r\n");
                    }
                    sb.append("--------------Body---------------\r\n");
                    MediaType contentType = headers.getContentType();
                    if (MediaType.APPLICATION_FORM_URLENCODED.isCompatibleWith(contentType) || MediaType.APPLICATION_JSON.isCompatibleWith(contentType)) {
                        sb.append(new String(body, MediaTypeUtil.charset(contentType, Charset.forName("UTF-8"))));
                        sb.append("\n");
                    }
                    sb.append("\r\n--------------End---------------\r\n");
                    this.logger.debug(sb.toString());
                }
                catch (Exception headers) {
                    // empty catch block
                }
            }
            ClientHttpResponse resp = null;
            long start = System.currentTimeMillis();
            try {
                resp = execution.execute(request, body);
                int status = resp != null ? resp.getStatusCode().value() : -1;
                this.logger.info("HTTP\u54cd\u5e94\u72b6\u6001 => [{}] {}ms", (Object)status, (Object)(System.currentTimeMillis() - start));
                if (this.logger.isDebugEnabled() && resp != null) {
                    MediaType mediaType = resp.getHeaders().getContentType();
                    if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType) || MediaType.TEXT_PLAIN.isCompatibleWith(mediaType) || MediaType.TEXT_HTML.isCompatibleWith(mediaType)) {
                        byte[] data = StreamUtils.copyToByteArray((InputStream)resp.getBody());
                        Charset charset = MediaTypeUtil.charset(mediaType, Charset.forName("UTF-8"));
                        this.logger.debug("\r\n--------------HTTP\u54cd\u5e94\u4f53---------------\r\n{} {}\r\n--------------End---------------", (Object)new String(data, 0, this.maxLength > data.length ? data.length : this.maxLength, charset), (Object)(this.maxLength > data.length ? "" : "...(\u5df2\u7701\u7565)"));
                        return new HelpClientHttpRequestInterceptorWrapper(data, resp);
                    }
                    this.logger.debug("HTTP\u54cd\u5e94\u62a5\u6587\u4f53\u4e0d\u53ef\u8bfb");
                }
                return resp;
            }
            catch (Exception e) {
                this.logger.info("HTTP\u54cd\u5e94\u72b6\u6001 => [{}] {}ms", (Object)(resp != null ? resp.getStatusCode().value() : -1), (Object)(System.currentTimeMillis() - start));
                throw e;
            }
        }
        return execution.execute(request, body);
    }

    private static class HelpClientHttpRequestInterceptorWrapper
    implements ClientHttpResponse {
        ClientHttpResponse resp;
        ByteArrayInputStream bis;
        boolean useProxyStream;

        public HelpClientHttpRequestInterceptorWrapper(byte[] data, ClientHttpResponse resp) {
            this.resp = resp;
            this.bis = new ByteArrayInputStream(data);
        }

        public HttpStatus getStatusCode() throws IOException {
            return this.resp.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.resp.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.resp.getStatusText();
        }

        public void close() {
            this.resp.close();
            this.useProxyStream = true;
            try {
                this.bis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public InputStream getBody() throws IOException {
            if (this.useProxyStream) {
                return this.resp.getBody();
            }
            return this.bis;
        }

        public HttpHeaders getHeaders() {
            return this.resp.getHeaders();
        }
    }
}

