/*
 * Decompiled with CFR 0.152.
 */
package com.help.handler;

import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.exception.UnifyValidateException;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpHttpExceptionHandler;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public class HelpDefaultHttpExceptionHandler
implements IHelpHttpExceptionHandler<InvocationResult> {
    Logger logger = LoggerFactory.getLogger(HelpDefaultHttpExceptionHandler.class);

    public boolean support(Class<InvocationResult> clazz, Throwable e) {
        return InvocationResult.class.isAssignableFrom(clazz);
    }

    public Object handler(HttpServletRequest request, Throwable exp, Class<InvocationResult> clazz) {
        if (exp instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException exception = (MissingServletRequestParameterException)exp;
            String name = exception.getParameterName();
            String value = request.getParameter(name);
            String msg = null;
            msg = StringUtil.isNotEmpty((String)value) ? "\u8bf7\u6c42\u53c2\u6570[" + name + "]\u7684\u503c[" + value + "]\u65e0\u6cd5\u5339\u914d\u5230\u63a5\u53e3" : "\u8bf7\u6c42\u53c2\u6570[" + name + "]\u4e0d\u5b58\u5728";
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, msg);
        }
        if (exp instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException exception = (MethodArgumentTypeMismatchException)exp;
            String name = exception.getName();
            Object value = exception.getValue();
            String msg = "\u8bf7\u6c42\u53c2\u6570[" + name + "]\u7684\u503c[" + value + "]\u65e0\u6cd5\u5339\u914d\u5230\u63a5\u53e3\u7684\u53c2\u6570\u7c7b\u578b" + exception.getRequiredType().getSimpleName();
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, msg);
        }
        if (exp instanceof MethodArgumentConversionNotSupportedException) {
            MethodArgumentConversionNotSupportedException exception = (MethodArgumentConversionNotSupportedException)exp;
            String name = exception.getName();
            Object value = exception.getValue();
            String msg = "\u8bf7\u6c42\u53c2\u6570[" + name + "]\u7684\u503c[" + value + "]\u65e0\u6cd5\u5339\u914d\u5230\u63a5\u53e3\u7684\u53c2\u6570\u7c7b\u578b" + exception.getRequiredType().getSimpleName();
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD, msg);
        }
        if (exp instanceof BindException) {
            return new InvocationResult(UnifyErrorCode.VALIDATE_FAILD);
        }
        if (exp instanceof UnifyValidateException) {
            UnifyValidateException e = (UnifyValidateException)exp;
            if (e.getError() != null) {
                this.logger.info("\u63a5\u53e3\u8c03\u7528\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25,\u9519\u8bef\u53c2\u6570[" + StringUtil.join(e.getError().keySet(), (String)",") + "]", (Throwable)e);
            } else {
                this.logger.info("\u63a5\u53e3\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            }
            return new InvocationResult((UnifyException)e);
        }
        if (exp instanceof UnifyException) {
            UnifyException e = (UnifyException)exp;
            if (e.getErrorCode().getLevel() < 3) {
                this.logger.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            } else if (e.getErrorCode().getLevel() < 4) {
                this.logger.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            } else {
                this.logger.warn("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:[" + e.getMessage() + "]", (Throwable)e);
            }
            return new InvocationResult(e);
        }
        if (exp instanceof DuplicateKeyException) {
            DuplicateKeyException e = (DuplicateKeyException)exp;
            this.logger.warn("\u6570\u636e\u5e93\u4e3b\u952e\u51b2\u7a81\u5f02\u5e38:[" + e.getMessage() + "]", (Throwable)e);
            return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "\u8bf7\u52ff\u5f55\u5165\u91cd\u590d\u6570\u636e");
        }
        if (exp instanceof DataAccessException) {
            DataAccessException e = (DataAccessException)exp;
            this.logger.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38:[" + e.getMessage() + "]", (Throwable)e);
            return new InvocationResult(UnifyErrorCode.BUSINESS_FAILD, "\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        if (exp instanceof ExecutionException) {
            return this.handler(request, exp.getCause(), clazz);
        }
        this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25,\u672a\u77e5\u9519\u8bef:[" + exp.getMessage() + "]", exp);
        return new InvocationResult(UnifyErrorCode.UNKNOW_FAIL);
    }
}

