/*
 * Decompiled with CFR 0.152.
 */
package com.help.filter.xss;

import com.help.common.util.StringUtil;
import com.help.constraint.IHelpXssFilter;
import com.help.filter.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class XssRequestFilter
extends OncePerRequestFilter {
    private Set<String> excludesPattern;
    private IHelpXssFilter filter;
    private String[] ignores;

    public XssRequestFilter(IHelpXssFilter filter, String[] exclusions, List<String> ignores) {
        if (exclusions != null && exclusions.length > 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions));
        }
        if (ignores != null) {
            this.ignores = ignores.stream().filter(p -> StringUtil.isNotEmpty((String)p)).map(p -> p.toLowerCase()).collect(Collectors.toList()).toArray(new String[0]);
        }
        this.filter = filter;
    }

    public boolean isExclusion(String requestURI) {
        if (this.excludesPattern == null || requestURI == null) {
            return false;
        }
        for (String pattern : this.excludesPattern) {
            if (!PatternMatchUtils.simpleMatch((String)pattern.toLowerCase(), (String)requestURI.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.isExclusion(httpServletRequest.getRequestURI())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            filterChain.doFilter((ServletRequest)new XssHttpServletRequestWrapper(this.filter, httpServletRequest, this.ignores), (ServletResponse)httpServletResponse);
        }
    }
}

