/*
 * Decompiled with CFR 0.152.
 */
package com.help.filter.xss;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpXssFilter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.PatternMatchUtils;

public class XssJsonStringDeserializer
extends JsonDeserializer<String> {
    String[] ignores;
    private IHelpXssFilter iHelpXssFilter;

    public XssJsonStringDeserializer(IHelpXssFilter iHelpXssFilter, List<String> ignores) {
        if (ignores != null) {
            this.ignores = ignores.stream().filter(p -> StringUtil.isNotEmpty((String)p)).map(p -> p.toLowerCase()).collect(Collectors.toList()).toArray(new String[0]);
        }
        this.iHelpXssFilter = iHelpXssFilter;
    }

    private boolean isIgnore(String name) {
        return this.ignores != null && this.ignores.length > 0 && StringUtil.isNotEmpty((String)name) && PatternMatchUtils.simpleMatch((String[])this.ignores, (String)name.toLowerCase());
    }

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this.isIgnore(p.getCurrentName())) {
            return p.getValueAsString();
        }
        return this.iHelpXssFilter.filter(p.getCurrentName(), p.getValueAsString());
    }
}

