/*
 * Decompiled with CFR 0.152.
 */
package com.help.filter.xss;

import com.help.common.IteratorEnumeration;
import com.help.common.util.StringUtil;
import com.help.constraint.IHelpXssFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.PatternMatchUtils;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest request;
    IHelpXssFilter filter;
    String[] ignores;

    public XssHttpServletRequestWrapper(IHelpXssFilter filter, HttpServletRequest request, String[] ignores) {
        super(request);
        this.request = request;
        this.ignores = ignores;
        this.filter = filter;
    }

    public String getParameter(String name) {
        if (this.isIgnore(name)) {
            return super.getParameter(name);
        }
        return this.clean(name, super.getParameter(name));
    }

    public Enumeration<String> getParameterNames() {
        return this.clean(null, super.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        if (this.isIgnore(name)) {
            return super.getParameterValues(name);
        }
        String[] values = super.getParameterValues(name);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (!StringUtil.isNotEmpty((String)values[i])) continue;
                values[i] = this.filter.filter(name, values[i]);
            }
        }
        return values;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public String getHeader(String name) {
        if (this.isIgnore(name)) {
            return super.getHeader(name);
        }
        return this.clean(name, super.getHeader(name));
    }

    public Enumeration<String> getHeaderNames() {
        return this.clean(null, super.getHeaderNames());
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.isIgnore(name)) {
            return super.getHeaders(name);
        }
        return this.clean(name, super.getHeaders(name));
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = super.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (this.isIgnore(c.getName())) continue;
                c.setValue(this.clean(c.getName(), c.getValue()));
            }
        }
        return cookies;
    }

    private boolean isIgnore(String name) {
        return this.ignores != null && this.ignores.length > 0 && StringUtil.isNotEmpty((String)name) && PatternMatchUtils.simpleMatch((String[])this.ignores, (String)name.toLowerCase());
    }

    private String clean(String name, String value) {
        if (StringUtil.isNotEmpty((String)value)) {
            return this.filter.filter(name, value);
        }
        return value;
    }

    private Enumeration<String> clean(String name, Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String value = enumeration.nextElement();
            names.add(this.clean(name, value));
        }
        return new IteratorEnumeration(names.iterator());
    }
}

