/*
 * Decompiled with CFR 0.152.
 */
package com.help.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class RepeatedlyReadRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] data;
    private int maxReadCount;
    private int currentReadCount;

    public RepeatedlyReadRequestWrapper(HttpServletRequest request, int maxReadCount) throws IOException {
        super(request);
        this.data = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
        this.maxReadCount = maxReadCount;
    }

    public ServletInputStream getInputStream() throws IOException {
        ++this.currentReadCount;
        byte[] temp = this.data;
        if (this.currentReadCount == this.maxReadCount) {
            this.data = null;
        }
        if (this.currentReadCount > this.maxReadCount) {
            throw new IllegalStateException("HttpServletRequest\u6570\u636e\u6d41\u5df2\u88ab\u8bfb\u5230\u6700\u5927\u6b21\u6570,\u65e0\u6cd5\u518d\u6b21\u8bfb\u53d6");
        }
        final ByteArrayInputStream bis = new ByteArrayInputStream(temp);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }

            public int read() throws IOException {
                return bis.read();
            }
        };
    }
}

