/*
 * Decompiled with CFR 0.152.
 */
package com.help.filter;

import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.BeanConvert;
import com.help.constraint.IHelpHttpExceptionHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

public class HelpGlobalExceptionHandleResolver
implements HandlerExceptionResolver,
Ordered {
    Logger logger = LoggerFactory.getLogger(HelpGlobalExceptionHandleResolver.class);
    List<IHelpHttpExceptionHandler> handlers;

    public HelpGlobalExceptionHandleResolver(List<IHelpHttpExceptionHandler> handlers) {
        this.handlers = handlers;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String msg = ex.getMessage();
        if (handler != null && handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Class<?> returnType = method.getReturnType();
            Object result = null;
            for (IHelpHttpExceptionHandler h : this.handlers) {
                if (h.support(returnType, (Throwable)ex) && (result = h.handler(request, (Throwable)ex, returnType)) != null) break;
            }
            if (result instanceof ModelAndView) {
                return (ModelAndView)result;
            }
            if (result != null) {
                Map map = BeanConvert.toMap(result, (String[])new String[0]);
                ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView(), map);
                mv.setStatus(HttpStatus.OK);
                return mv;
            }
        }
        this.logger.warn("HTTP\u8bf7\u6c42\u6267\u884c\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)ex);
        InvocationResult result = null;
        result = ex instanceof UnifyException ? new InvocationResult((UnifyException)ex) : new InvocationResult(UnifyErrorCode.UNKNOW_FAIL, msg);
        ModelAndView mv = new ModelAndView((View)new MappingJackson2JsonView(), BeanConvert.toMap((Object)result, (String[])new String[0]));
        mv.setStatus(HttpStatus.OK);
        return mv;
    }

    public int getOrder() {
        return 0;
    }
}

