/*
 * Decompiled with CFR 0.152.
 */
package com.help.aop;

import com.help.annotation.OperationLog;
import com.help.common.InvocationResult;
import com.help.common.exception.UnifyErrorCode;
import com.help.common.exception.UnifyException;
import com.help.common.util.StringUtil;
import com.help.constraint.IOperationRecordWritter;
import com.help.constraint.OperationRecord;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class HelpOperationRecordAspect
implements Ordered {
    private Logger logger = LoggerFactory.getLogger(HelpOperationRecordAspect.class);
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    @Autowired(required=false)
    List<IOperationRecordWritter> writters;
    @Autowired
    HttpServletRequest request;

    @Around(value=" @within(org.springframework.stereotype.Controller) && @annotation(com.help.annotation.OperationLog)|| @within(org.springframework.web.bind.annotation.RestController) &&  @annotation(com.help.annotation.OperationLog)")
    public Object execute(ProceedingJoinPoint pjp) throws Throwable {
        if (this.writters != null && this.writters.size() > 0) {
            Boolean succ = null;
            boolean requireRecord = true;
            try {
                Object obj = pjp.proceed();
                if (obj != null && obj instanceof InvocationResult && !UnifyErrorCode.SUCCESS.getCode().equalsIgnoreCase(((InvocationResult)obj).getState())) {
                    succ = false;
                }
                Object object = obj;
                return object;
            }
            catch (Exception e) {
                succ = false;
                if (e instanceof UnifyException && ((UnifyException)e).getErrorCode() == UnifyErrorCode.RQEUIRED_LOGIN) {
                    requireRecord = false;
                }
                throw e;
            }
            finally {
                if (requireRecord) {
                    Method method = ((MethodSignature)pjp.getSignature()).getMethod();
                    OperationLog operationLog = (OperationLog)AnnotationUtils.findAnnotation((Method)method, OperationLog.class);
                    String str = operationLog.value();
                    String[] params = null;
                    if (operationLog.spel() != null && operationLog.spel().length > 0 || StringUtil.isNotEmpty((String)operationLog.userSpel())) {
                        params = this.discoverer.getParameterNames(method);
                        for (int i = 0; i < operationLog.spel().length; ++i) {
                            String result = this.parseSpel(pjp.getArgs(), params, operationLog.spel()[i], "");
                            if (result == null) {
                                result = "";
                            }
                            str = str.replaceAll("\\{" + i + "\\}", result);
                        }
                    }
                    String userId = null;
                    if (StringUtil.isNotEmpty((String)operationLog.userSpel())) {
                        userId = this.parseSpel(pjp.getArgs(), params, operationLog.userSpel(), "");
                    }
                    if (succ == null && operationLog.succWhenUnThrow()) {
                        succ = true;
                    }
                    String ip = this.getIpAddr(this.request);
                    OperationRecord record = new OperationRecord();
                    record.setContent(str);
                    record.setGmtCreate(new Date());
                    record.setIpAddr(ip);
                    record.setOpType(operationLog.type());
                    record.setSuccess(succ);
                    record.setUserNo(userId);
                    record.setUrl(this.request.getRequestURI());
                    if (StringUtil.isNotEmpty((String)operationLog.customType())) {
                        record.setCustomType(operationLog.customType());
                    }
                    for (IOperationRecordWritter storage : this.writters) {
                        try {
                            storage.write(record);
                        }
                        catch (Exception e) {
                            this.logger.warn("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5668" + storage.getClass().getName() + "\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25 [" + str + "]");
                        }
                    }
                }
            }
        }
        return pjp.proceed();
    }

    private String parseSpel(Object[] arguments, String[] argumentNames, String spel, String defaultResult) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int len = 0; len < argumentNames.length; ++len) {
            context.setVariable(argumentNames[len], arguments[len]);
        }
        try {
            Expression expression = this.parser.parseExpression(spel);
            return (String)expression.getValue((EvaluationContext)context, String.class);
        }
        catch (Exception e) {
            return defaultResult;
        }
    }

    private String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && (ip = request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public int getOrder() {
        return 15;
    }
}

