package com.help.conditional;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Map;

/**
 * {@link Condition} 检查配置项是否是特定值或不存在
 *
 * @see ConditionalOnMatchOrEmpty
 */
@Order(Ordered.HIGHEST_PRECEDENCE + 40)
class OnMatchOrEmptyCondition extends SpringBootCondition {

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context,
                                            AnnotatedTypeMetadata metadata) {

        Map<String, Object> values = metadata.getAnnotationAttributes(ConditionalOnMatchOrEmpty.class.getName());
        String property = (String) values.get("value");
        String[] havingValue = (String[]) values.get("havingValue");

        Environment environment = context.getEnvironment();
        if (!environment.containsProperty(property)) {
            return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnMatchOrEmpty.class).because("matched"));
        }

        String value = environment.getProperty(property);

        for (String v : havingValue) {
            if (v != null && v.equals(value)) {
                return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnMatchOrEmpty.class).because("matched"));
            }
        }

        return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnMatchOrEmpty.class).because("value [" + value + "] not matched"));
    }

}
